/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.repository.management.model.MetadataReferenceType;
import io.gravitee.rest.api.model.ApiMetadataEntity;
import io.gravitee.rest.api.model.NewApiMetadataEntity;
import io.gravitee.rest.api.model.NewReferenceMetadataEntity;
import io.gravitee.rest.api.model.ReferenceMetadataEntity;
import io.gravitee.rest.api.model.UpdateApiMetadataEntity;
import io.gravitee.rest.api.model.UpdateReferenceMetadataEntity;
import io.gravitee.rest.api.service.ApiMetadataService;
import io.gravitee.rest.api.service.impl.AbstractReferenceMetadataService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class ApiMetadataServiceImpl
extends AbstractReferenceMetadataService
implements ApiMetadataService {
    @Override
    public List<ApiMetadataEntity> findAllByApi(String apiId) {
        List<ReferenceMetadataEntity> allMetadata = this.findAllByReference(MetadataReferenceType.API, apiId, true);
        return allMetadata.stream().map(m -> this.convert((ReferenceMetadataEntity)m, apiId)).collect(Collectors.toList());
    }

    @Override
    public ApiMetadataEntity findByIdAndApi(String metadataId, String apiId) {
        return this.convert(this.findByIdAndReference(metadataId, MetadataReferenceType.API, apiId, true), apiId);
    }

    @Override
    public void delete(String metadataId, String apiId) {
        this.delete(metadataId, MetadataReferenceType.API, apiId);
    }

    @Override
    public void deleteAllByApi(String apiId) {
        List<ReferenceMetadataEntity> allMetadata = this.findAllByReference(MetadataReferenceType.API, apiId, false);
        allMetadata.stream().forEach(referenceMetadataEntity -> this.delete(referenceMetadataEntity.getKey(), MetadataReferenceType.API, apiId));
    }

    @Override
    public ApiMetadataEntity create(NewApiMetadataEntity metadataEntity) {
        return this.convert(this.create((NewReferenceMetadataEntity)metadataEntity, MetadataReferenceType.API, metadataEntity.getApiId(), true), metadataEntity.getApiId());
    }

    @Override
    public ApiMetadataEntity update(UpdateApiMetadataEntity metadataEntity) {
        return this.convert(this.update((UpdateReferenceMetadataEntity)metadataEntity, MetadataReferenceType.API, metadataEntity.getApiId(), true), metadataEntity.getApiId());
    }

    private ApiMetadataEntity convert(ReferenceMetadataEntity m, String apiId) {
        ApiMetadataEntity apiMetadataEntity = new ApiMetadataEntity();
        apiMetadataEntity.setKey(m.getKey());
        apiMetadataEntity.setName(m.getName());
        apiMetadataEntity.setFormat(m.getFormat());
        apiMetadataEntity.setValue(m.getValue());
        apiMetadataEntity.setDefaultValue(m.getDefaultValue());
        apiMetadataEntity.setApiId(apiId);
        return apiMetadataEntity;
    }
}

