/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.notifiers.impl;

import io.gravitee.repository.management.model.GenericNotificationConfig;
import io.gravitee.rest.api.service.EmailService;
import io.gravitee.rest.api.service.builder.EmailNotificationBuilder;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.notification.Hook;
import io.gravitee.rest.api.service.notification.NotificationTemplateService;
import io.gravitee.rest.api.service.notifiers.EmailNotifierService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EmailNotifierServiceImpl
implements EmailNotifierService {
    private final Logger LOGGER = LoggerFactory.getLogger(EmailNotifierServiceImpl.class);
    @Autowired
    EmailService emailService;
    @Autowired
    private NotificationTemplateService notificationTemplateService;

    @Override
    public void trigger(Hook hook, GenericNotificationConfig genericNotificationConfig, Map<String, Object> params) {
        if (genericNotificationConfig == null || genericNotificationConfig.getConfig() == null || genericNotificationConfig.getConfig().isEmpty()) {
            this.LOGGER.error("Email Notifier configuration is empty");
            return;
        }
        EmailNotificationBuilder.EmailTemplate emailTemplate = this.getEmailTemplate(hook);
        if (emailTemplate == null) {
            this.LOGGER.error("Email template not found for hook {}", (Object)hook);
            return;
        }
        String[] mails = this.getMails(genericNotificationConfig, params).toArray(new String[0]);
        this.emailService.sendAsyncEmailNotification(new EmailNotificationBuilder().to(mails).template(emailTemplate).params(params).build(), GraviteeContext.getCurrentContext());
    }

    @Override
    public List<String> getMails(GenericNotificationConfig genericNotificationConfig, Map<String, Object> params) {
        if (genericNotificationConfig == null || genericNotificationConfig.getConfig() == null || genericNotificationConfig.getConfig().isEmpty()) {
            this.LOGGER.error("Email Notifier configuration is empty");
            return Collections.emptyList();
        }
        String[] mails = genericNotificationConfig.getConfig().split(",|;|\\s");
        ArrayList<String> result = new ArrayList<String>();
        for (String mail : mails) {
            if (mail.isEmpty()) continue;
            if (mail.contains("$")) {
                String tmpMail = this.notificationTemplateService.resolveInlineTemplateWithParam(mail, mail, params);
                if (tmpMail.isEmpty()) continue;
                result.add(tmpMail);
                continue;
            }
            result.add(mail);
        }
        if (result.isEmpty()) {
            this.LOGGER.warn("Email recipient not found with: {}", (Object)genericNotificationConfig.getConfig());
        }
        return result;
    }

    private EmailNotificationBuilder.EmailTemplate getEmailTemplate(Hook hook) {
        if (hook == null) {
            return null;
        }
        return EmailNotificationBuilder.EmailTemplate.fromHook(hook);
    }
}

