/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.rest.api.model.ApiQualityMetricsEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.model.quality.ApiQualityRuleEntity;
import io.gravitee.rest.api.model.quality.QualityRuleEntity;
import io.gravitee.rest.api.service.ApiQualityRuleService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.QualityMetricsService;
import io.gravitee.rest.api.service.QualityRuleService;
import io.gravitee.rest.api.service.exceptions.ApiQualityMetricsDisableException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.quality.ApiQualityMetric;
import io.gravitee.rest.api.service.quality.ApiQualityMetricLoader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QualityMetricsServiceImpl
extends AbstractService
implements QualityMetricsService {
    @Autowired
    private ParameterService parameterService;
    @Autowired
    private ApiQualityMetricLoader apiQualityMetricLoader;
    @Autowired
    private ApiQualityRuleService apiQualityRuleService;
    @Autowired
    private QualityRuleService qualityRuleService;

    private Map<String, ApiQualityMetric> getApiMetricsMap() {
        HashMap<String, ApiQualityMetric> map = new HashMap<String, ApiQualityMetric>();
        for (ApiQualityMetric apiQualityMetric : this.apiQualityMetricLoader.getApiQualityMetrics()) {
            map.put(apiQualityMetric.getWeightKey().key(), apiQualityMetric);
        }
        return Collections.unmodifiableMap(map);
    }

    private Map<String, Integer> getWeights() {
        List<Key> keys = this.apiQualityMetricLoader.getApiQualityMetrics().stream().map(ApiQualityMetric::getWeightKey).collect(Collectors.toList());
        return Collections.unmodifiableMap(this.parameterService.findAll(keys, Integer::parseInt, ParameterReferenceType.ENVIRONMENT).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (Integer)((List)e.getValue()).get(0))));
    }

    @Override
    public boolean isApiMetricsEnabled() {
        return this.parameterService.findAsBoolean(Key.API_QUALITY_METRICS_ENABLED, ParameterReferenceType.ENVIRONMENT);
    }

    @Override
    public ApiQualityMetricsEntity getMetrics(ApiEntity apiEntity) {
        if (!this.isApiMetricsEnabled()) {
            throw new ApiQualityMetricsDisableException();
        }
        Map<String, Integer> weights = this.getWeights().entrySet().stream().filter(e -> (Integer)e.getValue() > 0).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        ApiQualityMetricsEntity result = new ApiQualityMetricsEntity();
        result.setMetricsPassed(new HashMap(weights.size()));
        double score = 0.0;
        double maxScore = 0.0;
        if (weights.isEmpty()) {
            result.setScore(1.0);
        } else {
            Map<String, ApiQualityMetric> apiMetrics = this.getApiMetricsMap();
            for (Map.Entry<String, Integer> weight : weights.entrySet()) {
                boolean passed = apiMetrics.get(weight.getKey()).isValid(apiEntity);
                result.getMetricsPassed().put(weight.getKey(), passed);
                score += (double)(weight.getValue() * (passed ? 1 : 0));
                maxScore += (double)weight.getValue().intValue();
            }
            result.setScore((double)((int)(score / maxScore * 100.0)) / 100.0);
        }
        List<QualityRuleEntity> qualityRules = this.qualityRuleService.findAll();
        if (qualityRules != null && !qualityRules.isEmpty()) {
            List<ApiQualityRuleEntity> apiQualityRules = this.apiQualityRuleService.findByApi(apiEntity.getId());
            for (QualityRuleEntity qualityRule : qualityRules) {
                if (qualityRule.getWeight() <= 0) continue;
                ApiQualityRuleEntity apiQualityRule = apiQualityRules.stream().filter(aqr -> apiEntity.getId().equals(aqr.getApi()) && qualityRule.getId().equals(aqr.getQualityRule())).findFirst().orElse(null);
                boolean checked = apiQualityRule != null && apiQualityRule.isChecked();
                result.getMetricsPassed().put(qualityRule.getId(), checked);
                result.setScore((double)((int)((score += (double)(qualityRule.getWeight() * (checked ? 1 : 0))) / (maxScore += (double)qualityRule.getWeight()) * 100.0)) / 100.0);
            }
        }
        return result;
    }
}

