/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.notifiers.impl;

import io.gravitee.common.http.HttpMethod;
import io.gravitee.rest.api.service.common.RandomString;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.notifiers.WebNotifierService;
import io.gravitee.rest.api.service.vertx.VertxCompletableFuture;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.ProxyType;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class WebNotifierServiceImpl
implements WebNotifierService {
    private final Logger LOGGER = LoggerFactory.getLogger(WebNotifierServiceImpl.class);
    private static final String HTTPS_SCHEME = "https";
    @Value(value="${httpClient.timeout:10000}")
    private int httpClientTimeout;
    @Value(value="${httpClient.proxy.type:HTTP}")
    private String httpClientProxyType;
    @Value(value="${httpClient.proxy.http.host:#{systemProperties['http.proxyHost'] ?: 'localhost'}}")
    private String httpClientProxyHttpHost;
    @Value(value="${httpClient.proxy.http.port:#{systemProperties['http.proxyPort'] ?: 3128}}")
    private int httpClientProxyHttpPort;
    @Value(value="${httpClient.proxy.http.username:#{null}}")
    private String httpClientProxyHttpUsername;
    @Value(value="${httpClient.proxy.http.password:#{null}}")
    private String httpClientProxyHttpPassword;
    @Value(value="${httpClient.proxy.https.host:#{systemProperties['https.proxyHost'] ?: 'localhost'}}")
    private String httpClientProxyHttpsHost;
    @Value(value="${httpClient.proxy.https.port:#{systemProperties['https.proxyPort'] ?: 3128}}")
    private int httpClientProxyHttpsPort;
    @Value(value="${httpClient.proxy.https.username:#{null}}")
    private String httpClientProxyHttpsUsername;
    @Value(value="${httpClient.proxy.https.password:#{null}}")
    private String httpClientProxyHttpsPassword;
    @Autowired
    private Vertx vertx;

    @Override
    public void request(HttpMethod method, String uri, Map<String, String> headers, String body, boolean useSystemProxy) {
        if (uri == null || uri.isEmpty()) {
            this.LOGGER.error("Webhook Notifier configuration is empty");
            return;
        }
        VertxCompletableFuture future = new VertxCompletableFuture(this.vertx);
        URI requestUri = URI.create(uri);
        boolean ssl = HTTPS_SCHEME.equalsIgnoreCase(requestUri.getScheme());
        HttpClientOptions options = new HttpClientOptions().setSsl(ssl).setTrustAll(true).setMaxPoolSize(1).setKeepAlive(false).setTcpKeepAlive(false).setConnectTimeout(this.httpClientTimeout);
        if (useSystemProxy) {
            ProxyOptions proxyOptions = new ProxyOptions();
            proxyOptions.setType(ProxyType.valueOf((String)this.httpClientProxyType));
            if (HTTPS_SCHEME.equals(requestUri.getScheme())) {
                proxyOptions.setHost(this.httpClientProxyHttpsHost);
                proxyOptions.setPort(this.httpClientProxyHttpsPort);
                proxyOptions.setUsername(this.httpClientProxyHttpsUsername);
                proxyOptions.setPassword(this.httpClientProxyHttpsPassword);
            } else {
                proxyOptions.setHost(this.httpClientProxyHttpHost);
                proxyOptions.setPort(this.httpClientProxyHttpPort);
                proxyOptions.setUsername(this.httpClientProxyHttpUsername);
                proxyOptions.setPassword(this.httpClientProxyHttpPassword);
            }
            options.setProxyOptions(proxyOptions);
        }
        HttpClient httpClient = this.vertx.createHttpClient(options);
        int port = requestUri.getPort() != -1 ? requestUri.getPort() : (HTTPS_SCHEME.equals(requestUri.getScheme()) ? 443 : 80);
        HttpClientRequest request = httpClient.request(io.vertx.core.http.HttpMethod.valueOf((String)method.name()), port, requestUri.getHost(), requestUri.toString(), response -> this.LOGGER.debug("Web response status code : {}", (Object)response.statusCode()));
        request.setTimeout((long)this.httpClientTimeout);
        request.putHeader("Content-Type", "application/json");
        request.putHeader("Content-Length", Integer.toString(body.length()));
        headers.forEach((arg_0, arg_1) -> ((HttpClientRequest)request).putHeader(arg_0, arg_1));
        request.putHeader("X-Gravitee-Request-Id", RandomString.generate());
        request.write(body);
        request.handler(response -> {
            if (response.statusCode() == 200) {
                response.bodyHandler(buffer -> {
                    future.complete(buffer);
                    httpClient.close();
                });
            } else {
                future.completeExceptionally(new TechnicalManagementException(" Error on url '" + uri + "'. Status code: " + response.statusCode() + ". Message: " + response.statusMessage(), null));
            }
        });
        request.exceptionHandler(event -> {
            try {
                future.completeExceptionally((Throwable)event);
                httpClient.close();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        });
        request.end();
        try {
            future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            this.LOGGER.error(e.getMessage(), (Throwable)e);
            throw new TechnicalManagementException(e.getMessage(), e);
        }
    }
}

