/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.notification;

import io.gravitee.rest.api.service.notification.Hook;
import io.gravitee.rest.api.service.notification.HookScope;

public enum ActionHook implements Hook
{
    USER_REGISTRATION("User registration", "Email sent to a user who has self-registered on portal or admin console. Contains a registration link.", "USER"),
    USER_REGISTRATION_REQUEST_PROCESSED("User registration request processed", "Email sent to a user who has self-registered but self-registration need approval. Contains information about request status.", "USER"),
    APPLICATION_MEMBER_SUBSCRIPTION("New member of application", "Email sent to user that has been added to an application.", "MEMBERSHIP"),
    API_MEMBER_SUBSCRIPTION("New member of API", "Email sent to user that has been added to an API.", "MEMBERSHIP"),
    GROUP_MEMBER_SUBSCRIPTION("New member of group", "Email sent to user that has been added to a group.", "MEMBERSHIP"),
    SUPPORT_TICKET("Support ticket", "Email sent to support team of an API or of the platform, when a support ticket is created.", "SUPPORT"),
    GENERIC_MESSAGE("Generic message", "Email sent when using the messaging service.", "SUPPORT", true),
    USER_GROUP_INVITATION("User group invitation", "Email sent when using the messaging service.", "USER"),
    USER_PASSWORD_RESET("User password reset", "Email sent to a user which password has been reset.", "USER");

    private String label;
    private String description;
    private String category;
    private boolean hidden;

    private ActionHook(String label, String description, String category) {
        this(label, description, category, false);
    }

    private ActionHook(String label, String description, String category, boolean hidden) {
        this.label = label;
        this.description = description;
        this.category = category;
        this.hidden = hidden;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public HookScope getScope() {
        return HookScope.TEMPLATES_FOR_ACTION;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }
}

