/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade;

import io.gravitee.rest.api.model.NewPageEntity;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.PageType;
import io.gravitee.rest.api.model.SystemFolderType;
import io.gravitee.rest.api.model.documentation.PageQuery;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.PageService;
import io.gravitee.rest.api.service.Upgrader;
import io.gravitee.rest.api.service.common.GraviteeContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Component
public class DocumentationSystemFolderUpgrader
implements Upgrader,
Ordered {
    private final Logger logger = LoggerFactory.getLogger(DocumentationSystemFolderUpgrader.class);
    @Autowired
    private PageService pageService;
    @Autowired
    private ApiService apiService;

    @Override
    public boolean upgrade() {
        PageQuery query = new PageQuery.Builder().type(PageType.SYSTEM_FOLDER).build();
        if (this.pageService.search(query).isEmpty()) {
            this.logger.info("No system folders found. Add system folders in documentation, for portal and each API.");
            Map<SystemFolderType, String> systemFolderIds = this.pageService.initialize(GraviteeContext.getDefaultEnvironment());
            String headerSystemFolderId = systemFolderIds.get(SystemFolderType.HEADER);
            String topFooterSystemFolderId = systemFolderIds.get(SystemFolderType.TOPFOOTER);
            List<PageEntity> pagesToLink = this.pageService.search(new PageQuery.Builder().homepage(Boolean.valueOf(false)).rootParent(Boolean.valueOf(true)).build()).stream().filter(p -> PageType.SWAGGER.name().equals(p.getType()) || PageType.MARKDOWN.name().equals(p.getType())).collect(Collectors.toList());
            if (!pagesToLink.isEmpty()) {
                PageEntity docFolder = this.createFolder(topFooterSystemFolderId, "Documentation");
                pagesToLink.forEach(page -> this.createLink(docFolder.getId(), page.getName(), page.getId(), "page", Boolean.FALSE, Boolean.TRUE));
            }
            this.createLink(headerSystemFolderId, "Documentation", "root", "page", Boolean.TRUE, Boolean.FALSE);
            this.apiService.findAllLight().forEach(api -> this.pageService.createSystemFolder(api.getId(), SystemFolderType.ASIDE, 0, GraviteeContext.getDefaultEnvironment()));
        }
        return true;
    }

    private PageEntity createFolder(String parentId, String name) {
        NewPageEntity newFolder = new NewPageEntity();
        newFolder.setName(name);
        newFolder.setPublished(true);
        newFolder.setType(PageType.FOLDER);
        newFolder.setParentId(parentId);
        return this.pageService.createPage(newFolder);
    }

    private void createLink(String parentId, String name, String resourceRef, String resourceType, Boolean isFolder, Boolean inherit) {
        NewPageEntity newLink = new NewPageEntity();
        newLink.setContent(resourceRef);
        newLink.setName(name);
        newLink.setPublished(true);
        newLink.setType(PageType.LINK);
        newLink.setParentId(parentId);
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("resourceType", resourceType);
        if (isFolder != null) {
            configuration.put("isFolder", String.valueOf(isFolder));
        }
        if (inherit != null) {
            configuration.put("inherit", String.valueOf(inherit));
        }
        newLink.setConfiguration(configuration);
        this.pageService.createPage(newLink);
    }

    @Override
    public int getOrder() {
        return 100;
    }
}

