/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.configuration.identity;

import io.gravitee.common.utils.IdGenerator;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.IdentityProviderRepository;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.IdentityProvider;
import io.gravitee.repository.management.model.IdentityProviderType;
import io.gravitee.repository.management.model.RoleScope;
import io.gravitee.rest.api.model.configuration.identity.GroupMappingEntity;
import io.gravitee.rest.api.model.configuration.identity.IdentityProviderActivationReferenceType;
import io.gravitee.rest.api.model.configuration.identity.IdentityProviderEntity;
import io.gravitee.rest.api.model.configuration.identity.NewIdentityProviderEntity;
import io.gravitee.rest.api.model.configuration.identity.RoleMappingEntity;
import io.gravitee.rest.api.model.configuration.identity.UpdateIdentityProviderEntity;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.configuration.identity.IdentityProviderActivationService;
import io.gravitee.rest.api.service.configuration.identity.IdentityProviderService;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.impl.configuration.identity.ClientIdRequiredException;
import io.gravitee.rest.api.service.impl.configuration.identity.ClientSecretRequiredException;
import io.gravitee.rest.api.service.impl.configuration.identity.IdentityProviderAlreadyExistsException;
import io.gravitee.rest.api.service.impl.configuration.identity.IdentityProviderNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IdentityProviderServiceImpl
extends AbstractService
implements IdentityProviderService {
    private static final String CLIENT_ID = "clientId";
    private static final String CLIENT_SECRET = "clientSecret";
    private final Logger LOGGER = LoggerFactory.getLogger(IdentityProviderServiceImpl.class);
    @Autowired
    private IdentityProviderRepository identityProviderRepository;
    @Autowired
    private AuditService auditService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private IdentityProviderActivationService identityProviderActivationService;

    @Override
    public IdentityProviderEntity create(NewIdentityProviderEntity newIdentityProviderEntity) {
        try {
            this.LOGGER.debug("Create identity provider {}", (Object)newIdentityProviderEntity);
            Optional optIdentityProvider = this.identityProviderRepository.findById(IdGenerator.generate((String)newIdentityProviderEntity.getName()));
            if (optIdentityProvider.isPresent()) {
                throw new IdentityProviderAlreadyExistsException(newIdentityProviderEntity.getName());
            }
            IdentityProvider identityProvider = this.convert(newIdentityProviderEntity);
            identityProvider.setOrganizationId(GraviteeContext.getCurrentOrganization());
            if (identityProvider.getType() == IdentityProviderType.GOOGLE || identityProvider.getType() == IdentityProviderType.GITHUB) {
                this.checkSocialProvider(identityProvider);
            }
            identityProvider.setCreatedAt(new Date());
            identityProvider.setUpdatedAt(identityProvider.getCreatedAt());
            IdentityProvider createdIdentityProvider = this.identityProviderRepository.create(identityProvider);
            this.identityProviderActivationService.activateIdpOnTargets(createdIdentityProvider.getId(), new IdentityProviderActivationService.ActivationTarget(GraviteeContext.getCurrentOrganization(), IdentityProviderActivationReferenceType.ORGANIZATION));
            this.auditService.createOrganizationAuditLog(Collections.singletonMap(Audit.AuditProperties.IDENTITY_PROVIDER, createdIdentityProvider.getId()), (Audit.AuditEvent)IdentityProvider.AuditEvent.IDENTITY_PROVIDER_CREATED, createdIdentityProvider.getUpdatedAt(), null, createdIdentityProvider);
            return this.convert(createdIdentityProvider);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to create identity provider {}", (Object)newIdentityProviderEntity, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to create " + newIdentityProviderEntity, ex);
        }
    }

    @Override
    public IdentityProviderEntity update(String id, UpdateIdentityProviderEntity updateIdentityProvider) {
        try {
            this.LOGGER.debug("Update identity provider {}", (Object)updateIdentityProvider);
            Optional optIdentityProvider = this.identityProviderRepository.findById(id);
            if (!optIdentityProvider.isPresent()) {
                throw new IdentityProviderNotFoundException(updateIdentityProvider.getName());
            }
            IdentityProvider identityProvider = this.convert(updateIdentityProvider);
            IdentityProvider idpToUpdate = (IdentityProvider)optIdentityProvider.get();
            identityProvider.setId(id);
            identityProvider.setType(idpToUpdate.getType());
            identityProvider.setCreatedAt(idpToUpdate.getCreatedAt());
            identityProvider.setUpdatedAt(new Date());
            identityProvider.setOrganizationId(((IdentityProvider)optIdentityProvider.get()).getOrganizationId());
            IdentityProvider updatedIdentityProvider = this.identityProviderRepository.update(identityProvider);
            this.auditService.createOrganizationAuditLog(Collections.singletonMap(Audit.AuditProperties.IDENTITY_PROVIDER, id), (Audit.AuditEvent)IdentityProvider.AuditEvent.IDENTITY_PROVIDER_UPDATED, identityProvider.getUpdatedAt(), idpToUpdate, updatedIdentityProvider);
            return this.convert(updatedIdentityProvider);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to update identity provider {}", (Object)updateIdentityProvider, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to update " + updateIdentityProvider, ex);
        }
    }

    @Override
    public IdentityProviderEntity findById(String id) {
        try {
            this.LOGGER.debug("Find identity provider by ID: {}", (Object)id);
            Optional identityProvider = this.identityProviderRepository.findById(id);
            if (identityProvider.isPresent()) {
                return this.convert((IdentityProvider)identityProvider.get());
            }
            throw new IdentityProviderNotFoundException(id);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find an identity provider using its ID {}", (Object)id, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete an identity provider using its ID " + id, ex);
        }
    }

    @Override
    public void delete(String id) {
        try {
            this.LOGGER.debug("Delete identity provider: {}", (Object)id);
            Optional identityProvider = this.identityProviderRepository.findById(id);
            if (!identityProvider.isPresent()) {
                throw new IdentityProviderNotFoundException(id);
            }
            this.identityProviderRepository.delete(id);
            this.auditService.createOrganizationAuditLog(Collections.singletonMap(Audit.AuditProperties.IDENTITY_PROVIDER, id), (Audit.AuditEvent)IdentityProvider.AuditEvent.IDENTITY_PROVIDER_DELETED, new Date(), identityProvider.get(), null);
            this.identityProviderActivationService.deactivateIdpOnAllTargets(id);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to delete an identity provider using its ID {}", (Object)id, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete an identity provider using its ID " + id, ex);
        }
    }

    private void checkSocialProvider(IdentityProvider identityProvider) {
        Map providerConfiguration = identityProvider.getConfiguration();
        String clientId = (String)providerConfiguration.get(CLIENT_ID);
        if (clientId == null || clientId.isEmpty()) {
            throw new ClientIdRequiredException(identityProvider.getName());
        }
        String clientSecret = (String)providerConfiguration.get(CLIENT_SECRET);
        if (clientSecret == null || clientSecret.isEmpty()) {
            throw new ClientSecretRequiredException(identityProvider.getName());
        }
    }

    @Override
    public Set<IdentityProviderEntity> findAll() {
        try {
            return this.identityProviderRepository.findAllByOrganizationId(GraviteeContext.getCurrentOrganization()).stream().map(this::convert).collect(Collectors.toSet());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to retrieve identity providers", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to retrieve identity providers", ex);
        }
    }

    private IdentityProvider convert(NewIdentityProviderEntity newIdentityProviderEntity) {
        IdentityProvider identityProvider = new IdentityProvider();
        identityProvider.setId(IdGenerator.generate((String)newIdentityProviderEntity.getName()));
        identityProvider.setName(newIdentityProviderEntity.getName());
        identityProvider.setDescription(newIdentityProviderEntity.getDescription());
        identityProvider.setConfiguration(newIdentityProviderEntity.getConfiguration());
        identityProvider.setType(IdentityProviderType.valueOf((String)newIdentityProviderEntity.getType().name().toUpperCase()));
        identityProvider.setEnabled(newIdentityProviderEntity.isEnabled());
        identityProvider.setUserProfileMapping(newIdentityProviderEntity.getUserProfileMapping());
        identityProvider.setEmailRequired(Boolean.valueOf(newIdentityProviderEntity.isEmailRequired()));
        identityProvider.setSyncMappings(Boolean.valueOf(newIdentityProviderEntity.isSyncMappings()));
        return identityProvider;
    }

    private IdentityProviderEntity convert(IdentityProvider identityProvider) {
        IdentityProviderEntity identityProviderEntity = new IdentityProviderEntity();
        identityProviderEntity.setId(identityProvider.getId());
        identityProviderEntity.setName(identityProvider.getName());
        identityProviderEntity.setDescription(identityProvider.getDescription());
        identityProviderEntity.setEnabled(identityProvider.isEnabled());
        identityProviderEntity.setType(io.gravitee.rest.api.model.configuration.identity.IdentityProviderType.valueOf((String)identityProvider.getType().name().toUpperCase()));
        identityProviderEntity.setConfiguration(identityProvider.getConfiguration());
        if (identityProvider.getGroupMappings() != null && !identityProvider.getGroupMappings().isEmpty()) {
            identityProviderEntity.setGroupMappings(identityProvider.getGroupMappings().entrySet().stream().map(entry -> {
                GroupMappingEntity groupMapping = new GroupMappingEntity();
                groupMapping.setCondition((String)entry.getKey());
                if (entry.getValue() != null) {
                    groupMapping.setGroups(Arrays.asList((String[])entry.getValue()));
                }
                return groupMapping;
            }).collect(Collectors.toList()));
        }
        if (identityProvider.getRoleMappings() != null && !identityProvider.getRoleMappings().isEmpty()) {
            identityProviderEntity.setRoleMappings(identityProvider.getRoleMappings().entrySet().stream().map(new Function<Map.Entry<String, String[]>, RoleMappingEntity>(){

                @Override
                public RoleMappingEntity apply(Map.Entry<String, String[]> entry) {
                    RoleMappingEntity roleMapping = new RoleMappingEntity();
                    roleMapping.setCondition(entry.getKey());
                    if (entry.getValue() != null) {
                        ArrayList<String> organizationsRoles = new ArrayList<String>();
                        ArrayList<String> environmentsRoles = new ArrayList<String>();
                        for (String role : entry.getValue()) {
                            if (role.startsWith(RoleScope.ORGANIZATION.name() + ":")) {
                                organizationsRoles.add(role.split(":")[1]);
                            }
                            if (!role.startsWith(RoleScope.ENVIRONMENT.name() + ":")) continue;
                            environmentsRoles.add(role.split(":")[1]);
                        }
                        roleMapping.setOrganizations(organizationsRoles);
                        roleMapping.setEnvironments(environmentsRoles);
                    }
                    return roleMapping;
                }
            }).collect(Collectors.toList()));
        }
        identityProviderEntity.setConfiguration(identityProvider.getConfiguration());
        identityProviderEntity.setCreatedAt(identityProvider.getCreatedAt());
        identityProviderEntity.setUpdatedAt(identityProvider.getUpdatedAt());
        identityProviderEntity.setUserProfileMapping(identityProvider.getUserProfileMapping());
        if (identityProvider.getEmailRequired() == null) {
            identityProviderEntity.setEmailRequired(true);
        } else {
            identityProviderEntity.setEmailRequired(identityProvider.getEmailRequired().booleanValue());
        }
        identityProviderEntity.setSyncMappings(identityProvider.getSyncMappings() == null ? false : identityProvider.getSyncMappings());
        identityProviderEntity.setOrganization(identityProvider.getOrganizationId());
        return identityProviderEntity;
    }

    private IdentityProvider convert(UpdateIdentityProviderEntity updateIdentityProvider) {
        IdentityProvider identityProvider = new IdentityProvider();
        identityProvider.setName(updateIdentityProvider.getName());
        identityProvider.setDescription(updateIdentityProvider.getDescription());
        identityProvider.setEnabled(updateIdentityProvider.isEnabled());
        identityProvider.setConfiguration(updateIdentityProvider.getConfiguration());
        identityProvider.setUserProfileMapping(updateIdentityProvider.getUserProfileMapping());
        identityProvider.setEmailRequired(Boolean.valueOf(updateIdentityProvider.isEmailRequired()));
        identityProvider.setSyncMappings(Boolean.valueOf(updateIdentityProvider.isSyncMappings()));
        if (updateIdentityProvider.getGroupMappings() != null && !updateIdentityProvider.getGroupMappings().isEmpty()) {
            identityProvider.setGroupMappings(updateIdentityProvider.getGroupMappings().stream().collect(Collectors.toMap(GroupMappingEntity::getCondition, groupMappingEntity -> {
                String[] groups = new String[groupMappingEntity.getGroups().size()];
                return groupMappingEntity.getGroups().toArray(groups);
            })));
        }
        if (updateIdentityProvider.getRoleMappings() != null && !updateIdentityProvider.getRoleMappings().isEmpty()) {
            identityProvider.setRoleMappings(updateIdentityProvider.getRoleMappings().stream().collect(Collectors.toMap(RoleMappingEntity::getCondition, roleMapping -> {
                ArrayList lstRoles = new ArrayList();
                if (roleMapping.getOrganizations() != null && !roleMapping.getOrganizations().isEmpty()) {
                    roleMapping.getOrganizations().forEach(organizationRoleName -> {
                        this.roleService.findByScopeAndName(io.gravitee.rest.api.model.permissions.RoleScope.ORGANIZATION, (String)organizationRoleName);
                        lstRoles.add(RoleScope.ORGANIZATION.name() + ":" + organizationRoleName);
                    });
                }
                if (roleMapping.getEnvironments() != null && !roleMapping.getEnvironments().isEmpty()) {
                    roleMapping.getEnvironments().forEach(environmentRoleName -> {
                        this.roleService.findByScopeAndName(io.gravitee.rest.api.model.permissions.RoleScope.ENVIRONMENT, (String)environmentRoleName);
                        lstRoles.add(RoleScope.ENVIRONMENT.name() + ":" + environmentRoleName);
                    });
                }
                String[] roles = new String[lstRoles.size()];
                return lstRoles.toArray(roles);
            })));
        }
        return identityProvider;
    }
}

