/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.configuration.application.registration.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.gravitee.common.http.HttpMethod;
import io.gravitee.rest.api.service.impl.configuration.application.registration.client.DynamicClientRegistrationException;
import io.gravitee.rest.api.service.impl.configuration.application.registration.client.register.ClientRegistrationRequest;
import io.gravitee.rest.api.service.impl.configuration.application.registration.client.register.ClientRegistrationResponse;
import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DynamicClientRegistrationProviderClient {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final ObjectMapper mapper = new ObjectMapper();
    protected CloseableHttpClient httpClient;
    protected String registrationEndpoint;

    protected ClientRegistrationResponse register(String initialAccessToken, ClientRegistrationRequest request) {
        HttpPost registerRequest = new HttpPost(this.registrationEndpoint);
        registerRequest.setHeader("Authorization", "Bearer " + initialAccessToken);
        registerRequest.setHeader("Accept", "application/json");
        try {
            registerRequest.setEntity((HttpEntity)new StringEntity(this.mapper.writeValueAsString((Object)request), ContentType.create((String)"application/json", (Charset)Charset.defaultCharset())));
            return (ClientRegistrationResponse)this.httpClient.execute((HttpUriRequest)registerRequest, response -> {
                int status = response.getStatusLine().getStatusCode();
                if (status >= 200 && status < 300) {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        return (ClientRegistrationResponse)this.mapper.readValue(EntityUtils.toString((HttpEntity)entity), ClientRegistrationResponse.class);
                    }
                    throw new DynamicClientRegistrationException("Client registration response does not contain any body");
                }
                String responsePayload = EntityUtils.toString((HttpEntity)response.getEntity());
                if (responsePayload != null && !responsePayload.isEmpty()) {
                    try {
                        JsonNode node = this.mapper.readTree(responsePayload);
                        String error = node.path("error").asText();
                        String description = node.path("error_description").asText();
                        this.logger.error("Unexpected response from OIDC Registration endpoint: error[{}] description[{}]", (Object)error, (Object)description);
                        throw new DynamicClientRegistrationException("Unexpected response from OIDC Registration endpoint: error[" + error + "] description[" + description + "]");
                    }
                    catch (JsonProcessingException ex) {
                        this.logger.error("Unexpected response from OIDC Registration endpoint: status[{}] message[{}]", (Object)status, (Object)responsePayload);
                        throw new DynamicClientRegistrationException("Unexpected response from OIDC Registration endpoint: status[" + status + "] message[" + responsePayload + "]");
                    }
                }
                this.logger.error("Unexpected response from OIDC Registration endpoint: status[{}]", (Object)status);
                throw new DynamicClientRegistrationException("Unexpected response from OIDC Registration endpoint: status[" + status + "]");
            });
        }
        catch (Exception ex) {
            this.logger.error("Unexpected error while registering client: " + ex.getMessage(), (Throwable)ex);
            throw new DynamicClientRegistrationException("Unexpected error while registering client: " + ex.getMessage(), ex);
        }
    }

    public ClientRegistrationResponse update(String registrationAccessToken, String registrationClientUri, ClientRegistrationRequest request, String clientId) {
        HttpPut updateRequest = new HttpPut(registrationClientUri);
        updateRequest.setHeader("Authorization", "Bearer " + registrationAccessToken);
        updateRequest.setHeader("Accept", "application/json");
        try {
            JsonNode reqNode = this.mapper.readTree(this.mapper.writeValueAsString((Object)request));
            ((ObjectNode)reqNode).put("client_id", clientId);
            if (request.getScope() != null && !request.getScope().isEmpty()) {
                ((ObjectNode)reqNode).put("scope", String.join((CharSequence)" ", request.getScope()));
            } else {
                ((ObjectNode)reqNode).remove("scope");
            }
            updateRequest.setEntity((HttpEntity)new StringEntity(this.mapper.writeValueAsString((Object)reqNode), ContentType.create((String)"application/json", (Charset)Charset.defaultCharset())));
            return (ClientRegistrationResponse)this.httpClient.execute((HttpUriRequest)updateRequest, response -> {
                int status = response.getStatusLine().getStatusCode();
                if (status >= 200 && status < 300) {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        return (ClientRegistrationResponse)this.mapper.readValue(EntityUtils.toString((HttpEntity)entity), ClientRegistrationResponse.class);
                    }
                    throw new DynamicClientRegistrationException("Client registration response does not contain any body");
                }
                String responsePayload = EntityUtils.toString((HttpEntity)response.getEntity());
                if (responsePayload != null && !responsePayload.isEmpty()) {
                    try {
                        JsonNode node = this.mapper.readTree(responsePayload);
                        String error = node.path("error").asText();
                        String description = node.path("error_description").asText();
                        this.logger.error("Unexpected response from OIDC Registration endpoint: error[{}] description[{}]", (Object)error, (Object)description);
                        throw new DynamicClientRegistrationException("Unexpected response from OIDC Registration endpoint: error[" + error + "] description[" + description + "]");
                    }
                    catch (JsonProcessingException ex) {
                        this.logger.error("Unexpected response from OIDC Registration endpoint: status[{}] message[{}]", (Object)status, (Object)responsePayload);
                        throw new DynamicClientRegistrationException("Unexpected response from OIDC Registration endpoint: status[" + status + "] message[" + responsePayload + "]");
                    }
                }
                this.logger.error("Unexpected response from OIDC Registration endpoint: status[{}]", (Object)status);
                throw new DynamicClientRegistrationException("Unexpected response from OIDC Registration endpoint: status[" + status + "]");
            });
        }
        catch (Exception ex) {
            this.logger.error("Unexpected error while registering client: " + ex.getMessage(), (Throwable)ex);
            throw new DynamicClientRegistrationException("Unexpected error while registering client: " + ex.getMessage(), ex);
        }
    }

    public ClientRegistrationResponse renewClientSecret(String method, String endpoint, String registrationAccessToken) {
        HttpPost renewRequest = null;
        if (method.equalsIgnoreCase(HttpMethod.POST.name())) {
            renewRequest = new HttpPost(endpoint);
        } else if (method.equalsIgnoreCase(HttpMethod.PUT.name())) {
            renewRequest = new HttpPut(endpoint);
        } else if (method.equalsIgnoreCase(HttpMethod.PATCH.name())) {
            renewRequest = new HttpPatch(endpoint);
        }
        renewRequest.setHeader("Authorization", "Bearer " + registrationAccessToken);
        renewRequest.setHeader("Accept", "application/json");
        try {
            return (ClientRegistrationResponse)this.httpClient.execute((HttpUriRequest)renewRequest, response -> {
                int status = response.getStatusLine().getStatusCode();
                if (status >= 200 && status < 300) {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        return (ClientRegistrationResponse)this.mapper.readValue(EntityUtils.toString((HttpEntity)entity), ClientRegistrationResponse.class);
                    }
                    throw new DynamicClientRegistrationException("Renew client secret response does not contain any body");
                }
                String responsePayload = EntityUtils.toString((HttpEntity)response.getEntity());
                if (responsePayload != null && !responsePayload.isEmpty()) {
                    try {
                        JsonNode node = this.mapper.readTree(responsePayload);
                        String error = node.path("error").asText();
                        String description = node.path("error_description").asText();
                        this.logger.error("Unexpected response from renew client secret endpoint: error[{}] description[{}]", (Object)error, (Object)description);
                        throw new DynamicClientRegistrationException("Unexpected response from renew client secret endpoint: error[" + error + "] description[" + description + "]");
                    }
                    catch (JsonProcessingException ex) {
                        this.logger.error("Unexpected response from renew client secret endpoint: status[{}] message[{}]", (Object)status, (Object)responsePayload);
                        throw new DynamicClientRegistrationException("Unexpected response from new client secret endpoint: status[" + status + "] message[" + responsePayload + "]");
                    }
                }
                this.logger.error("Unexpected response from renew client secret endpoint: status[{}]", (Object)status);
                throw new DynamicClientRegistrationException("Unexpected response from renew client secret endpoint: status[" + status + "]");
            });
        }
        catch (Exception ex) {
            this.logger.error("Unexpected error while renewing client secret: " + ex.getMessage(), (Throwable)ex);
            throw new DynamicClientRegistrationException("Unexpected error while renewing client secret: " + ex.getMessage(), ex);
        }
    }

    public ClientRegistrationResponse register(ClientRegistrationRequest request) {
        String accessToken = this.getInitialAccessToken();
        return this.register(accessToken, request);
    }

    public abstract String getInitialAccessToken();
}

