/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ThemeRepository;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Theme;
import io.gravitee.repository.management.model.ThemeReferenceType;
import io.gravitee.rest.api.model.InlinePictureEntity;
import io.gravitee.rest.api.model.PictureEntity;
import io.gravitee.rest.api.model.UrlPictureEntity;
import io.gravitee.rest.api.model.theme.NewThemeEntity;
import io.gravitee.rest.api.model.theme.ThemeComponentDefinition;
import io.gravitee.rest.api.model.theme.ThemeCssDefinition;
import io.gravitee.rest.api.model.theme.ThemeDefinition;
import io.gravitee.rest.api.model.theme.ThemeEntity;
import io.gravitee.rest.api.model.theme.UpdateThemeEntity;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.ThemeService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.DuplicateThemeNameException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.exceptions.ThemeNotFoundException;
import io.gravitee.rest.api.service.impl.AbstractService;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.activation.MimetypesFileTypeMap;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ThemeServiceImpl
extends AbstractService
implements ThemeService {
    private final Logger LOGGER = LoggerFactory.getLogger(ThemeServiceImpl.class);
    private static final ThemeDefinitionMapper MAPPER = new ThemeDefinitionMapper();
    private static final String DEFAULT_THEME_PATH = "/definition.json";
    private static final String DEFAULT_THEME_ID = "default";
    @Autowired
    private ThemeRepository themeRepository;
    @Autowired
    private AuditService auditService;
    @Value(value="${portal.themes.path:${gravitee.home}/themes}")
    private String themesPath;

    @Override
    public Set<ThemeEntity> findAll() {
        try {
            this.LOGGER.debug("Find all themes by reference: " + GraviteeContext.getCurrentEnvironment());
            return this.themeRepository.findByReferenceIdAndReferenceType(GraviteeContext.getCurrentEnvironment(), ThemeReferenceType.ENVIRONMENT.name()).stream().map(this::convert).collect(Collectors.toSet());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find all themes", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find all themes", ex);
        }
    }

    @Override
    public ThemeEntity findById(String themeId) {
        return this.convert(this.findByIdWithoutConvert(themeId));
    }

    private Theme findByIdWithoutConvert(String themeId) {
        try {
            this.LOGGER.debug("Find theme by ID: {}", (Object)themeId);
            Optional optTheme = this.themeRepository.findById((Object)themeId);
            if (!optTheme.isPresent()) {
                throw new ThemeNotFoundException(themeId);
            }
            Theme theme = (Theme)optTheme.get();
            if (!theme.getReferenceId().equals(GraviteeContext.getCurrentEnvironment())) {
                this.LOGGER.warn("Theme is not in current environment " + GraviteeContext.getCurrentEnvironment() + " actual:" + theme.getReferenceId());
                throw new ThemeNotFoundException(themeId);
            }
            return theme;
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find theme by ID", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find theme by ID", ex);
        }
    }

    @Override
    public ThemeEntity create(NewThemeEntity themeEntity) {
        try {
            if (this.findByName(themeEntity.getName(), null).isPresent()) {
                throw new DuplicateThemeNameException(themeEntity.getName());
            }
            Theme theme = (Theme)this.themeRepository.create((Object)this.convert(themeEntity));
            this.auditService.createEnvironmentAuditLog(Collections.singletonMap(Audit.AuditProperties.THEME, theme.getId()), (Audit.AuditEvent)Theme.AuditEvent.THEME_CREATED, theme.getCreatedAt(), null, theme);
            return this.convert(theme);
        }
        catch (TechnicalException ex) {
            String error = "An error occurred while trying to create theme " + themeEntity;
            this.LOGGER.error(error, (Throwable)ex);
            throw new TechnicalManagementException(error, ex);
        }
    }

    private Optional<ThemeEntity> findByName(String name, String excludedId) {
        return this.findAll().stream().filter(t -> !t.getId().equals(excludedId) && t.getName().equals(name)).findAny();
    }

    @Override
    public ThemeEntity update(UpdateThemeEntity updateThemeEntity) {
        try {
            Optional themeOptional = this.themeRepository.findById((Object)updateThemeEntity.getId());
            if (themeOptional.isPresent()) {
                Theme theme = new Theme((Theme)themeOptional.get());
                if (this.findByName(theme.getName(), theme.getId()).isPresent()) {
                    throw new DuplicateThemeNameException(theme.getName());
                }
                theme.setEnabled(updateThemeEntity.isEnabled());
                Date now = new Date();
                theme.setUpdatedAt(now);
                theme.setReferenceType(ThemeReferenceType.ENVIRONMENT.name());
                theme.setReferenceId(GraviteeContext.getCurrentEnvironment());
                if (updateThemeEntity.getName() != null) {
                    theme.setName(updateThemeEntity.getName());
                }
                theme.setDefinition(MAPPER.writeValueAsString(updateThemeEntity.getDefinition()));
                if (updateThemeEntity.getLogo() != null) {
                    theme.setLogo(updateThemeEntity.getLogo());
                } else {
                    theme.setLogo(this.getDefaultLogo());
                }
                theme.setBackgroundImage(updateThemeEntity.getBackgroundImage());
                if (updateThemeEntity.getOptionalLogo() != null) {
                    theme.setOptionalLogo(updateThemeEntity.getOptionalLogo());
                } else {
                    theme.setOptionalLogo(this.getDefaultOptionalLogo());
                }
                ThemeEntity savedTheme = this.convert((Theme)this.themeRepository.update((Object)theme));
                this.auditService.createEnvironmentAuditLog(Collections.singletonMap(Audit.AuditProperties.THEME, theme.getId()), (Audit.AuditEvent)Theme.AuditEvent.THEME_UPDATED, new Date(), themeOptional.get(), theme);
                return savedTheme;
            }
            NewThemeEntity newTheme = new NewThemeEntity();
            newTheme.setName(updateThemeEntity.getName());
            newTheme.setDefinition(updateThemeEntity.getDefinition());
            newTheme.setBackgroundImage(updateThemeEntity.getBackgroundImage());
            newTheme.setLogo(updateThemeEntity.getLogo());
            newTheme.setOptionalLogo(updateThemeEntity.getOptionalLogo());
            newTheme.setEnabled(updateThemeEntity.isEnabled());
            return this.create(newTheme);
        }
        catch (JsonProcessingException | TechnicalException ex) {
            String error = "An error occurred while trying to update theme " + updateThemeEntity;
            this.LOGGER.error(error, ex);
            throw new TechnicalManagementException(error, ex);
        }
    }

    @Override
    public void delete(String themeId) {
        try {
            Optional themeOptional = this.themeRepository.findById((Object)themeId);
            if (themeOptional.isPresent()) {
                this.themeRepository.delete((Object)themeId);
                this.auditService.createEnvironmentAuditLog(Collections.singletonMap(Audit.AuditProperties.THEME, themeId), (Audit.AuditEvent)Theme.AuditEvent.THEME_DELETED, new Date(), null, themeOptional.get());
            }
        }
        catch (TechnicalException ex) {
            String error = "An error occurs while trying to delete theme " + themeId;
            this.LOGGER.error(error, (Throwable)ex);
            throw new TechnicalManagementException(error, ex);
        }
    }

    @Override
    public ThemeEntity findEnabled() {
        try {
            this.LOGGER.debug("Find all themes by reference type");
            Optional<Theme> themeEnabled = this.themeRepository.findByReferenceIdAndReferenceType(GraviteeContext.getCurrentEnvironment(), ThemeReferenceType.ENVIRONMENT.name()).stream().filter(theme -> theme.isEnabled()).findFirst();
            if (themeEnabled.isPresent()) {
                return this.convert(themeEnabled.get());
            }
            ThemeEntity theme2 = new ThemeEntity();
            theme2.setId(DEFAULT_THEME_ID);
            theme2.setName("Default theme");
            theme2.setDefinition(MAPPER.readDefinition(this.getDefaultDefinition()));
            theme2.setLogo(this.getDefaultLogo());
            theme2.setOptionalLogo(this.getDefaultOptionalLogo());
            return theme2;
        }
        catch (IOException ex) {
            String error = "Error while trying to get the default theme";
            this.LOGGER.error("Error while trying to get the default theme", (Throwable)ex);
            throw new TechnicalManagementException("Error while trying to get the default theme", ex);
        }
        catch (TechnicalException ex) {
            String error = "An error occurs while trying to find all themes by reference type";
            this.LOGGER.error("An error occurs while trying to find all themes by reference type", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find all themes by reference type", ex);
        }
    }

    @Override
    public void updateDefaultTheme() {
        try {
            Set themes = this.themeRepository.findByReferenceIdAndReferenceType(GraviteeContext.getCurrentEnvironment(), ThemeReferenceType.ENVIRONMENT.name());
            String defaultDefinition = this.getDefaultDefinition();
            if (themes != null && !themes.isEmpty()) {
                themes.forEach(theme -> {
                    if (!MAPPER.isSame(defaultDefinition, theme.getDefinition())) {
                        try {
                            ThemeDefinition mergeDefinition = MAPPER.merge(defaultDefinition, theme.getDefinition());
                            Theme themeUpdate = new Theme(theme);
                            themeUpdate.setDefinition(MAPPER.writeValueAsString(mergeDefinition));
                            theme.setUpdatedAt(new Date());
                            this.themeRepository.update((Object)themeUpdate);
                            this.auditService.createEnvironmentAuditLog(Collections.singletonMap(Audit.AuditProperties.THEME, theme.getId()), (Audit.AuditEvent)Theme.AuditEvent.THEME_UPDATED, new Date(), theme, themeUpdate);
                        }
                        catch (IOException ex) {
                            String error = "Error while trying to merge default theme from the definition path: " + this.themesPath + DEFAULT_THEME_PATH + " with theme " + theme.toString();
                            this.LOGGER.error(error, (Throwable)ex);
                        }
                        catch (TechnicalException ex) {
                            String error = "Error while trying to update theme after merge with default" + theme.toString();
                            this.LOGGER.error(error, (Throwable)ex);
                        }
                    }
                });
            }
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find all themes", (Throwable)ex);
        }
    }

    public String getDefaultDefinition() {
        return this.getDefinition(this.themesPath + DEFAULT_THEME_PATH);
    }

    public String getDefinition(String path) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            String json = new String(Files.readAllBytes(new File(path).toPath()), Charset.defaultCharset());
            JsonNode jsonNode = (JsonNode)objectMapper.readValue(json, JsonNode.class);
            return jsonNode.toString();
        }
        catch (IOException ex) {
            String error = "Error while trying to load a theme from the definition path: " + path;
            this.LOGGER.error(error, (Throwable)ex);
            throw new TechnicalManagementException(error, ex);
        }
    }

    public String getDefaultLogo() {
        return this.getImage("logo.png");
    }

    public String getDefaultOptionalLogo() {
        return this.getImage("logo-light.png");
    }

    private String getImage(String filename) {
        String filepath = this.themesPath + "/" + filename;
        try {
            byte[] image = Files.readAllBytes(new File(filepath).toPath());
            MimetypesFileTypeMap fileTypeMap = new MimetypesFileTypeMap();
            return "data:" + fileTypeMap.getContentType(filename) + ";base64," + Base64.getEncoder().encodeToString(image);
        }
        catch (IOException ex) {
            String error = "Error while trying to load image from: " + filepath;
            this.LOGGER.error(error, (Throwable)ex);
            return null;
        }
    }

    @Override
    public ThemeEntity resetToDefaultTheme(String themeId) {
        try {
            this.LOGGER.debug("Reset to default theme by ID: {}", (Object)themeId);
            ThemeEntity previousTheme = this.findEnabled();
            this.themeRepository.delete((Object)DEFAULT_THEME_ID);
            this.auditService.createEnvironmentAuditLog(Collections.singletonMap(Audit.AuditProperties.THEME, themeId), (Audit.AuditEvent)Theme.AuditEvent.THEME_RESET, new Date(), previousTheme, null);
            return this.findEnabled();
        }
        catch (Exception ex) {
            String error = "Error while trying to reset a default theme";
            this.LOGGER.error("Error while trying to reset a default theme", (Throwable)ex);
            throw new TechnicalManagementException("Error while trying to reset a default theme", ex);
        }
    }

    @Override
    public PictureEntity getLogo(String themeId) {
        try {
            String logo = this.findEnabled().getLogo();
            if (logo != null) {
                return this.convertToPicture(logo);
            }
        }
        catch (Exception ex) {
            this.LOGGER.warn("Unable to get logo picture theme for id[{}]", (Object)themeId);
        }
        return null;
    }

    @Override
    public PictureEntity getOptionalLogo(String themeId) {
        try {
            String optionalLogo = this.findEnabled().getOptionalLogo();
            if (optionalLogo != null) {
                return this.convertToPicture(optionalLogo);
            }
        }
        catch (Exception ex) {
            this.LOGGER.warn("Unable to get optional logo theme for id[{}]", (Object)themeId);
        }
        return null;
    }

    @Override
    public PictureEntity getBackgroundImage(String themeId) {
        try {
            String backgroundImage = this.findEnabled().getBackgroundImage();
            if (backgroundImage != null) {
                return this.convertToPicture(backgroundImage);
            }
        }
        catch (Exception ex) {
            this.LOGGER.warn("Unable to get background image theme for id[{}]", (Object)themeId);
        }
        return null;
    }

    private PictureEntity convertToPicture(String picture) {
        if (picture.matches("^(http|https)://.*$")) {
            return new UrlPictureEntity(picture);
        }
        InlinePictureEntity imageEntity = new InlinePictureEntity();
        String[] parts = picture.split(";", 2);
        imageEntity.setType(parts[0].split(":")[1]);
        String base64Content = picture.split(",", 2)[1];
        imageEntity.setContent(DatatypeConverter.parseBase64Binary((String)base64Content));
        return imageEntity;
    }

    private Theme convert(NewThemeEntity themeEntity) {
        try {
            Date now = new Date();
            Theme theme = new Theme();
            theme.setId(DEFAULT_THEME_ID);
            theme.setCreatedAt(now);
            theme.setUpdatedAt(now);
            theme.setReferenceId(GraviteeContext.getCurrentEnvironment());
            theme.setReferenceType(ThemeReferenceType.ENVIRONMENT.name());
            theme.setLogo(themeEntity.getLogo());
            theme.setName(themeEntity.getName());
            theme.setDefinition(MAPPER.writeValueAsString(themeEntity.getDefinition()));
            theme.setEnabled(themeEntity.isEnabled());
            theme.setBackgroundImage(themeEntity.getBackgroundImage());
            theme.setOptionalLogo(themeEntity.getOptionalLogo());
            return theme;
        }
        catch (JsonProcessingException e) {
            throw new TechnicalManagementException("Cannot convert new theme entity", e);
        }
    }

    private ThemeEntity convert(Theme theme) {
        ThemeEntity themeEntity = new ThemeEntity();
        themeEntity.setId(theme.getId());
        themeEntity.setName(theme.getName());
        try {
            themeEntity.setDefinition(MAPPER.readDefinition(theme.getDefinition()));
        }
        catch (IOException e) {
            this.LOGGER.error("Cannot read definition of theme " + theme.getId() + " definition:" + theme.getDefinition());
        }
        themeEntity.setCreatedAt(theme.getCreatedAt());
        themeEntity.setUpdatedAt(theme.getUpdatedAt());
        themeEntity.setEnabled(theme.isEnabled());
        themeEntity.setLogo(theme.getLogo());
        themeEntity.setBackgroundImage(theme.getBackgroundImage());
        themeEntity.setOptionalLogo(theme.getOptionalLogo());
        return themeEntity;
    }

    public static class ThemeDefinitionMapper
    extends ObjectMapper {
        private final Logger LOGGER = LoggerFactory.getLogger(ThemeDefinitionMapper.class);

        public ThemeDefinition readDefinition(String themeDefinition) throws IOException {
            return (ThemeDefinition)this.readValue(themeDefinition, ThemeDefinition.class);
        }

        public ThemeDefinition merge(String base, String override) throws IOException {
            ThemeDefinition overrideDefinition = this.readDefinition(override);
            ThemeDefinition overrideDefinitionFinal = this.readDefinition(override);
            ThemeDefinition mergedDefinition = (ThemeDefinition)this.readerForUpdating(overrideDefinition).readValue(base);
            List componentsData = mergedDefinition.getData().stream().map(component -> {
                List cssMerged = component.getCss().stream().map(css -> {
                    ThemeCssDefinition customCss = this.getThemeCssDefinition(overrideDefinitionFinal, component.getName(), css.getName());
                    if (customCss != null) {
                        css.setValue(customCss.getValue());
                    }
                    return css;
                }).collect(Collectors.toList());
                component.setCss(cssMerged);
                return component;
            }).collect(Collectors.toList());
            mergedDefinition.setData(componentsData);
            return mergedDefinition;
        }

        public ThemeComponentDefinition getThemeComponentDefinition(ThemeDefinition themeDefinition, String name) {
            return themeDefinition.getData().stream().filter(themeComponentDefinition -> name.equals(themeComponentDefinition.getName())).findFirst().orElse(null);
        }

        public ThemeCssDefinition getThemeCssDefinition(ThemeDefinition themeDefinition, String name, String cssName) {
            ThemeComponentDefinition componentDefinition = this.getThemeComponentDefinition(themeDefinition, name);
            if (componentDefinition != null) {
                return componentDefinition.getCss().stream().filter(css -> cssName.equals(css.getName())).findFirst().orElse(null);
            }
            return null;
        }

        public boolean isSame(String definitionA, String definitionB) {
            try {
                return this.readTree(definitionA).equals((Object)this.readTree(definitionB));
            }
            catch (IOException e) {
                this.LOGGER.error("Cannot compare definition " + definitionA + " and " + definitionB, (Throwable)e);
                return false;
            }
        }
    }
}

