/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.rest.api.model.ImportSwaggerDescriptorEntity;
import io.gravitee.rest.api.model.api.SwaggerApiEntity;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.SwaggerService;
import io.gravitee.rest.api.service.TagService;
import io.gravitee.rest.api.service.exceptions.SwaggerDescriptorException;
import io.gravitee.rest.api.service.impl.swagger.converter.api.OAIToAPIConverter;
import io.gravitee.rest.api.service.impl.swagger.converter.api.OAIToAPIV2Converter;
import io.gravitee.rest.api.service.impl.swagger.parser.OAIParser;
import io.gravitee.rest.api.service.impl.swagger.parser.WsdlParser;
import io.gravitee.rest.api.service.impl.swagger.policy.PolicyOperationVisitorManager;
import io.gravitee.rest.api.service.impl.swagger.transformer.SwaggerTransformer;
import io.gravitee.rest.api.service.sanitizer.UrlSanitizerUtils;
import io.gravitee.rest.api.service.spring.ImportConfiguration;
import io.gravitee.rest.api.service.swagger.OAIDescriptor;
import io.gravitee.rest.api.service.swagger.SwaggerDescriptor;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.core.models.ParseOptions;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SwaggerServiceImpl
implements SwaggerService {
    private final Logger logger = LoggerFactory.getLogger(SwaggerServiceImpl.class);
    @Value(value="${swagger.scheme:https}")
    private String defaultScheme;
    @Autowired
    private PolicyOperationVisitorManager policyOperationVisitorManager;
    @Autowired
    private ImportConfiguration importConfiguration;
    @Autowired
    private GroupService groupService;
    @Autowired
    private TagService tagService;

    @Override
    public SwaggerApiEntity createAPI(ImportSwaggerDescriptorEntity swaggerDescriptor) {
        return this.createAPI(swaggerDescriptor, DefinitionVersion.V1);
    }

    @Override
    public SwaggerApiEntity createAPI(ImportSwaggerDescriptorEntity swaggerDescriptor, DefinitionVersion definitionVersion) {
        ParseOptions options = new ParseOptions();
        options.setResolveFully(true);
        boolean wsdlImport = ImportSwaggerDescriptorEntity.Format.WSDL.equals((Object)swaggerDescriptor.getFormat());
        SwaggerDescriptor descriptor = this.parse(swaggerDescriptor.getPayload(), wsdlImport, options);
        if (wsdlImport) {
            this.overridePayload(swaggerDescriptor, descriptor);
            this.populateXmlToJsonPolicy(swaggerDescriptor);
        }
        if (descriptor != null) {
            if (definitionVersion.equals((Object)DefinitionVersion.V2)) {
                return new OAIToAPIV2Converter(swaggerDescriptor, this.policyOperationVisitorManager, this.groupService, this.tagService).convert((OAIDescriptor)descriptor);
            }
            return new OAIToAPIConverter(swaggerDescriptor, this.policyOperationVisitorManager, this.groupService, this.tagService).convert((OAIDescriptor)descriptor);
        }
        throw new SwaggerDescriptorException();
    }

    private void overridePayload(ImportSwaggerDescriptorEntity swaggerDescriptor, SwaggerDescriptor descriptor) {
        try {
            swaggerDescriptor.setPayload(descriptor.toYaml());
            swaggerDescriptor.setType(ImportSwaggerDescriptorEntity.Type.INLINE);
        }
        catch (JsonProcessingException e) {
            this.logger.debug("JSON serialization failed, unable to override payload attribute", (Throwable)e);
        }
    }

    private void populateXmlToJsonPolicy(ImportSwaggerDescriptorEntity swaggerDescriptor) {
        if (swaggerDescriptor.getWithPolicies().contains("rest-to-soap")) {
            swaggerDescriptor.getWithPolicies().add("xml-json");
        }
    }

    @Override
    public <Y, T extends SwaggerDescriptor<Y>> void transform(T descriptor, Collection<SwaggerTransformer<T>> transformers) {
        if (transformers != null) {
            transformers.forEach(transformer -> transformer.transform(descriptor));
        }
    }

    @Override
    public SwaggerDescriptor parse(String content) {
        return this.parse(content, false, null);
    }

    @Override
    public SwaggerDescriptor parse(String content, boolean wsdl) {
        return this.parse(content, wsdl, null);
    }

    public SwaggerDescriptor parse(String content, boolean wsdl, ParseOptions options) {
        if (this.isUrl(content)) {
            UrlSanitizerUtils.checkAllowed(content, this.importConfiguration.getImportWhitelist(), this.importConfiguration.isAllowImportFromPrivate());
        }
        if (wsdl) {
            this.logger.debug("Trying to load a Wsdl descriptor");
            OpenAPI descriptor = new WsdlParser().parse(content);
            if (descriptor != null) {
                return new OAIDescriptor(descriptor);
            }
        } else {
            OAIDescriptor oaiDescriptor = new OAIParser().parse(content, options);
            if (oaiDescriptor == null || oaiDescriptor.getSpecification() == null) {
                throw new SwaggerDescriptorException();
            }
            return oaiDescriptor;
        }
        throw new SwaggerDescriptorException();
    }

    private boolean isUrl(String content) {
        try {
            new URL(content);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }
}

