/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.UserMembership;
import io.gravitee.rest.api.model.UserRoleEntity;
import io.gravitee.rest.api.model.permissions.ApiPermission;
import io.gravitee.rest.api.model.permissions.EnvironmentPermission;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.PermissionService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.impl.AbstractService;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PermissionServiceImpl
extends AbstractService
implements PermissionService {
    @Autowired
    MembershipService membershipService;
    @Autowired
    RoleService roleService;
    @Autowired
    UserService userService;

    @Override
    public boolean hasPermission(RolePermission permission, String referenceId, RolePermissionAction ... acls) {
        MembershipReferenceType membershipReferenceType;
        switch (permission.getScope()) {
            case API: {
                membershipReferenceType = MembershipReferenceType.API;
                break;
            }
            case APPLICATION: {
                membershipReferenceType = MembershipReferenceType.APPLICATION;
                break;
            }
            case ENVIRONMENT: {
                membershipReferenceType = MembershipReferenceType.ENVIRONMENT;
                if (referenceId != null) break;
                referenceId = GraviteeContext.getCurrentEnvironment();
                break;
            }
            case ORGANIZATION: {
                membershipReferenceType = MembershipReferenceType.ORGANIZATION;
                if (referenceId != null) break;
                referenceId = GraviteeContext.getCurrentOrganization();
                break;
            }
            default: {
                membershipReferenceType = null;
            }
        }
        Map<String, char[]> permissions = this.membershipService.getUserMemberPermissions(membershipReferenceType, referenceId, this.getAuthenticatedUsername());
        if (permissions == null) {
            return false;
        }
        return this.roleService.hasPermission(permissions, permission.getPermission(), acls);
    }

    @Override
    public boolean hasManagementRights(String userId) {
        UserEntity user = this.userService.findByIdWithRoles(userId);
        boolean hasManagementRights = this.hasRelevantManagementRole(user);
        if (!hasManagementRights) {
            Set userApisRole = this.membershipService.findUserMembership(MembershipReferenceType.API, userId).stream().map(UserMembership::getReference).distinct().flatMap(apiId -> this.membershipService.getRoles(MembershipReferenceType.API, (String)apiId, MembershipMemberType.USER, userId).stream()).collect(Collectors.toSet());
            hasManagementRights = userApisRole.stream().anyMatch(roleEntity -> {
                boolean hasCreateUpdateOrDeletePermission = false;
                Map rolePermissions = roleEntity.getPermissions();
                Iterator iterator = rolePermissions.keySet().iterator();
                while (iterator.hasNext() && !hasCreateUpdateOrDeletePermission) {
                    String permissionName = (String)iterator.next();
                    if (ApiPermission.RATING.name().equals(permissionName) || ApiPermission.RATING_ANSWER.name().equals(permissionName)) continue;
                    String permissionString = new String((char[])rolePermissions.get(permissionName));
                    hasCreateUpdateOrDeletePermission = permissionString != null && !permissionString.isEmpty() && (permissionString.contains("C") || permissionString.contains("U") || permissionString.contains("D"));
                }
                return hasCreateUpdateOrDeletePermission;
            });
        }
        return hasManagementRights;
    }

    private boolean hasRelevantManagementRole(UserEntity user) {
        if (user.getRoles() == null) {
            return false;
        }
        for (UserRoleEntity userRoleEntity : user.getRoles()) {
            if (userRoleEntity.getPermissions() == null) continue;
            RoleScope currentScope = userRoleEntity.getScope();
            for (String permissionName : userRoleEntity.getPermissions().keySet()) {
                boolean isCreateUpdateOrDelete;
                String permissionString = new String((char[])userRoleEntity.getPermissions().get(permissionName));
                boolean bl = isCreateUpdateOrDelete = permissionString.contains("C") || permissionString.contains("U") || permissionString.contains("D");
                if (currentScope.equals((Object)RoleScope.ORGANIZATION) && isCreateUpdateOrDelete) {
                    return true;
                }
                if (!currentScope.equals((Object)RoleScope.ENVIRONMENT) || EnvironmentPermission.valueOf((String)permissionName).equals((Object)EnvironmentPermission.APPLICATION) || !isCreateUpdateOrDelete) continue;
                return true;
            }
        }
        return false;
    }
}

