/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.OrganizationRepository;
import io.gravitee.repository.management.model.Organization;
import io.gravitee.rest.api.model.OrganizationEntity;
import io.gravitee.rest.api.model.UpdateOrganizationEntity;
import io.gravitee.rest.api.service.OrganizationService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.OrganizationNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.TransactionalService;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OrganizationServiceImpl
extends TransactionalService
implements OrganizationService {
    private final Logger LOGGER = LoggerFactory.getLogger(OrganizationServiceImpl.class);
    @Autowired
    private OrganizationRepository organizationRepository;
    @Autowired
    private RoleService roleService;

    @Override
    public OrganizationEntity findById(String organizationId) {
        try {
            this.LOGGER.debug("Find organization by ID: {}", (Object)organizationId);
            Optional optOrganization = this.organizationRepository.findById((Object)organizationId);
            if (!optOrganization.isPresent()) {
                throw new OrganizationNotFoundException(organizationId);
            }
            return this.convert((Organization)optOrganization.get());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find organization by ID", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find organization by ID", ex);
        }
    }

    @Override
    public List<OrganizationEntity> findAll() {
        try {
            this.LOGGER.debug("Find all organizations");
            return this.organizationRepository.findAll().stream().map(this::convert).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find all organizations", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find all organizations", ex);
        }
    }

    @Override
    public OrganizationEntity createOrUpdate(UpdateOrganizationEntity organizationEntity) {
        try {
            Optional organizationOptional = this.organizationRepository.findById((Object)organizationEntity.getId());
            Organization organization = this.convert(organizationEntity);
            if (organizationOptional.isPresent()) {
                return this.convert((Organization)this.organizationRepository.update((Object)organization));
            }
            OrganizationEntity createdOrganization = this.convert((Organization)this.organizationRepository.create((Object)organization));
            this.roleService.initialize(createdOrganization.getId());
            this.roleService.createOrUpdateSystemRoles(createdOrganization.getId());
            return createdOrganization;
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to update organization {}", (Object)organizationEntity.getName(), (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to update organization " + organizationEntity.getName(), ex);
        }
    }

    @Override
    public void delete(String organizationId) {
        try {
            Optional organizationOptional = this.organizationRepository.findById((Object)organizationId);
            if (organizationOptional.isPresent()) {
                this.organizationRepository.delete((Object)organizationId);
            }
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to delete organization {}", (Object)organizationId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete organization " + organizationId, ex);
        }
    }

    private Organization convert(UpdateOrganizationEntity organizationEntity) {
        Organization organization = new Organization();
        organization.setId(organizationEntity.getId());
        organization.setName(organizationEntity.getName());
        organization.setDescription(organizationEntity.getDescription());
        organization.setDomainRestrictions(organizationEntity.getDomainRestrictions());
        return organization;
    }

    private OrganizationEntity convert(Organization organization) {
        OrganizationEntity organizationEntity = new OrganizationEntity();
        organizationEntity.setId(organization.getId());
        organizationEntity.setName(organization.getName());
        organizationEntity.setDescription(organization.getDescription());
        organizationEntity.setDomainRestrictions(organization.getDomainRestrictions());
        return organizationEntity;
    }

    @Override
    public void initialize() {
        Organization defaultOrganization = new Organization();
        defaultOrganization.setId(GraviteeContext.getDefaultOrganization());
        defaultOrganization.setName("Default organization");
        defaultOrganization.setDescription("Default organization");
        try {
            this.organizationRepository.create((Object)defaultOrganization);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to create default organization", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to create default organization", ex);
        }
    }
}

