/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.exceptions;

import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.service.exceptions.AbstractNotFoundException;
import java.util.HashMap;
import java.util.Map;

public class RoleNotFoundException
extends AbstractNotFoundException {
    private final String id;
    private final RoleScope roleScope;
    private final String roleName;

    public RoleNotFoundException(String id) {
        this.id = id;
        this.roleScope = null;
        this.roleName = null;
    }

    public RoleNotFoundException(RoleScope roleScope, String roleName) {
        this.id = null;
        this.roleScope = roleScope;
        this.roleName = roleName;
    }

    @Override
    public String getMessage() {
        if (this.id != null) {
            return "Role [" + this.id + "] can not be found.";
        }
        return "Role [" + this.roleScope.name() + "_" + this.roleName + "] can not be found.";
    }

    @Override
    public String getTechnicalCode() {
        return "role.notFound";
    }

    @Override
    public Map<String, String> getParameters() {
        return new HashMap<String, String>(){
            {
                this.put("id", RoleNotFoundException.this.id);
            }
        };
    }
}

