/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade;

import io.gravitee.rest.api.model.InstallationEntity;
import io.gravitee.rest.api.service.InstallationService;
import io.gravitee.rest.api.service.Upgrader;
import io.gravitee.rest.api.service.impl.upgrade.UpgradeStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;

public abstract class OneShotUpgrader
implements Upgrader,
Ordered {
    private static final Logger LOGGER = LoggerFactory.getLogger(OneShotUpgrader.class);
    @Autowired
    private InstallationService installationService;
    private String installationStatusKey;

    protected abstract void processOneShotUpgrade() throws Exception;

    public OneShotUpgrader(String installationStatusKey) {
        this.installationStatusKey = installationStatusKey;
    }

    @Override
    public final boolean upgrade() {
        if (!this.isEnabled()) {
            LOGGER.info("Skipping {} execution cause it's not enabled in configuration", (Object)this.getClass().getSimpleName());
            return false;
        }
        InstallationEntity installation = this.installationService.getOrInitialize();
        if (this.isDryRun() && this.isStatus(installation, UpgradeStatus.DRY_SUCCESS)) {
            LOGGER.info("Skipping {} execution cause it has already been successfully executed in dry mode", (Object)this.getClass().getSimpleName());
            return false;
        }
        if (this.isStatus(installation, UpgradeStatus.SUCCESS)) {
            LOGGER.info("Skipping {} execution cause it has already been successfully executed", (Object)this.getClass().getSimpleName());
            return false;
        }
        if (this.isStatus(installation, UpgradeStatus.RUNNING)) {
            LOGGER.warn("Skipping {} execution cause it's already running", (Object)this.getClass().getSimpleName());
            return false;
        }
        try {
            LOGGER.info("Starting {} execution with dry-run {}", (Object)this.getClass().getSimpleName(), (Object)(this.isDryRun() ? "enabled" : "disabled"));
            this.setExecutionStatus(installation, UpgradeStatus.RUNNING);
            this.processOneShotUpgrade();
            this.setExecutionStatus(installation, this.isDryRun() ? UpgradeStatus.DRY_SUCCESS : UpgradeStatus.SUCCESS);
        }
        catch (Throwable e) {
            LOGGER.error("{} execution failed", (Object)this.getClass().getSimpleName(), (Object)e);
            this.setExecutionStatus(installation, UpgradeStatus.FAILURE);
            return false;
        }
        LOGGER.info("Finishing {} execution", (Object)this.getClass().getSimpleName());
        return true;
    }

    private void setExecutionStatus(InstallationEntity installation, UpgradeStatus status) {
        installation.getAdditionalInformation().put(this.installationStatusKey, status.toString());
        this.installationService.setAdditionalInformation(installation.getAdditionalInformation());
    }

    private boolean isStatus(InstallationEntity installation, UpgradeStatus status) {
        return status.toString().equals(installation.getAdditionalInformation().get(this.installationStatusKey));
    }

    protected boolean isDryRun() {
        return false;
    }

    protected boolean isEnabled() {
        return true;
    }
}

