/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl.validation;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.rest.api.model.NewSubscriptionEntity;
import io.gravitee.rest.api.model.UpdateSubscriptionConfigurationEntity;
import io.gravitee.rest.api.model.UpdateSubscriptionEntity;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.TransactionalService;
import io.gravitee.rest.api.service.v4.EntrypointConnectorPluginService;
import io.gravitee.rest.api.service.v4.exception.SubscriptionEntrypointIdMissingException;
import io.gravitee.rest.api.service.v4.validation.SubscriptionValidationService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SubscriptionValidationServiceImpl
extends TransactionalService
implements SubscriptionValidationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SubscriptionValidationServiceImpl.class);
    private final EntrypointConnectorPluginService entrypointService;
    private final ObjectMapper objectMapper;

    public SubscriptionValidationServiceImpl(EntrypointConnectorPluginService entrypointService, ObjectMapper objectMapper) {
        this.entrypointService = entrypointService;
        this.objectMapper = objectMapper;
    }

    @Override
    public void validateAndSanitize(NewSubscriptionEntity subscription) {
        subscription.setConfiguration(this.validateAndSanitizeSubscriptionConfiguration(subscription.getConfiguration()));
    }

    @Override
    public void validateAndSanitize(UpdateSubscriptionEntity subscription) {
        subscription.setConfiguration(this.validateAndSanitizeSubscriptionConfiguration(subscription.getConfiguration()));
    }

    @Override
    public void validateAndSanitize(UpdateSubscriptionConfigurationEntity subscriptionConfiguration) {
        subscriptionConfiguration.setConfiguration(this.validateAndSanitizeSubscriptionConfiguration(subscriptionConfiguration.getConfiguration()));
    }

    private String validateAndSanitizeSubscriptionConfiguration(String configuration) {
        if (configuration == null) {
            return null;
        }
        try {
            String connectorId = this.objectMapper.readTree(configuration).path("entrypointId").asText();
            if (connectorId == null || connectorId.isEmpty()) {
                throw new SubscriptionEntrypointIdMissingException();
            }
            return this.entrypointService.validateEntrypointSubscriptionConfiguration(connectorId, configuration);
        }
        catch (JsonProcessingException e) {
            log.error("Failed to read subscription configuration", (Throwable)e);
            throw new TechnicalManagementException("An error occurs while trying to process promotion", e);
        }
    }
}

