/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade;

import io.gravitee.rest.api.model.configuration.identity.IdentityProviderActivationReferenceType;
import io.gravitee.rest.api.service.Upgrader;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.configuration.identity.IdentityProviderActivationService;
import io.gravitee.rest.api.service.configuration.identity.IdentityProviderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Component
public class IdentityProviderActivationUpgrader
implements Upgrader,
Ordered {
    private final Logger logger = LoggerFactory.getLogger(IdentityProviderActivationUpgrader.class);
    @Autowired
    private IdentityProviderService identityProviderService;
    @Autowired
    private IdentityProviderActivationService identityProviderActivationService;

    @Override
    public boolean upgrade() {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        IdentityProviderActivationService.ActivationTarget defaultEnvTarget = new IdentityProviderActivationService.ActivationTarget(GraviteeContext.getDefaultEnvironment(), IdentityProviderActivationReferenceType.ENVIRONMENT);
        IdentityProviderActivationService.ActivationTarget defaultOrgTarget = new IdentityProviderActivationService.ActivationTarget(GraviteeContext.getDefaultOrganization(), IdentityProviderActivationReferenceType.ORGANIZATION);
        if (this.identityProviderActivationService.findAllByTarget(defaultOrgTarget).isEmpty() && this.identityProviderActivationService.findAllByTarget(defaultEnvTarget).isEmpty()) {
            this.logger.info("    No activation found. Active all idp on all target by default if enabled.");
            this.identityProviderService.findAll(executionContext).forEach(idp -> {
                if (idp.isEnabled()) {
                    this.identityProviderActivationService.activateIdpOnTargets(executionContext, idp.getId(), defaultOrgTarget, defaultEnvTarget);
                }
            });
        }
        return true;
    }

    @Override
    public int getOrder() {
        return 400;
    }
}

