/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.AlertEventRepository;
import io.gravitee.repository.management.api.AlertTriggerRepository;
import io.gravitee.repository.management.api.search.AlertEventCriteria;
import io.gravitee.repository.management.model.AlertEvent;
import io.gravitee.repository.management.model.AlertTrigger;
import io.gravitee.rest.api.model.AlertAnalyticsQuery;
import io.gravitee.rest.api.model.alert.AlertAnalyticsEntity;
import io.gravitee.rest.api.model.alert.AlertReferenceType;
import io.gravitee.rest.api.service.AlertAnalyticsService;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class AlertAnalyticsServiceImpl
implements AlertAnalyticsService {
    private final Logger LOGGER = LoggerFactory.getLogger(AlertAnalyticsServiceImpl.class);
    private final AlertTriggerRepository alertTriggerRepository;
    private final AlertEventRepository alertEventRepository;

    public AlertAnalyticsServiceImpl(@Lazy AlertTriggerRepository alertTriggerRepository, @Lazy AlertEventRepository alertEventRepository) {
        this.alertTriggerRepository = alertTriggerRepository;
        this.alertEventRepository = alertEventRepository;
    }

    @Override
    public AlertAnalyticsEntity findByReference(AlertReferenceType referenceType, String referenceId, AlertAnalyticsQuery analyticsQuery) {
        try {
            Map<String, AlertTrigger> triggersById = this.alertTriggerRepository.findByReferenceAndReferenceId(referenceType.name(), referenceId).stream().collect(Collectors.toMap(AlertTrigger::getId, trigger -> trigger));
            Map<AlertTrigger, HashSet> eventsByAlert = triggersById.values().stream().map(trigger -> this.alertEventRepository.search(new AlertEventCriteria.Builder().alert(trigger.getId()).from(analyticsQuery.getFrom()).to(analyticsQuery.getTo()).build(), null)).filter(events -> events.getContent().size() > 0).collect(Collectors.toMap(event -> (AlertTrigger)triggersById.get(((AlertEvent)event.getContent().get(0)).getAlert()), event -> new HashSet(event.getContent())));
            Map<String, Integer> bySeverity = eventsByAlert.entrySet().stream().collect(Collectors.groupingBy(entry -> ((AlertTrigger)entry.getKey()).getSeverity(), Collectors.mapping(Map.Entry::getValue, Collectors.summingInt(HashSet::size))));
            List alerts = eventsByAlert.entrySet().stream().sorted(Map.Entry.comparingByKey((a1, a2) -> this.compareSeverity().compare(a1.getSeverity(), a2.getSeverity())).thenComparing(Map.Entry.comparingByValue(Comparator.comparing(Set::size)).reversed())).map(e -> {
                AlertAnalyticsEntity.AlertTriggerAnalytics alertTriggerAnalytics = new AlertAnalyticsEntity.AlertTriggerAnalytics();
                alertTriggerAnalytics.setId(((AlertTrigger)e.getKey()).getId());
                alertTriggerAnalytics.setType(((AlertTrigger)e.getKey()).getType());
                alertTriggerAnalytics.setSeverity(((AlertTrigger)e.getKey()).getSeverity());
                alertTriggerAnalytics.setName(((AlertTrigger)e.getKey()).getName());
                alertTriggerAnalytics.setEventsCount(Integer.valueOf(((HashSet)e.getValue()).size()));
                return alertTriggerAnalytics;
            }).collect(Collectors.toList());
            return new AlertAnalyticsEntity(bySeverity, alerts);
        }
        catch (TechnicalException ex) {
            String message = "An error occurs while trying to list alerts analytics by reference " + referenceType + "/" + referenceId;
            this.LOGGER.error(message, (Throwable)ex);
            throw new TechnicalManagementException(message, ex);
        }
    }

    private Comparator<String> compareSeverity() {
        return Comparator.comparing(s -> Severity.valueOf(s).getWeight());
    }

    private static enum Severity {
        CRITICAL(1),
        WARNING(10),
        INFO(100);

        private final Integer weight;

        private Severity(Integer weight) {
            this.weight = weight;
        }

        public Integer getWeight() {
            return this.weight;
        }
    }
}

