/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl;

import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.api.search.ApiFieldFilter;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.rest.api.model.CategoryEntity;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.CategoryService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.v4.ApiCategoryService;
import io.gravitee.rest.api.service.v4.ApiNotificationService;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ApiCategoryServiceImpl
implements ApiCategoryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiCategoryServiceImpl.class);
    private final ApiRepository apiRepository;
    private final CategoryService categoryService;
    private final ApiNotificationService apiNotificationService;
    private final AuditService auditService;

    public ApiCategoryServiceImpl(@Lazy ApiRepository apiRepository, CategoryService categoryService, ApiNotificationService apiNotificationService, AuditService auditService) {
        this.apiRepository = apiRepository;
        this.categoryService = categoryService;
        this.apiNotificationService = apiNotificationService;
        this.auditService = auditService;
    }

    @Override
    public Set<CategoryEntity> listCategories(Collection<String> apis, String environment) {
        try {
            ApiCriteria criteria = new ApiCriteria.Builder().ids(apis.toArray(new String[apis.size()])).build();
            Set categoryIds = this.apiRepository.listCategories(criteria);
            return this.categoryService.findByIdIn(environment, categoryIds);
        }
        catch (TechnicalException ex) {
            log.error("An error occurs while trying to list categories for APIs {}", apis, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to list categories for APIs {}" + apis, ex);
        }
    }

    @Override
    public void deleteCategoryFromAPIs(ExecutionContext executionContext, String categoryId) {
        this.apiRepository.search(new ApiCriteria.Builder().category(categoryId).build(), null, ApiFieldFilter.allFields()).forEach(api -> this.removeCategory(executionContext, (Api)api, categoryId));
    }

    private void removeCategory(ExecutionContext executionContext, Api api, String categoryId) {
        try {
            Api apiSnapshot = new Api(api);
            api.getCategories().remove(categoryId);
            api.setUpdatedAt(new Date());
            this.apiRepository.update((Object)api);
            this.apiNotificationService.triggerUpdateNotification(executionContext, api);
            this.auditService.createApiAuditLog(executionContext, api.getId(), Collections.emptyMap(), (Audit.AuditEvent)Api.AuditEvent.API_UPDATED, api.getUpdatedAt(), apiSnapshot, api);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("An error has occurred while removing category " + categoryId + " from API " + api.getId(), e);
        }
    }
}

