/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl;

import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.definition.model.v4.ConnectorFeature;
import io.gravitee.definition.model.v4.ConnectorMode;
import io.gravitee.definition.model.v4.listener.entrypoint.Qos;
import io.gravitee.gateway.jupiter.api.connector.ConnectorFactory;
import io.gravitee.gateway.jupiter.api.connector.endpoint.async.EndpointAsyncConnectorFactory;
import io.gravitee.gateway.jupiter.api.connector.entrypoint.async.EntrypointAsyncConnectorFactory;
import io.gravitee.plugin.core.api.ConfigurablePlugin;
import io.gravitee.plugin.core.api.ConfigurablePluginManager;
import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.plugin.entrypoint.EntrypointConnectorPluginManager;
import io.gravitee.rest.api.model.v4.connector.ConnectorPluginEntity;
import io.gravitee.rest.api.service.JsonSchemaService;
import io.gravitee.rest.api.service.impl.AbstractPluginService;
import io.gravitee.rest.api.service.v4.ConnectorPluginService;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractConnectorPluginService<T extends ConfigurablePlugin<?>>
extends AbstractPluginService<T, ConnectorPluginEntity>
implements ConnectorPluginService {
    protected AbstractConnectorPluginService(JsonSchemaService jsonSchemaService, ConfigurablePluginManager<T> pluginManager) {
        super(jsonSchemaService, pluginManager);
    }

    @Override
    public Set<ConnectorPluginEntity> findAll() {
        return super.list().stream().map(this::convert).collect(Collectors.toSet());
    }

    @Override
    public ConnectorPluginEntity findById(String entrypointPluginId) {
        Object resourceDefinition = super.get(entrypointPluginId);
        return this.convert((Plugin)resourceDefinition);
    }

    protected abstract ConnectorFactory<?> getConnectorFactory(String var1);

    protected ConnectorPluginEntity convert(Plugin plugin) {
        ConnectorPluginEntity entity = new ConnectorPluginEntity();
        entity.setId(plugin.id());
        entity.setDescription(plugin.manifest().description());
        entity.setName(plugin.manifest().name());
        entity.setVersion(plugin.manifest().version());
        ConnectorFactory<?> connectorFactory = this.getConnectorFactory(plugin.id());
        if (connectorFactory.supportedApi() != null) {
            entity.setSupportedApiType(ApiType.fromLabel((String)connectorFactory.supportedApi().getLabel()));
        }
        if (connectorFactory.supportedApi() == io.gravitee.gateway.jupiter.api.ApiType.ASYNC) {
            Set supportedQos = null;
            if (connectorFactory instanceof EntrypointAsyncConnectorFactory) {
                supportedQos = ((EntrypointAsyncConnectorFactory)connectorFactory).supportedQos();
            } else if (connectorFactory instanceof EndpointAsyncConnectorFactory) {
                supportedQos = ((EndpointAsyncConnectorFactory)connectorFactory).supportedQos();
            }
            if (supportedQos != null) {
                entity.setSupportedQos(supportedQos.stream().map(qos -> Qos.fromLabel((String)qos.getLabel())).collect(Collectors.toSet()));
            }
        }
        if (connectorFactory.supportedModes() != null) {
            entity.setSupportedModes(connectorFactory.supportedModes().stream().map(connectorMode -> ConnectorMode.fromLabel((String)connectorMode.getLabel())).collect(Collectors.toSet()));
        }
        if (connectorFactory.supportedApi() != null) {
            entity.setSupportedApiType(ApiType.fromLabel((String)connectorFactory.supportedApi().getLabel()));
        }
        if (plugin.manifest().properties() != null && plugin.manifest().properties().get("features") != null && !((String)plugin.manifest().properties().get("features")).isEmpty()) {
            entity.setAvailableFeatures(Arrays.stream(((String)plugin.manifest().properties().get("features")).split(",")).map(ConnectorFeature::fromLabel).collect(Collectors.toSet()));
        }
        return entity;
    }

    @Override
    public Set<ConnectorPluginEntity> findBySupportedApi(ApiType apiType) {
        return super.list().stream().filter(plugin -> ((EntrypointConnectorPluginManager)this.pluginManager).getFactoryById(plugin.id()).supportedApi().equals((Object)io.gravitee.gateway.jupiter.api.ApiType.fromLabel((String)apiType.getLabel()))).map(this::convert).collect(Collectors.toSet());
    }

    @Override
    public Set<ConnectorPluginEntity> findByConnectorMode(ConnectorMode connectorMode) {
        return super.list().stream().filter(plugin -> ((EntrypointConnectorPluginManager)this.pluginManager).getFactoryById(plugin.id()).supportedModes().contains(io.gravitee.gateway.jupiter.api.ConnectorMode.fromLabel((String)connectorMode.getLabel()))).map(this::convert).collect(Collectors.toSet());
    }

    @Override
    public String validateConnectorConfiguration(String connectorPluginId, String configuration) {
        ConnectorPluginEntity connectorPluginEntity = this.findById(connectorPluginId);
        return this.validateConfiguration(connectorPluginEntity.getId(), configuration);
    }
}

