/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.processor;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.rest.api.model.DeploymentRequired;
import java.lang.reflect.Field;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SynchronizationService {
    private final Logger LOGGER = LoggerFactory.getLogger(SynchronizationService.class);
    private final ObjectMapper objectMapper;

    public SynchronizationService(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> boolean checkSynchronization(Class<T> entityClass, T deployedEntity, T entityToDeploy) {
        ArrayList<Object> requiredFieldsDeployedApi = new ArrayList<Object>();
        ArrayList<Object> requiredFieldsApiToDeploy = new ArrayList<Object>();
        for (Field f : entityClass.getDeclaredFields()) {
            if (f.getAnnotation(DeploymentRequired.class) == null) continue;
            boolean previousAccessibleState = f.isAccessible();
            f.setAccessible(true);
            try {
                requiredFieldsDeployedApi.add(f.get(deployedEntity));
                requiredFieldsApiToDeploy.add(f.get(entityToDeploy));
            }
            catch (Exception e) {
                this.LOGGER.error("Error access entity required deployment fields", (Throwable)e);
            }
            finally {
                f.setAccessible(previousAccessibleState);
            }
        }
        try {
            String requiredFieldsDeployedApiDefinition = this.objectMapper.writeValueAsString(requiredFieldsDeployedApi);
            String requiredFieldsApiToDeployDefinition = this.objectMapper.writeValueAsString(requiredFieldsApiToDeploy);
            return requiredFieldsDeployedApiDefinition.equals(requiredFieldsApiToDeployDefinition);
        }
        catch (Exception e) {
            this.LOGGER.error("Unexpected error while generating API deployment required fields definition", (Throwable)e);
            return false;
        }
    }
}

