/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.PlanRepository;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.Plan;
import io.gravitee.repository.management.model.flow.FlowReferenceType;
import io.gravitee.rest.api.service.configuration.flow.FlowService;
import io.gravitee.rest.api.service.impl.upgrade.OneShotUpgrader;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class PlansFlowsDefinitionUpgrader
extends OneShotUpgrader {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlansFlowsDefinitionUpgrader.class);
    @Lazy
    @Autowired
    private ApiRepository apiRepository;
    @Lazy
    @Autowired
    private PlanRepository planRepository;
    @Autowired
    private FlowService flowService;
    @Autowired
    private ObjectMapper objectMapper;

    public PlansFlowsDefinitionUpgrader() {
        super("PLANS_FLOWS_UPGRADER_STATUS");
    }

    @Override
    public int getOrder() {
        return 550;
    }

    @Override
    protected void processOneShotUpgrade() throws Exception {
        for (Api api : this.apiRepository.findAll()) {
            io.gravitee.definition.model.Api apiDefinition = (io.gravitee.definition.model.Api)this.objectMapper.readValue(api.getDefinition(), io.gravitee.definition.model.Api.class);
            if (DefinitionVersion.V2 != apiDefinition.getDefinitionVersion()) continue;
            this.migrateApiFlows(api.getId(), apiDefinition);
        }
    }

    protected void migrateApiFlows(String apiId, io.gravitee.definition.model.Api apiDefinition) throws Exception {
        LOGGER.debug("Migrate flows for api [{}]", (Object)apiId);
        Map plansById = this.planRepository.findByApi(apiId).stream().collect(Collectors.toMap(Plan::getId, Function.identity()));
        this.flowService.save(FlowReferenceType.API, apiDefinition.getId(), apiDefinition.getFlows());
        apiDefinition.getPlans().forEach(apiDefinitionPlan -> {
            if (apiDefinitionPlan.getFlows() != null && !apiDefinitionPlan.getFlows().isEmpty() && plansById.containsKey(apiDefinitionPlan.getId())) {
                this.flowService.save(FlowReferenceType.PLAN, apiDefinitionPlan.getId(), apiDefinitionPlan.getFlows());
            }
        });
    }
}

