/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade;

import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.SubscriptionRepository;
import io.gravitee.repository.management.api.search.SubscriptionCriteria;
import io.gravitee.repository.management.model.Plan;
import io.gravitee.repository.management.model.Subscription;
import io.gravitee.rest.api.service.impl.upgrade.OneShotUpgrader;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ClientIdInApiKeySubscriptionsUpgrader
extends OneShotUpgrader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientIdInApiKeySubscriptionsUpgrader.class);
    private final SubscriptionRepository subscriptionRepository;

    @Autowired
    public ClientIdInApiKeySubscriptionsUpgrader(@Lazy SubscriptionRepository subscriptionRepository) {
        super("CLIENT_ID_IN_API_KEY_SUBSCRIPTIONS_UPGRADER_STATUS");
        this.subscriptionRepository = subscriptionRepository;
    }

    @Override
    public int getOrder() {
        return 502;
    }

    @Override
    protected void processOneShotUpgrade() throws TechnicalException {
        SubscriptionCriteria.Builder criteriaBuilder = new SubscriptionCriteria.Builder();
        criteriaBuilder.planSecurityTypes(List.of(Plan.PlanSecurityType.API_KEY));
        this.subscriptionRepository.search(criteriaBuilder.build()).forEach(this::updateApiKeySubscriptions);
    }

    private void updateApiKeySubscriptions(Subscription subscription) {
        try {
            if (subscription.getClientId() != null) {
                LOGGER.debug("Removing clientId from API key subscription [{}]", (Object)subscription);
                subscription.setClientId(null);
                this.subscriptionRepository.update((Object)subscription);
            }
        }
        catch (TechnicalException e) {
            LOGGER.error("Failed to remove clientID from API key subscriptions for API key [{}]", (Object)subscription, (Object)e);
        }
    }
}

