/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.repository.analytics.AnalyticsException;
import io.gravitee.repository.analytics.api.AnalyticsRepository;
import io.gravitee.repository.analytics.query.AggregationType;
import io.gravitee.repository.analytics.query.DateHistogramQueryBuilder;
import io.gravitee.repository.analytics.query.DateRangeBuilder;
import io.gravitee.repository.analytics.query.IntervalBuilder;
import io.gravitee.repository.analytics.query.Order;
import io.gravitee.repository.analytics.query.Query;
import io.gravitee.repository.analytics.query.QueryBuilders;
import io.gravitee.repository.analytics.query.SortBuilder;
import io.gravitee.repository.analytics.query.SortType;
import io.gravitee.repository.analytics.query.count.CountQueryBuilder;
import io.gravitee.repository.analytics.query.count.CountResponse;
import io.gravitee.repository.analytics.query.groupby.GroupByQueryBuilder;
import io.gravitee.repository.analytics.query.groupby.GroupByResponse;
import io.gravitee.repository.analytics.query.response.histogram.Data;
import io.gravitee.repository.analytics.query.response.histogram.DateHistogramResponse;
import io.gravitee.repository.analytics.query.stats.StatsQueryBuilder;
import io.gravitee.repository.analytics.query.stats.StatsResponse;
import io.gravitee.repository.management.model.ApplicationStatus;
import io.gravitee.rest.api.model.ApplicationEntity;
import io.gravitee.rest.api.model.TenantEntity;
import io.gravitee.rest.api.model.TenantReferenceType;
import io.gravitee.rest.api.model.analytics.Bucket;
import io.gravitee.rest.api.model.analytics.HistogramAnalytics;
import io.gravitee.rest.api.model.analytics.HitsAnalytics;
import io.gravitee.rest.api.model.analytics.Timestamp;
import io.gravitee.rest.api.model.analytics.TopHitsAnalytics;
import io.gravitee.rest.api.model.analytics.query.CountQuery;
import io.gravitee.rest.api.model.analytics.query.DateHistogramQuery;
import io.gravitee.rest.api.model.analytics.query.GroupByQuery;
import io.gravitee.rest.api.model.analytics.query.StatsAnalytics;
import io.gravitee.rest.api.model.analytics.query.StatsQuery;
import io.gravitee.rest.api.model.api.ApiLifecycleState;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.model.v4.plan.GenericPlanEntity;
import io.gravitee.rest.api.service.AnalyticsService;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.TenantService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.AnalyticsCalculateException;
import io.gravitee.rest.api.service.exceptions.ApiNotFoundException;
import io.gravitee.rest.api.service.exceptions.ApplicationNotFoundException;
import io.gravitee.rest.api.service.exceptions.PlanNotFoundException;
import io.gravitee.rest.api.service.exceptions.TenantNotFoundException;
import io.gravitee.rest.api.service.v4.ApiSearchService;
import io.gravitee.rest.api.service.v4.PlanSearchService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class AnalyticsServiceImpl
implements AnalyticsService {
    private static final String UNKNOWN_SERVICE = "1";
    private static final String UNKNOWN_SERVICE_MAPPED = "?";
    private static final String METADATA_NAME = "name";
    private static final String METADATA_DELETED = "deleted";
    private static final String METADATA_UNKNOWN = "unknown";
    private static final String METADATA_VERSION = "version";
    private static final String METADATA_UNKNOWN_API_NAME = "Unknown API (not found)";
    private static final String METADATA_UNKNOWN_APPLICATION_NAME = "Unknown application (keyless)";
    private static final String METADATA_UNKNOWN_PLAN_NAME = "Unknown plan (keyless)";
    private static final String METADATA_DELETED_API_NAME = "Deleted API";
    private static final String METADATA_DELETED_APPLICATION_NAME = "Deleted application";
    private static final String METADATA_DELETED_TENANT_NAME = "Deleted tenant";
    private static final String METADATA_DELETED_PLAN_NAME = "Deleted plan";
    private static final String FIELD_API = "api";
    private static final String FIELD_APPLICATION = "application";
    private static final String FIELD_TENANT = "tenant";
    private static final String FIELD_PLAN = "plan";
    private static final String FIELD_GEOIP_COUNTRY_ISO_CODE = "geoip.country_iso_code";
    private final Logger logger = LoggerFactory.getLogger(AnalyticsServiceImpl.class);
    @Lazy
    @Autowired
    private AnalyticsRepository analyticsRepository;
    @Autowired
    private ApiSearchService apiSearchService;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private PlanSearchService planSearchService;
    @Autowired
    private TenantService tenantService;

    @Override
    public StatsAnalytics execute(StatsQuery query) {
        try {
            StatsResponse response = (StatsResponse)this.analyticsRepository.query((Query)((StatsQueryBuilder)((StatsQueryBuilder)((StatsQueryBuilder)QueryBuilders.stats().query(query.getQuery())).timeRange(DateRangeBuilder.between((long)query.getFrom(), (long)query.getTo()), IntervalBuilder.interval((long)query.getInterval()))).root(query.getRootField(), query.getRootIdentifier())).field(query.getField()).build());
            return this.convert(response, query);
        }
        catch (AnalyticsException ae) {
            this.logger.error("Unable to calculate analytics: ", (Throwable)ae);
            throw new AnalyticsCalculateException("Unable to calculate analytics");
        }
    }

    @Override
    public HitsAnalytics execute(CountQuery query) {
        try {
            CountResponse response = (CountResponse)this.analyticsRepository.query((Query)((CountQueryBuilder)((CountQueryBuilder)((CountQueryBuilder)QueryBuilders.count().query(query.getQuery())).timeRange(DateRangeBuilder.between((long)query.getFrom(), (long)query.getTo()), IntervalBuilder.interval((long)query.getInterval()))).root(query.getRootField(), query.getRootIdentifier())).build());
            return this.convert(response);
        }
        catch (AnalyticsException ae) {
            this.logger.error("Unable to calculate analytics: ", (Throwable)ae);
            throw new AnalyticsCalculateException("Unable to calculate analytics");
        }
    }

    @Override
    public HistogramAnalytics execute(ExecutionContext executionContext, DateHistogramQuery query) {
        try {
            DateHistogramQueryBuilder queryBuilder = (DateHistogramQueryBuilder)((DateHistogramQueryBuilder)((DateHistogramQueryBuilder)QueryBuilders.dateHistogram().query(query.getQuery())).timeRange(DateRangeBuilder.between((long)query.getFrom(), (long)query.getTo()), IntervalBuilder.interval((long)query.getInterval()))).root(query.getRootField(), query.getRootIdentifier());
            if (query.getAggregations() != null) {
                query.getAggregations().stream().forEach(aggregation -> queryBuilder.aggregation(AggregationType.valueOf((String)aggregation.type().name()), aggregation.field()));
            }
            DateHistogramResponse response = (DateHistogramResponse)this.analyticsRepository.query((Query)queryBuilder.build());
            return this.convert(executionContext, response);
        }
        catch (AnalyticsException ae) {
            this.logger.error("Unable to calculate analytics: ", (Throwable)ae);
            throw new AnalyticsCalculateException("Unable to calculate analytics");
        }
    }

    @Override
    public TopHitsAnalytics execute(ExecutionContext executionContext, GroupByQuery query) {
        try {
            GroupByQueryBuilder queryBuilder = ((GroupByQueryBuilder)((GroupByQueryBuilder)((GroupByQueryBuilder)QueryBuilders.groupBy().query(query.getQuery())).timeRange(DateRangeBuilder.between((long)query.getFrom(), (long)query.getTo()), IntervalBuilder.interval((long)query.getInterval()))).root(query.getRootField(), query.getRootIdentifier())).field(query.getField());
            if (query.getGroups() != null) {
                query.getGroups().forEach((arg_0, arg_1) -> ((GroupByQueryBuilder)queryBuilder).range(arg_0, arg_1));
            }
            if (query.getOrder() != null) {
                GroupByQuery.Order order = query.getOrder();
                queryBuilder.sort(SortBuilder.on((String)order.getField(), (Order)(order.isOrder() ? Order.ASC : Order.DESC), (SortType)(order.getType() == null ? SortType.AVG : SortType.valueOf((String)order.getType().toUpperCase()))));
            }
            GroupByResponse response = (GroupByResponse)this.analyticsRepository.query((Query)queryBuilder.build());
            return this.convert(executionContext, response);
        }
        catch (AnalyticsException ae) {
            this.logger.error("Unable to calculate analytics: ", (Throwable)ae);
            throw new AnalyticsCalculateException("Unable to calculate analytics");
        }
    }

    private HistogramAnalytics convert(ExecutionContext executionContext, DateHistogramResponse histogramResponse) {
        HistogramAnalytics analytics = new HistogramAnalytics();
        List timestamps = histogramResponse.timestamps();
        if (timestamps != null && timestamps.size() > 1) {
            long from = (Long)timestamps.get(0);
            long interval = (Long)timestamps.get(1) - from;
            long to = (Long)timestamps.get(timestamps.size() - 1);
            analytics.setTimestamp(new Timestamp(Long.valueOf(from), Long.valueOf(to), Long.valueOf(interval)));
            ArrayList<Bucket> buckets = new ArrayList<Bucket>(histogramResponse.values().size());
            for (io.gravitee.repository.analytics.query.response.histogram.Bucket bucket : histogramResponse.values()) {
                Bucket analyticsBucket = this.convertBucket(executionContext, histogramResponse.timestamps(), from, interval, bucket);
                buckets.add(analyticsBucket);
            }
            analytics.setValues(buckets);
        }
        return analytics;
    }

    private Bucket convertBucket(ExecutionContext executionContext, List<Long> timestamps, long from, long interval, io.gravitee.repository.analytics.query.response.histogram.Bucket bucket) {
        HashMap metadata;
        Bucket analyticsBucket = new Bucket();
        analyticsBucket.setName(bucket.name());
        analyticsBucket.setField(bucket.field());
        ArrayList<Bucket> childBuckets = new ArrayList<Bucket>();
        for (io.gravitee.repository.analytics.query.response.histogram.Bucket bucket2 : bucket.buckets()) {
            childBuckets.add(this.convertBucket(executionContext, timestamps, from, interval, bucket2));
        }
        if (FIELD_APPLICATION.equals(analyticsBucket.getField())) {
            metadata = new HashMap();
            bucket.data().keySet().forEach(app -> metadata.put(app, this.getApplicationMetadata(executionContext, (String)app)));
            analyticsBucket.setMetadata(metadata);
        } else if (FIELD_API.equals(analyticsBucket.getField())) {
            metadata = new HashMap();
            bucket.data().keySet().forEach(api -> metadata.put(api, this.getAPIMetadata(executionContext, (String)api)));
            analyticsBucket.setMetadata(metadata);
        } else if (FIELD_TENANT.equals(analyticsBucket.getField())) {
            metadata = new HashMap();
            bucket.data().keySet().forEach(tenant -> metadata.put(tenant, this.getTenantMetadata(executionContext.getOrganizationId(), (String)tenant)));
            analyticsBucket.setMetadata(metadata);
        }
        for (Map.Entry entry : bucket.data().entrySet()) {
            Bucket analyticsDataBucket = new Bucket();
            analyticsDataBucket.setName((String)entry.getKey());
            Number[] values = new Number[timestamps.size()];
            for (int i = 0; i < timestamps.size(); ++i) {
                values[i] = 0;
            }
            for (Data data : (List)entry.getValue()) {
                values[(int)((data.timestamp() - from) / interval)] = data.value();
            }
            analyticsDataBucket.setData(values);
            childBuckets.add(analyticsDataBucket);
        }
        analyticsBucket.setBuckets(childBuckets);
        return analyticsBucket;
    }

    private StatsAnalytics convert(StatsResponse statsResponse, StatsQuery query) {
        StatsAnalytics statsAnalytics = new StatsAnalytics();
        statsAnalytics.setAvg(statsResponse.getAvg());
        statsAnalytics.setCount(statsResponse.getCount());
        statsAnalytics.setMax(statsResponse.getMax());
        statsAnalytics.setMin(statsResponse.getMin());
        statsAnalytics.setSum(statsResponse.getSum());
        if (statsResponse.getCount() != null) {
            long numberOfSeconds = (query.getTo() - query.getFrom()) / 1000L;
            statsAnalytics.setRps(Float.valueOf(statsResponse.getCount().floatValue() / (float)numberOfSeconds));
            statsAnalytics.setRpm(Float.valueOf(statsResponse.getCount().floatValue() / (float)numberOfSeconds * 60.0f));
            statsAnalytics.setRph(Float.valueOf(statsResponse.getCount().floatValue() / (float)numberOfSeconds * 3600.0f));
        }
        return statsAnalytics;
    }

    private HitsAnalytics convert(CountResponse countResponse) {
        HitsAnalytics hitsAnalytics = new HitsAnalytics();
        hitsAnalytics.setHits(countResponse.getCount());
        return hitsAnalytics;
    }

    private TopHitsAnalytics convert(ExecutionContext executionContext, GroupByResponse groupByResponse) {
        TopHitsAnalytics topHitsAnalytics = new TopHitsAnalytics();
        topHitsAnalytics.setValues((Map)groupByResponse.values().stream().collect(Collectors.toMap(bucket -> UNKNOWN_SERVICE.equals(bucket.name()) ? UNKNOWN_SERVICE_MAPPED : bucket.name(), GroupByResponse.Bucket::value, (v1, v2) -> {
            throw new RuntimeException(String.format("Duplicate key for values %s and %s", v1, v2));
        }, LinkedHashMap::new)));
        String fieldName = groupByResponse.getField();
        if (fieldName != null && !fieldName.isEmpty()) {
            HashMap<String, Map<String, String>> metadata = new HashMap<String, Map<String, String>>();
            if (topHitsAnalytics.getValues() != null) {
                int i = 0;
                for (String key : topHitsAnalytics.getValues().keySet()) {
                    switch (fieldName) {
                        case "api": {
                            metadata.put(key, this.getAPIMetadata(executionContext, key));
                            break;
                        }
                        case "application": {
                            metadata.put(key, this.getApplicationMetadata(executionContext, key));
                            break;
                        }
                        case "plan": {
                            metadata.put(key, this.getPlanMetadata(executionContext, key));
                            break;
                        }
                        case "tenant": {
                            metadata.put(key, this.getTenantMetadata(executionContext.getOrganizationId(), key));
                            break;
                        }
                        case "geoip.country_iso_code": {
                            metadata.put(key, this.getCountryName(key));
                            break;
                        }
                        default: {
                            metadata.put(key, this.getGenericMetadata(key));
                        }
                    }
                    ((Map)metadata.get(key)).put("order", String.valueOf(i));
                    ++i;
                }
            }
            topHitsAnalytics.setMetadata(metadata);
        }
        return topHitsAnalytics;
    }

    private Map<String, String> getAPIMetadata(ExecutionContext executionContext, String api) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        try {
            if (api.equals(UNKNOWN_SERVICE) || api.equals(UNKNOWN_SERVICE_MAPPED)) {
                metadata.put(METADATA_NAME, METADATA_UNKNOWN_API_NAME);
                metadata.put(METADATA_UNKNOWN, Boolean.TRUE.toString());
            } else {
                GenericApiEntity genericApiEntity = this.apiSearchService.findGenericById(executionContext, api);
                metadata.put(METADATA_NAME, genericApiEntity.getName());
                metadata.put(METADATA_VERSION, genericApiEntity.getApiVersion());
                if (ApiLifecycleState.ARCHIVED.equals((Object)genericApiEntity.getLifecycleState())) {
                    metadata.put(METADATA_DELETED, Boolean.TRUE.toString());
                }
            }
        }
        catch (ApiNotFoundException anfe) {
            metadata.put(METADATA_DELETED, Boolean.TRUE.toString());
            metadata.put(METADATA_NAME, METADATA_DELETED_API_NAME);
        }
        return metadata;
    }

    private Map<String, String> getApplicationMetadata(ExecutionContext executionContext, String application) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        try {
            if (application.equals(UNKNOWN_SERVICE) || application.equals(UNKNOWN_SERVICE_MAPPED)) {
                metadata.put(METADATA_NAME, METADATA_UNKNOWN_APPLICATION_NAME);
                metadata.put(METADATA_UNKNOWN, Boolean.TRUE.toString());
            } else {
                ApplicationEntity applicationEntity = this.applicationService.findById(executionContext, application);
                metadata.put(METADATA_NAME, applicationEntity.getName());
                if (ApplicationStatus.ARCHIVED.toString().equals(applicationEntity.getStatus())) {
                    metadata.put(METADATA_DELETED, Boolean.TRUE.toString());
                }
            }
        }
        catch (ApplicationNotFoundException anfe) {
            metadata.put(METADATA_DELETED, Boolean.TRUE.toString());
            metadata.put(METADATA_NAME, METADATA_DELETED_APPLICATION_NAME);
        }
        return metadata;
    }

    private Map<String, String> getPlanMetadata(ExecutionContext executionContext, String plan) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        try {
            if (plan.equals(UNKNOWN_SERVICE) || plan.equals(UNKNOWN_SERVICE_MAPPED)) {
                metadata.put(METADATA_NAME, METADATA_UNKNOWN_PLAN_NAME);
                metadata.put(METADATA_UNKNOWN, Boolean.TRUE.toString());
            } else {
                GenericPlanEntity genericPlanEntity = this.planSearchService.findById(executionContext, plan);
                metadata.put(METADATA_NAME, genericPlanEntity.getName());
            }
        }
        catch (PlanNotFoundException anfe) {
            metadata.put(METADATA_DELETED, Boolean.TRUE.toString());
            metadata.put(METADATA_NAME, METADATA_DELETED_PLAN_NAME);
        }
        return metadata;
    }

    private Map<String, String> getTenantMetadata(String organizationId, String tenant) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        try {
            TenantEntity tenantEntity = this.tenantService.findByIdAndReference(tenant, organizationId, TenantReferenceType.ORGANIZATION);
            metadata.put(METADATA_NAME, tenantEntity.getName());
        }
        catch (TenantNotFoundException tnfe) {
            metadata.put(METADATA_DELETED, Boolean.TRUE.toString());
            metadata.put(METADATA_NAME, METADATA_DELETED_TENANT_NAME);
        }
        return metadata;
    }

    private Map<String, String> getCountryName(String country_iso) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put(METADATA_NAME, new Locale("", country_iso).getDisplayCountry(Locale.UK));
        return metadata;
    }

    private Map<String, String> getGenericMetadata(String value) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put(METADATA_NAME, value);
        return metadata;
    }
}

