/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.common;

import io.gravitee.repository.management.model.Environment;
import io.gravitee.repository.management.model.Organization;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.EnvironmentNotFoundException;
import java.util.Objects;
import java.util.Optional;

public class ExecutionContext {
    private final String organizationId;
    private final Optional<String> environmentId;

    public ExecutionContext(String organizationId, String environmentId) {
        this.organizationId = organizationId;
        this.environmentId = Optional.ofNullable(environmentId);
    }

    public ExecutionContext(EnvironmentEntity environment) {
        this(environment.getOrganizationId(), environment.getId());
    }

    public ExecutionContext(Environment environment) {
        this(environment.getOrganizationId(), environment.getId());
    }

    public ExecutionContext(Organization organization) {
        this(organization.getId(), null);
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getEnvironmentId() throws EnvironmentNotFoundException {
        return this.environmentId.orElseThrow(() -> new EnvironmentNotFoundException(null));
    }

    public boolean hasEnvironmentId() {
        return this.environmentId.isPresent();
    }

    public GraviteeContext.ReferenceContext getReferenceContext() {
        return this.environmentId.map(id -> new GraviteeContext.ReferenceContext((String)id, GraviteeContext.ReferenceContextType.ENVIRONMENT)).orElseGet(() -> new GraviteeContext.ReferenceContext(this.organizationId, GraviteeContext.ReferenceContextType.ORGANIZATION));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutionContext that = (ExecutionContext)o;
        return Objects.equals(this.organizationId, that.organizationId) && Objects.equals(this.environmentId, that.environmentId);
    }

    public int hashCode() {
        return Objects.hash(this.organizationId, this.environmentId);
    }

    public String toString() {
        return "ExecutionContext{organizationId='" + this.organizationId + "', environmentId=" + this.environmentId + "}";
    }
}

