/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade;

import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.EnvironmentRepository;
import io.gravitee.repository.management.api.UserRepository;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.api.search.ApiFieldFilter;
import io.gravitee.repository.management.api.search.UserCriteria;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.Environment;
import io.gravitee.repository.management.model.User;
import io.gravitee.repository.management.model.UserStatus;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.PageType;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.UserRoleEntity;
import io.gravitee.rest.api.model.documentation.PageQuery;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.model.search.Indexable;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.service.PageService;
import io.gravitee.rest.api.service.Upgrader;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.common.SecurityContextHelper;
import io.gravitee.rest.api.service.converter.ApiConverter;
import io.gravitee.rest.api.service.converter.UserConverter;
import io.gravitee.rest.api.service.exceptions.PrimaryOwnerNotFoundException;
import io.gravitee.rest.api.service.search.SearchEngineService;
import io.gravitee.rest.api.service.v4.PrimaryOwnerService;
import io.gravitee.rest.api.service.v4.mapper.ApiMapper;
import io.gravitee.rest.api.service.v4.mapper.GenericApiMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Component
public class SearchIndexUpgrader
implements Upgrader,
Ordered {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchIndexUpgrader.class);
    private final ApiRepository apiRepository;
    private final GenericApiMapper genericApiMapper;
    private final PageService pageService;
    private final UserRepository userRepository;
    private final SearchEngineService searchEngineService;
    private final EnvironmentRepository environmentRepository;
    private final ApiMapper apiMapper;
    private final ApiConverter apiConverter;
    private final UserConverter userConverter;
    private final Map<String, String> organizationIdByEnvironmentIdMap = new ConcurrentHashMap<String, String>();
    private final PrimaryOwnerService primaryOwnerService;

    @Autowired
    public SearchIndexUpgrader(@Lazy ApiRepository apiRepository, GenericApiMapper genericApiMapper, PageService pageService, @Lazy UserRepository userRepository, SearchEngineService searchEngineService, @Lazy EnvironmentRepository environmentRepository, ApiMapper apiMapper, ApiConverter apiConverter, UserConverter userConverter, PrimaryOwnerService primaryOwnerService) {
        this.apiRepository = apiRepository;
        this.genericApiMapper = genericApiMapper;
        this.pageService = pageService;
        this.userRepository = userRepository;
        this.searchEngineService = searchEngineService;
        this.environmentRepository = environmentRepository;
        this.apiMapper = apiMapper;
        this.apiConverter = apiConverter;
        this.userConverter = userConverter;
        this.primaryOwnerService = primaryOwnerService;
    }

    @Override
    public boolean upgrade() {
        ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2, new ThreadFactory(){
            private final AtomicLong counter = new AtomicLong(0L);

            @Override
            public Thread newThread(@NotNull Runnable r) {
                return new Thread(r, "gio.search-indexer-upgrader-" + this.counter.getAndIncrement());
            }
        });
        ArrayList futures = new ArrayList();
        try {
            futures.addAll(this.runApisIndexationAsync(executorService));
        }
        catch (TechnicalException e) {
            LOGGER.error("failed to index APIs", (Throwable)e);
        }
        try {
            futures.addAll(this.runUsersIndexationAsync(executorService));
        }
        catch (TechnicalException e) {
            LOGGER.error("failed to index users", (Throwable)e);
        }
        CompletableFuture<Void> future = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        future.whenCompleteAsync((unused, throwable) -> {
            executorService.shutdown();
            this.searchEngineService.commit();
        }, (Executor)executorService);
        return true;
    }

    protected List<CompletableFuture<?>> runApisIndexationAsync(ExecutorService executorService) throws TechnicalException {
        return this.apiRepository.search(new ApiCriteria.Builder().build(), null, ApiFieldFilter.allFields()).map(api -> this.runApiIndexationAsync(executorService, (Api)api)).collect(Collectors.toList());
    }

    private CompletableFuture<?> runApiIndexationAsync(ExecutorService executorService, Api api) {
        this.authenticateAsAdmin();
        String environmentId = api.getEnvironmentId();
        String organizationId = this.organizationIdByEnvironmentIdMap.computeIfAbsent(environmentId, envId -> {
            try {
                return ((Environment)this.environmentRepository.findById((Object)environmentId).get()).getOrganizationId();
            }
            catch (Exception e) {
                LOGGER.error("failed to find organization for environment {}", (Object)environmentId, (Object)e);
                return null;
            }
        });
        ExecutionContext executionContext = new ExecutionContext(organizationId, environmentId);
        PrimaryOwnerEntity primaryOwner = null;
        try {
            primaryOwner = this.primaryOwnerService.getPrimaryOwner(executionContext, api.getId());
        }
        catch (PrimaryOwnerNotFoundException e) {
            LOGGER.warn("Failed to retrieve API primary owner, API will we indexed without his primary owner", (Throwable)e);
        }
        Object indexable = api.getDefinitionVersion() == DefinitionVersion.V4 ? this.apiMapper.toEntity(executionContext, api, primaryOwner, null, false) : this.apiConverter.toApiEntity(api, primaryOwner);
        return this.runApiIndexationAsync(executionContext, api, primaryOwner, (Indexable)indexable, executorService);
    }

    private CompletableFuture<?> runApiIndexationAsync(ExecutionContext executionContext, Api api, PrimaryOwnerEntity primaryOwnerEntity, Indexable indexable, ExecutorService executorService) {
        return CompletableFuture.runAsync(() -> {
            try {
                this.searchEngineService.index(executionContext, indexable, true, false);
                GenericApiEntity genericApiEntity = this.genericApiMapper.toGenericApi(api, primaryOwnerEntity);
                List<PageEntity> apiPages = this.pageService.search(executionContext.getEnvironmentId(), new PageQuery.Builder().api(api.getId()).published(Boolean.valueOf(true)).build(), true);
                apiPages.forEach(page -> {
                    try {
                        if (!(PageType.FOLDER.name().equals(page.getType()) || PageType.ROOT.name().equals(page.getType()) || PageType.SYSTEM_FOLDER.name().equals(page.getType()) || PageType.LINK.name().equals(page.getType()))) {
                            this.pageService.transformSwagger(executionContext, (PageEntity)page, genericApiEntity);
                            this.searchEngineService.index(executionContext, (Indexable)page, true, false);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            }
            finally {
                GraviteeContext.cleanContext();
            }
        }, executorService);
    }

    protected List<CompletableFuture<?>> runUsersIndexationAsync(ExecutorService executorService) throws TechnicalException {
        return this.userRepository.search(new UserCriteria.Builder().statuses(new UserStatus[]{UserStatus.ACTIVE}).build(), new PageableBuilder().pageNumber(0).pageSize(Integer.MAX_VALUE).build()).getContent().stream().map(user -> this.runUserIndexationAsync(executorService, (User)user)).collect(Collectors.toList());
    }

    private CompletableFuture<?> runUserIndexationAsync(ExecutorService executorService, User user) {
        return CompletableFuture.runAsync(() -> {
            ExecutionContext executionContext = new ExecutionContext(user.getOrganizationId(), null);
            this.searchEngineService.index(executionContext, (Indexable)this.userConverter.toUserEntity(user), true, false);
        }, executorService);
    }

    @Override
    public int getOrder() {
        return 250;
    }

    private void authenticateAsAdmin() {
        UserRoleEntity adminRole = new UserRoleEntity();
        adminRole.setScope(RoleScope.ORGANIZATION);
        adminRole.setName(SystemRole.ADMIN.name());
        SecurityContextHelper.authenticateAsSystem("SearchIndexUpgrader", Set.of(adminRole));
    }
}

