/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.common.utils.IdGenerator;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.TagRepository;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Tag;
import io.gravitee.repository.management.model.TagReferenceType;
import io.gravitee.rest.api.model.GroupEntity;
import io.gravitee.rest.api.model.NewTagEntity;
import io.gravitee.rest.api.model.TagEntity;
import io.gravitee.rest.api.model.UpdateTagEntity;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.TagService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.DuplicateTagNameException;
import io.gravitee.rest.api.service.exceptions.TagNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.v4.ApiTagService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class TagServiceImpl
extends AbstractService
implements TagService {
    private final Logger LOGGER = LoggerFactory.getLogger(TagServiceImpl.class);
    @Lazy
    @Autowired
    private TagRepository tagRepository;
    @Autowired
    private ApiTagService apiTagService;
    @Autowired
    private AuditService auditService;
    @Autowired
    private GroupService groupService;

    @Override
    public List<TagEntity> findByReference(String referenceId, io.gravitee.rest.api.model.TagReferenceType referenceType) {
        try {
            this.LOGGER.debug("Find all tags");
            return this.tagRepository.findByReference(referenceId, this.repoTagReferenceType(referenceType)).stream().map(this::convert).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find all tags", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find all tags", ex);
        }
    }

    @Override
    public TagEntity findByIdAndReference(String tagId, String referenceId, io.gravitee.rest.api.model.TagReferenceType referenceType) {
        try {
            this.LOGGER.debug("Find tag by ID: {}", (Object)tagId);
            Optional optTag = this.tagRepository.findByIdAndReference(tagId, referenceId, this.repoTagReferenceType(referenceType));
            if (!optTag.isPresent()) {
                throw new TagNotFoundException(tagId);
            }
            return this.convert((Tag)optTag.get());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find tag by ID", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find tag by ID", ex);
        }
    }

    @Override
    public void checkTagsExist(Set<String> tagIds, String referenceId, io.gravitee.rest.api.model.TagReferenceType referenceType) throws TechnicalException {
        Set foundTags = this.tagRepository.findByIdsAndReference(tagIds, referenceId, this.repoTagReferenceType(referenceType));
        if (foundTags.size() == tagIds.size()) {
            return;
        }
        foundTags.forEach(tag -> tagIds.remove(tag.getId()));
        throw new TagNotFoundException((String[])tagIds.toArray(String[]::new));
    }

    @Override
    public TagEntity create(ExecutionContext executionContext, NewTagEntity tag, String referenceId, io.gravitee.rest.api.model.TagReferenceType referenceType) {
        return this.create(executionContext, Collections.singletonList(tag), referenceId, referenceType).get(0);
    }

    @Override
    public TagEntity update(ExecutionContext executionContext, UpdateTagEntity tag, String referenceId, io.gravitee.rest.api.model.TagReferenceType referenceType) {
        return this.update(executionContext, Collections.singletonList(tag), referenceId, referenceType).get(0);
    }

    @Override
    public List<TagEntity> create(ExecutionContext executionContext, List<NewTagEntity> tagEntities, String referenceId, io.gravitee.rest.api.model.TagReferenceType referenceType) {
        List tagNames = tagEntities.stream().map(NewTagEntity::getName).collect(Collectors.toList());
        Optional<TagEntity> optionalTag = this.findByReference(referenceId, referenceType).stream().filter(tag -> tagNames.contains(tag.getName())).findAny();
        if (optionalTag.isPresent()) {
            throw new DuplicateTagNameException(optionalTag.get().getName());
        }
        ArrayList<TagEntity> savedTags = new ArrayList<TagEntity>(tagEntities.size());
        tagEntities.forEach(tagEntity -> {
            try {
                Tag tag = this.convert((NewTagEntity)tagEntity, referenceId, referenceType);
                savedTags.add(this.convert((Tag)this.tagRepository.create((Object)tag)));
                this.auditService.createOrganizationAuditLog(executionContext, executionContext.getOrganizationId(), Collections.singletonMap(Audit.AuditProperties.TAG, tag.getId()), (Audit.AuditEvent)Tag.AuditEvent.TAG_CREATED, new Date(), null, tag);
            }
            catch (TechnicalException ex) {
                this.LOGGER.error("An error occurs while trying to create tag {}", (Object)tagEntity.getName(), (Object)ex);
                throw new TechnicalManagementException("An error occurs while trying to create tag " + tagEntity.getName(), ex);
            }
        });
        return savedTags;
    }

    @Override
    public List<TagEntity> update(ExecutionContext executionContext, List<UpdateTagEntity> tagEntities, String referenceId, io.gravitee.rest.api.model.TagReferenceType referenceType) {
        ArrayList<TagEntity> savedTags = new ArrayList<TagEntity>(tagEntities.size());
        tagEntities.forEach(tagEntity -> {
            try {
                Tag tag = this.convert((UpdateTagEntity)tagEntity);
                Optional tagOptional = this.tagRepository.findByIdAndReference(tag.getId(), referenceId, this.repoTagReferenceType(referenceType));
                if (tagOptional.isPresent()) {
                    Tag existingTag = (Tag)tagOptional.get();
                    tag.setReferenceId(existingTag.getReferenceId());
                    tag.setReferenceType(existingTag.getReferenceType());
                    savedTags.add(this.convert((Tag)this.tagRepository.update((Object)tag)));
                    this.auditService.createOrganizationAuditLog(executionContext, executionContext.getOrganizationId(), Collections.singletonMap(Audit.AuditProperties.TAG, tag.getId()), (Audit.AuditEvent)Tag.AuditEvent.TAG_UPDATED, new Date(), tagOptional.get(), tag);
                }
            }
            catch (TechnicalException ex) {
                this.LOGGER.error("An error occurs while trying to update tag {}", (Object)tagEntity.getName(), (Object)ex);
                throw new TechnicalManagementException("An error occurs while trying to update tag " + tagEntity.getName(), ex);
            }
        });
        return savedTags;
    }

    @Override
    public void delete(ExecutionContext executionContext, String tagId, String referenceId, io.gravitee.rest.api.model.TagReferenceType referenceType) {
        try {
            Optional tagOptional = this.tagRepository.findByIdAndReference(tagId, referenceId, this.repoTagReferenceType(referenceType));
            if (tagOptional.isPresent()) {
                this.tagRepository.delete((Object)tagId);
                this.apiTagService.deleteTagFromAPIs(executionContext, tagId);
                this.auditService.createOrganizationAuditLog(executionContext, executionContext.getOrganizationId(), Collections.singletonMap(Audit.AuditProperties.TAG, tagId), (Audit.AuditEvent)Tag.AuditEvent.TAG_DELETED, new Date(), null, tagOptional.get());
            }
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to delete tag {}", (Object)tagId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete tag " + tagId, ex);
        }
    }

    @Override
    public Set<String> findByUser(String user, String referenceId, io.gravitee.rest.api.model.TagReferenceType referenceType) {
        List<TagEntity> tags = this.findByReference(referenceId, referenceType);
        if (this.isEnvironmentAdmin()) {
            return tags.stream().map(TagEntity::getId).collect(Collectors.toSet());
        }
        Set restrictedTags = tags.stream().filter(tag -> tag.getRestrictedGroups() != null && !tag.getRestrictedGroups().isEmpty()).map(TagEntity::getId).collect(Collectors.toSet());
        Set groups = this.groupService.findByUser(user).stream().map(GroupEntity::getId).collect(Collectors.toSet());
        return tags.stream().filter(tag -> !restrictedTags.contains(tag.getId()) || tag.getRestrictedGroups() != null && this.anyMatch(tag.getRestrictedGroups(), groups)).map(TagEntity::getId).collect(Collectors.toSet());
    }

    private boolean anyMatch(List<String> restrictedGroups, Set<String> groups) {
        for (String restrictedGroup : restrictedGroups) {
            if (!groups.contains(restrictedGroup)) continue;
            return true;
        }
        return false;
    }

    private Tag convert(NewTagEntity tagEntity, String referenceId, io.gravitee.rest.api.model.TagReferenceType referenceType) {
        Tag tag = new Tag();
        tag.setId(IdGenerator.generate((String)tagEntity.getName()));
        tag.setName(tagEntity.getName());
        tag.setDescription(tagEntity.getDescription());
        tag.setRestrictedGroups(tagEntity.getRestrictedGroups());
        tag.setReferenceId(referenceId);
        tag.setReferenceType(this.repoTagReferenceType(referenceType));
        return tag;
    }

    private Tag convert(UpdateTagEntity tagEntity) {
        Tag tag = new Tag();
        tag.setId(tagEntity.getId());
        tag.setName(tagEntity.getName());
        tag.setDescription(tagEntity.getDescription());
        tag.setRestrictedGroups(tagEntity.getRestrictedGroups());
        return tag;
    }

    private TagEntity convert(Tag tag) {
        TagEntity tagEntity = new TagEntity();
        tagEntity.setId(tag.getId());
        tagEntity.setName(tag.getName());
        tagEntity.setDescription(tag.getDescription());
        tagEntity.setRestrictedGroups(tag.getRestrictedGroups());
        return tagEntity;
    }

    private TagReferenceType repoTagReferenceType(io.gravitee.rest.api.model.TagReferenceType referenceType) {
        return TagReferenceType.valueOf((String)referenceType.name());
    }
}

