/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.definition.model.VirtualHost;
import io.gravitee.definition.model.v4.listener.http.Path;
import io.gravitee.rest.api.service.VirtualHostService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.ApiContextPathAlreadyExistsException;
import io.gravitee.rest.api.service.exceptions.InvalidVirtualHostException;
import io.gravitee.rest.api.service.impl.TransactionalService;
import io.gravitee.rest.api.service.v4.exception.InvalidHostException;
import io.gravitee.rest.api.service.v4.exception.PathAlreadyExistsException;
import io.gravitee.rest.api.service.v4.validation.PathValidationService;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class VirtualHostServiceImpl
extends TransactionalService
implements VirtualHostService {
    private final PathValidationService pathValidationService;

    public VirtualHostServiceImpl(PathValidationService pathValidationService) {
        this.pathValidationService = pathValidationService;
    }

    @Override
    public Collection<VirtualHost> sanitizeAndValidate(ExecutionContext executionContext, Collection<VirtualHost> virtualHosts, String apiId) {
        List<Path> paths = virtualHosts.stream().map(virtualHost -> new Path(virtualHost.getHost(), virtualHost.getPath())).collect(Collectors.toList());
        try {
            return this.pathValidationService.validateAndSanitizePaths(executionContext, apiId, paths).stream().map(path -> new VirtualHost(path.getHost(), path.getPath())).collect(Collectors.toList());
        }
        catch (PathAlreadyExistsException e) {
            throw new ApiContextPathAlreadyExistsException(e.getPathValue());
        }
        catch (InvalidHostException e) {
            throw new InvalidVirtualHostException(e.getHost(), e.getRestrictions());
        }
    }

    @Override
    public VirtualHost sanitize(VirtualHost virtualHost) {
        String path = virtualHost.getPath();
        String sanitizePath = this.pathValidationService.sanitizePath(path);
        return new VirtualHost(virtualHost.getHost(), sanitizePath, virtualHost.isOverrideEntrypoint());
    }
}

