/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl;

import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.definition.model.v4.ConnectorMode;
import io.gravitee.gateway.jupiter.api.connector.AbstractConnectorFactory;
import io.gravitee.plugin.core.api.ConfigurablePluginManager;
import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.plugin.entrypoint.EntrypointConnectorPlugin;
import io.gravitee.plugin.entrypoint.EntrypointConnectorPluginManager;
import io.gravitee.rest.api.model.platform.plugin.PlatformPluginEntity;
import io.gravitee.rest.api.model.v4.entrypoint.EntrypointPluginEntity;
import io.gravitee.rest.api.service.JsonSchemaService;
import io.gravitee.rest.api.service.impl.AbstractPluginService;
import io.gravitee.rest.api.service.v4.EntrypointPluginService;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component(value="EntrypointPluginServiceImplV4")
public class EntrypointPluginServiceImpl
extends AbstractPluginService<EntrypointConnectorPlugin<?>, EntrypointPluginEntity>
implements EntrypointPluginService {
    public EntrypointPluginServiceImpl(JsonSchemaService jsonSchemaService, ConfigurablePluginManager<EntrypointConnectorPlugin<?>> pluginManager) {
        super(jsonSchemaService, pluginManager);
    }

    @Override
    public Set<EntrypointPluginEntity> findAll() {
        return super.list().stream().map(this::convert).collect(Collectors.toSet());
    }

    @Override
    public EntrypointPluginEntity findById(String entrypointPluginId) {
        EntrypointConnectorPlugin resourceDefinition = (EntrypointConnectorPlugin)super.get(entrypointPluginId);
        return this.convert((Plugin)resourceDefinition);
    }

    protected EntrypointPluginEntity convert(Plugin plugin) {
        EntrypointPluginEntity entity = new EntrypointPluginEntity();
        entity.setId(plugin.id());
        entity.setDescription(plugin.manifest().description());
        entity.setName(plugin.manifest().name());
        entity.setVersion(plugin.manifest().version());
        AbstractConnectorFactory connectorFactory = ((EntrypointConnectorPluginManager)this.pluginManager).getFactoryById(plugin.id());
        entity.setSupportedApiType(ApiType.fromLabel((String)connectorFactory.supportedApi().getLabel()));
        entity.setSupportedModes(connectorFactory.supportedModes().stream().map(connectorMode -> ConnectorMode.fromLabel((String)connectorMode.getLabel())).collect(Collectors.toSet()));
        return entity;
    }

    @Override
    public Set<EntrypointPluginEntity> findBySupportedApi(ApiType apiType) {
        return super.list().stream().filter(plugin -> ((EntrypointConnectorPluginManager)this.pluginManager).getFactoryById(plugin.id()).supportedApi().equals((Object)io.gravitee.gateway.jupiter.api.ApiType.fromLabel((String)apiType.getLabel()))).map(this::convert).collect(Collectors.toSet());
    }

    @Override
    public Set<EntrypointPluginEntity> findByConnectorMode(ConnectorMode connectorMode) {
        return super.list().stream().filter(plugin -> ((EntrypointConnectorPluginManager)this.pluginManager).getFactoryById(plugin.id()).supportedModes().contains(io.gravitee.gateway.jupiter.api.ConnectorMode.fromLabel((String)connectorMode.getLabel()))).map(this::convert).collect(Collectors.toSet());
    }

    @Override
    public String validateEntrypointConfiguration(String entrypointPluginId, String configuration) {
        EntrypointPluginEntity entrypointPluginEntity = this.findById(entrypointPluginId);
        return this.validateConfiguration((PlatformPluginEntity)entrypointPluginEntity, configuration);
    }
}

