/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl.validation;

import io.gravitee.definition.model.Logging;
import io.gravitee.definition.model.LoggingMode;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.TimeBoundedCharSequence;
import io.gravitee.rest.api.service.impl.TransactionalService;
import io.gravitee.rest.api.service.v4.validation.LoggingValidationService;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LoggingValidationServiceImpl
extends TransactionalService
implements LoggingValidationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoggingValidationServiceImpl.class);
    private static final Pattern LOGGING_MAX_DURATION_PATTERN = Pattern.compile("(?<before>.*)\\#request.timestamp\\s*\\<\\=?\\s*(?<timestamp>\\d*)l(?<after>.*)");
    private static final String LOGGING_MAX_DURATION_CONDITION = "#request.timestamp <= %dl";
    private static final String LOGGING_DELIMITER_BASE = "\\s+(\\|\\||\\&\\&)\\s+";
    private static final Duration REGEX_TIMEOUT = Duration.ofSeconds(2L);
    private final ParameterService parameterService;

    public LoggingValidationServiceImpl(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Override
    public Logging validateAndSanitize(ExecutionContext executionContext, Logging logging) {
        Optional optionalMaxDuration;
        if (logging != null && !LoggingMode.NONE.equals((Object)logging.getMode()) && (optionalMaxDuration = this.parameterService.findAll(executionContext, Key.LOGGING_DEFAULT_MAX_DURATION, Long::valueOf, ParameterReferenceType.ORGANIZATION).stream().findFirst()).isPresent() && (Long)optionalMaxDuration.get() > 0L) {
            long maxEndDate = Instant.now().toEpochMilli() + (Long)optionalMaxDuration.get();
            if (logging.getCondition() == null || logging.getCondition().isEmpty()) {
                logging.setCondition("{" + String.format(LOGGING_MAX_DURATION_CONDITION, maxEndDate) + "}");
            } else {
                String conditionWithoutBraces = logging.getCondition().trim().replaceAll("\\{", "").replaceAll("\\}", "");
                Matcher matcher = LOGGING_MAX_DURATION_PATTERN.matcher(new TimeBoundedCharSequence(conditionWithoutBraces, REGEX_TIMEOUT));
                if (matcher.matches()) {
                    String currentDurationAsStr = matcher.group("timestamp");
                    String before = this.formatExpression(matcher, "before");
                    String after = this.formatExpression(matcher, "after");
                    try {
                        long currentDuration = Long.parseLong(currentDurationAsStr);
                        if (currentDuration > maxEndDate || !before.isEmpty() || !after.isEmpty()) {
                            logging.setCondition("{" + before + String.format(LOGGING_MAX_DURATION_CONDITION, maxEndDate) + after + "}");
                        }
                    }
                    catch (NumberFormatException nfe) {
                        log.error("Wrong format of the logging condition. Add the default one", (Throwable)nfe);
                        logging.setCondition("{" + before + String.format(LOGGING_MAX_DURATION_CONDITION, maxEndDate) + after + "}");
                    }
                } else {
                    logging.setCondition("{" + String.format(LOGGING_MAX_DURATION_CONDITION, maxEndDate) + " && (" + conditionWithoutBraces + ")}");
                }
            }
        }
        return logging;
    }

    private String formatExpression(Matcher matcher, String group) {
        Object expression;
        String matchedExpression = Optional.ofNullable(matcher.group(group)).orElse("");
        boolean expressionBlank = "".equals(matchedExpression);
        boolean after = "after".equals(group);
        if (after) {
            if (matchedExpression.startsWith(" && (") && matchedExpression.endsWith(")")) {
                matchedExpression = matchedExpression.substring(5, matchedExpression.length() - 1);
            }
            expression = expressionBlank ? "" : " && (" + matchedExpression + ")";
            expression = ((String)expression).replaceAll("\\(\\s+(\\|\\||\\&\\&)\\s+", "\\(");
        } else {
            if (matchedExpression.startsWith("(") && matchedExpression.endsWith(") && ")) {
                matchedExpression = matchedExpression.substring(1, matchedExpression.length() - 5);
            }
            expression = expressionBlank ? "" : "(" + matchedExpression + ") && ";
            expression = ((String)expression).replaceAll("\\s+(\\|\\||\\&\\&)\\s+\\)", "\\)");
        }
        return expression;
    }
}

