/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import io.gravitee.definition.model.ExecutionMode;
import io.gravitee.rest.api.service.JupiterModeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class JupiterModeServiceImpl
implements JupiterModeService {
    private final boolean enabled;
    private final JupiterModeService.DefaultMode defaultMode;

    @Autowired
    public JupiterModeServiceImpl(@Value(value="${api.jupiterMode.enabled:false}") boolean enabled, @Value(value="${api.jupiterMode.default:never}") String defaultMode) {
        this.enabled = enabled;
        this.defaultMode = JupiterModeService.DefaultMode.fromLabel(defaultMode);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public JupiterModeService.DefaultMode defaultMode() {
        return this.defaultMode;
    }

    @Override
    public ExecutionMode getExecutionModeFor(JsonNode apiDefinition) {
        if (this.enabled && (this.defaultMode == JupiterModeService.DefaultMode.ALWAYS || apiDefinition == null && this.defaultMode == JupiterModeService.DefaultMode.CREATION_ONLY)) {
            return ExecutionMode.JUPITER;
        }
        return ExecutionMode.V3;
    }
}

