/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service;

import io.gravitee.common.data.domain.Page;
import io.gravitee.rest.api.model.ImportPageEntity;
import io.gravitee.rest.api.model.ImportSwaggerDescriptorEntity;
import io.gravitee.rest.api.model.NewPageEntity;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.SystemFolderType;
import io.gravitee.rest.api.model.UpdatePageEntity;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.documentation.PageQuery;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface PageService {
    public Page<PageEntity> findAll(Pageable var1);

    public PageEntity findById(String var1);

    public PageEntity findById(String var1, String var2);

    default public List<PageEntity> findByApi(String environmentId, String apiId) {
        return this.search(environmentId, new PageQuery.Builder().api(apiId).build(), false);
    }

    public List<PageEntity> search(String var1, PageQuery var2);

    public List<PageEntity> search(String var1, PageQuery var2, boolean var3);

    public List<PageEntity> search(String var1, PageQuery var2, String var3);

    public void transformSwagger(ExecutionContext var1, PageEntity var2);

    public void transformSwagger(ExecutionContext var1, PageEntity var2, GenericApiEntity var3);

    public PageEntity createPage(ExecutionContext var1, String var2, NewPageEntity var3);

    public PageEntity createPage(ExecutionContext var1, NewPageEntity var2);

    public PageEntity update(ExecutionContext var1, String var2, UpdatePageEntity var3);

    public PageEntity update(ExecutionContext var1, String var2, UpdatePageEntity var3, boolean var4);

    public void delete(ExecutionContext var1, String var2);

    public void deleteAllByApi(ExecutionContext var1, String var2);

    public int findMaxApiPageOrderByApi(String var1);

    public int findMaxPortalPageOrder(String var1);

    public void fetchAll(ExecutionContext var1, PageQuery var2, String var3);

    public long execAutoFetch(ExecutionContext var1);

    public PageEntity fetch(ExecutionContext var1, String var2, String var3);

    public List<PageEntity> importFiles(ExecutionContext var1, ImportPageEntity var2);

    public List<PageEntity> importFiles(ExecutionContext var1, String var2, ImportPageEntity var3);

    public void transformWithTemplate(ExecutionContext var1, PageEntity var2, String var3);

    public PageEntity create(ExecutionContext var1, String var2, PageEntity var3);

    public List<String> validateSafeContent(ExecutionContext var1, PageEntity var2, String var3);

    public Map<SystemFolderType, String> initialize(ExecutionContext var1);

    public PageEntity createAsideFolder(ExecutionContext var1, String var2);

    public PageEntity createSystemFolder(ExecutionContext var1, String var2, SystemFolderType var3, int var4);

    public PageEntity createWithDefinition(ExecutionContext var1, String var2, String var3);

    public void createOrUpdatePages(ExecutionContext var1, List<PageEntity> var2, String var3);

    public void createOrUpdateSwaggerPage(ExecutionContext var1, String var2, ImportSwaggerDescriptorEntity var3, boolean var4);

    public Map<String, String> duplicatePages(ExecutionContext var1, List<PageEntity> var2, String var3);

    public boolean isPageUsedAsGeneralConditions(ExecutionContext var1, PageEntity var2, String var3);

    public boolean shouldHaveRevision(String var1);

    public Optional<PageEntity> attachMedia(String var1, String var2, String var3);
}

