/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade;

import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.CommandRepository;
import io.gravitee.repository.management.api.EnvironmentRepository;
import io.gravitee.repository.management.api.search.CommandCriteria;
import io.gravitee.repository.management.model.Command;
import io.gravitee.repository.management.model.Environment;
import io.gravitee.rest.api.service.impl.upgrade.DefaultApiHeaderUpgrader;
import io.gravitee.rest.api.service.impl.upgrade.OneShotUpgrader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class CommandOrganizationUpgrader
extends OneShotUpgrader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultApiHeaderUpgrader.class);
    private final EnvironmentRepository environmentRepository;
    private final CommandRepository commandRepository;

    @Autowired
    public CommandOrganizationUpgrader(@Lazy EnvironmentRepository environmentRepository, @Lazy CommandRepository commandRepository) {
        super("COMMAND_ORGANIZATION_UPGRADER");
        this.environmentRepository = environmentRepository;
        this.commandRepository = commandRepository;
    }

    @Override
    public int getOrder() {
        return 500;
    }

    @Override
    protected void processOneShotUpgrade() throws Exception {
        this.environmentRepository.findAll().forEach(this::updateCommands);
    }

    private void updateCommands(Environment environment) {
        CommandCriteria criteria = new CommandCriteria.Builder().environmentId(environment.getId()).build();
        this.commandRepository.search(criteria).forEach(command -> this.updateOrganizationId((Command)command, environment.getOrganizationId()));
    }

    private void updateOrganizationId(Command command, String organizationId) {
        try {
            command.setOrganizationId(organizationId);
            this.commandRepository.update((Object)command);
        }
        catch (TechnicalException e) {
            LOGGER.error("An error as occurred while trying to update command organization", (Throwable)e);
        }
    }
}

