/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.exceptions;

import io.gravitee.rest.api.service.exceptions.AbstractNotFoundException;
import java.util.HashMap;
import java.util.Map;

public class ApplicationMetadataNotFoundException
extends AbstractNotFoundException {
    private final String applicationId;
    private final String metadataId;

    public ApplicationMetadataNotFoundException(String applicationId, String metadataId) {
        this.applicationId = applicationId;
        this.metadataId = metadataId;
    }

    @Override
    public String getMessage() {
        return "The metadata [" + this.metadataId + "] can not be found on the application [" + this.applicationId + "].";
    }

    @Override
    public String getTechnicalCode() {
        return "application.metadata.notFound";
    }

    @Override
    public Map<String, String> getParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("application", this.applicationId);
        parameters.put("metadata", this.metadataId);
        return parameters;
    }
}

