/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.swagger.converter.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.common.http.HttpMethod;
import io.gravitee.common.utils.IdGenerator;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.Endpoint;
import io.gravitee.definition.model.EndpointGroup;
import io.gravitee.definition.model.Policy;
import io.gravitee.definition.model.Proxy;
import io.gravitee.definition.model.Rule;
import io.gravitee.definition.model.VirtualHost;
import io.gravitee.rest.api.model.ApiMetadataEntity;
import io.gravitee.rest.api.model.GroupEntity;
import io.gravitee.rest.api.model.ImportSwaggerDescriptorEntity;
import io.gravitee.rest.api.model.MetadataFormat;
import io.gravitee.rest.api.model.PropertiesEntity;
import io.gravitee.rest.api.model.PropertyEntity;
import io.gravitee.rest.api.model.TagEntity;
import io.gravitee.rest.api.model.TagReferenceType;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.api.SwaggerApiEntity;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.TagService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.impl.swagger.converter.api.SwaggerToApiConverter;
import io.gravitee.rest.api.service.impl.swagger.policy.PolicyOperationVisitorManager;
import io.gravitee.rest.api.service.impl.swagger.visitor.v3.OAIDescriptorVisitor;
import io.gravitee.rest.api.service.impl.swagger.visitor.v3.OAIOperationVisitor;
import io.gravitee.rest.api.service.swagger.OAIDescriptor;
import io.gravitee.rest.api.service.swagger.converter.extension.XGraviteeIODefinition;
import io.gravitee.rest.api.service.validator.JsonHelper;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.servers.ServerVariable;
import io.swagger.v3.oas.models.servers.ServerVariables;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class OAIToAPIConverter
implements SwaggerToApiConverter<OAIDescriptor>,
OAIDescriptorVisitor<SwaggerApiEntity> {
    public static final String X_GRAVITEEIO_DEFINITION_VENDOR_EXTENSION = "x-graviteeio-definition";
    private static final String PICTURE_REGEX = "^data:image/[\\w]+;base64,.*$";
    protected static final Pattern PATH_PARAMS_PATTERN = Pattern.compile("\\{(.[^/\\}]*)\\}");
    private Collection<? extends OAIOperationVisitor> visitors;
    protected final ImportSwaggerDescriptorEntity swaggerDescriptor;
    private final PolicyOperationVisitorManager policyOperationVisitorManager;
    private final GroupService groupService;
    private final TagService tagService;

    public OAIToAPIConverter(ImportSwaggerDescriptorEntity swaggerDescriptor, PolicyOperationVisitorManager policyOperationVisitorManager, GroupService groupService, TagService tagService) {
        this.swaggerDescriptor = swaggerDescriptor;
        this.policyOperationVisitorManager = policyOperationVisitorManager;
        this.groupService = groupService;
        this.tagService = tagService;
    }

    protected Collection<? extends OAIOperationVisitor> getVisitors() {
        if (this.visitors == null) {
            this.visitors = new ArrayList<OAIOperationVisitor>();
            if (this.swaggerDescriptor.isWithPolicyPaths()) {
                this.visitors = this.policyOperationVisitorManager.getPolicyVisitors().stream().filter(operationVisitor -> this.swaggerDescriptor.getWithPolicies() != null && this.swaggerDescriptor.getWithPolicies().contains(operationVisitor.getId())).map(operationVisitor -> this.policyOperationVisitorManager.getOAIOperationVisitor(operationVisitor.getId())).collect(Collectors.toList());
            }
        }
        return this.visitors;
    }

    @Override
    public SwaggerApiEntity convert(ExecutionContext executionContext, OAIDescriptor descriptor) {
        if (descriptor == null || descriptor.getSpecification() == null) {
            return null;
        }
        return this.visit(executionContext, descriptor.getSpecification());
    }

    @Override
    public SwaggerApiEntity visit(ExecutionContext executionContext, OpenAPI oai) {
        SwaggerApiEntity apiEntity = new SwaggerApiEntity();
        apiEntity.setName(oai.getInfo().getTitle());
        apiEntity.setDescription((String)(oai.getInfo().getDescription() == null ? "Description of " + apiEntity.getName() : oai.getInfo().getDescription()));
        apiEntity.setVersion(oai.getInfo().getVersion());
        this.fill(apiEntity, oai);
        XGraviteeIODefinition xGraviteeIODefinition = null;
        if (oai.getExtensions() != null && oai.getExtensions().get(X_GRAVITEEIO_DEFINITION_VENDOR_EXTENSION) != null) {
            xGraviteeIODefinition = (XGraviteeIODefinition)new ObjectMapper().convertValue(oai.getExtensions().get(X_GRAVITEEIO_DEFINITION_VENDOR_EXTENSION), XGraviteeIODefinition.class);
        }
        Proxy proxy = new Proxy();
        String defaultEndpoint = null;
        if (!oai.getServers().isEmpty()) {
            List<String> evaluatedServerUrl = this.mapServersToEndpoint(oai.getServers());
            EndpointGroup defaultGroup = new EndpointGroup();
            defaultGroup.setName("default-group");
            if (evaluatedServerUrl == null) {
                defaultGroup.setEndpoints(Collections.singleton(new Endpoint("default", defaultEndpoint)));
            } else if (evaluatedServerUrl.size() == 1) {
                defaultEndpoint = evaluatedServerUrl.get(0);
                defaultGroup.setEndpoints(Collections.singleton(new Endpoint("default", defaultEndpoint)));
            } else {
                defaultEndpoint = evaluatedServerUrl.get(0);
                defaultGroup.setEndpoints(new HashSet());
                for (int i = 0; i < evaluatedServerUrl.size(); ++i) {
                    defaultGroup.getEndpoints().add(new Endpoint("server" + (i + 1), evaluatedServerUrl.get(i)));
                }
            }
            proxy.setGroups(Collections.singleton(defaultGroup));
            apiEntity.setProxy(proxy);
        }
        if (xGraviteeIODefinition != null && xGraviteeIODefinition.getVirtualHosts() != null) {
            proxy.setVirtualHosts(xGraviteeIODefinition.getVirtualHosts().stream().map(vHost -> new VirtualHost(vHost.getHost(), vHost.getPath(), vHost.getOverrideEntrypoint() != null ? vHost.getOverrideEntrypoint() : false)).collect(Collectors.toList()));
        } else {
            String contextPath = null;
            if (defaultEndpoint != null) {
                contextPath = URI.create(defaultEndpoint).getPath();
            }
            if (contextPath == null || contextPath.isEmpty() || contextPath.equals("/")) {
                contextPath = apiEntity.getName().replaceAll("\\s+", "").toLowerCase();
            }
            proxy.setVirtualHosts(Collections.singletonList(new VirtualHost(contextPath)));
        }
        apiEntity.setProxy(proxy);
        if (xGraviteeIODefinition != null) {
            if (xGraviteeIODefinition.getCategories() != null && !xGraviteeIODefinition.getCategories().isEmpty()) {
                apiEntity.setCategories(new HashSet<String>(xGraviteeIODefinition.getCategories()));
            }
            if (xGraviteeIODefinition.getGroups() != null && !xGraviteeIODefinition.getGroups().isEmpty()) {
                Set groupIdsToImport = xGraviteeIODefinition.getGroups().stream().flatMap(group -> this.groupService.findByName(executionContext.getEnvironmentId(), (String)group).stream()).map(GroupEntity::getId).collect(Collectors.toSet());
                apiEntity.setGroups(groupIdsToImport);
            }
            if (xGraviteeIODefinition.getLabels() != null && !xGraviteeIODefinition.getLabels().isEmpty()) {
                apiEntity.setLabels(xGraviteeIODefinition.getLabels());
            }
            if (xGraviteeIODefinition.getMetadata() != null && !xGraviteeIODefinition.getMetadata().isEmpty()) {
                List apiMetadataEntities = xGraviteeIODefinition.getMetadata().stream().map(metadata -> {
                    ApiMetadataEntity apiMetadata = new ApiMetadataEntity();
                    apiMetadata.setKey(IdGenerator.generate((String)metadata.getName()));
                    apiMetadata.setName(metadata.getName());
                    apiMetadata.setValue(metadata.getValue());
                    apiMetadata.setFormat(metadata.getFormat() != null ? MetadataFormat.valueOf((String)metadata.getFormat().name()) : MetadataFormat.STRING);
                    return apiMetadata;
                }).collect(Collectors.toList());
                apiEntity.setMetadata(apiMetadataEntities);
            }
            if (xGraviteeIODefinition.getPicture() != null && !StringUtils.isEmpty((CharSequence)xGraviteeIODefinition.getPicture()) && xGraviteeIODefinition.getPicture().matches(PICTURE_REGEX)) {
                apiEntity.setPicture(xGraviteeIODefinition.getPicture());
            }
            if (xGraviteeIODefinition.getProperties() != null && !xGraviteeIODefinition.getProperties().isEmpty()) {
                PropertiesEntity properties = new PropertiesEntity();
                properties.setProperties(xGraviteeIODefinition.getProperties().stream().map(prop -> new PropertyEntity(prop.getKey(), prop.getValue())).collect(Collectors.toList()));
                apiEntity.setProperties(properties);
            }
            if (xGraviteeIODefinition.getTags() != null && !xGraviteeIODefinition.getTags().isEmpty()) {
                Map<String, String> tagMap = this.tagService.findByReference(executionContext.getOrganizationId(), TagReferenceType.ORGANIZATION).stream().collect(Collectors.toMap(TagEntity::getId, TagEntity::getName));
                Set tagIdToAdd = xGraviteeIODefinition.getTags().stream().map(tag -> this.findTagIdByName(tagMap, (String)tag)).filter(Objects::nonNull).collect(Collectors.toSet());
                if (tagIdToAdd != null && !tagIdToAdd.isEmpty()) {
                    apiEntity.setTags(tagIdToAdd);
                }
            }
            if (xGraviteeIODefinition.getVisibility() != null) {
                apiEntity.setVisibility(Visibility.valueOf((String)xGraviteeIODefinition.getVisibility().name()));
            }
        }
        return apiEntity;
    }

    protected SwaggerApiEntity fill(SwaggerApiEntity apiEntity, OpenAPI oai) {
        apiEntity.setGraviteeDefinitionVersion(DefinitionVersion.V1.getLabel());
        HashMap paths = new HashMap();
        HashSet<String> pathMappings = new HashSet<String>();
        if (this.swaggerDescriptor.isWithPolicyPaths() || this.swaggerDescriptor.isWithPathMapping()) {
            oai.getPaths().entrySet().forEach(entry -> {
                String path = PATH_PARAMS_PATTERN.matcher((CharSequence)entry.getKey()).replaceAll(":$1");
                if (this.swaggerDescriptor.isWithPathMapping()) {
                    pathMappings.add(path);
                }
                if (this.swaggerDescriptor.isWithPolicyPaths()) {
                    Map operations = ((PathItem)entry.getValue()).readOperationsMap();
                    ArrayList rules = new ArrayList();
                    operations.forEach((httpMethod, operation) -> this.getVisitors().forEach(oaiOperationVisitor -> {
                        Optional policy = (Optional)oaiOperationVisitor.visit(oai, operation);
                        if (policy.isPresent()) {
                            Rule rule = new Rule();
                            rule.setEnabled(true);
                            rule.setDescription(operation.getSummary() == null ? (operation.getOperationId() == null ? operation.getDescription() : operation.getOperationId()) : operation.getSummary());
                            rule.setMethods(Collections.singleton(HttpMethod.valueOf((String)httpMethod.name())));
                            Policy defPolicy = new Policy();
                            defPolicy.setName(((io.gravitee.policy.api.swagger.Policy)policy.get()).getName());
                            defPolicy.setConfiguration(JsonHelper.clearNullValues(((io.gravitee.policy.api.swagger.Policy)policy.get()).getConfiguration()));
                            rule.setPolicy(defPolicy);
                            rules.add(rule);
                        }
                    }));
                    paths.put(path, rules);
                }
            });
        }
        String defaultDeclaredPath = "/";
        if (paths.isEmpty()) {
            paths.put("/", new ArrayList());
        }
        if (pathMappings.isEmpty()) {
            pathMappings.add("/");
        }
        apiEntity.setPaths(paths);
        apiEntity.setPathMappings(pathMappings);
        return apiEntity;
    }

    private String findTagIdByName(Map<String, String> tagMap, String tag) {
        for (Map.Entry<String, String> entry : tagMap.entrySet()) {
            if (!entry.getValue().equals(tag)) continue;
            return entry.getKey();
        }
        return null;
    }

    private List<String> mapServersToEndpoint(List<Server> servers) {
        ArrayList<String> endpoints = new ArrayList<String>();
        for (Server server : servers) {
            ServerVariables serverVariables = server.getVariables();
            String serverUrl = server.getUrl();
            if (CollectionUtils.isEmpty((Map)serverVariables)) {
                endpoints.add(serverUrl);
                continue;
            }
            List<String> evaluatedUrls = Collections.singletonList(serverUrl);
            for (Map.Entry serverVar : serverVariables.entrySet()) {
                evaluatedUrls = this.evaluateServerUrlsForOneVar((String)serverVar.getKey(), (ServerVariable)serverVar.getValue(), evaluatedUrls);
            }
            endpoints.addAll(evaluatedUrls);
        }
        return endpoints;
    }

    private List<String> evaluateServerUrlsForOneVar(String varName, ServerVariable serverVar, List<String> templateUrls) {
        ArrayList<String> evaluatedUrls = new ArrayList<String>();
        for (String templateUrl : templateUrls) {
            Matcher matcher = Pattern.compile("\\{" + varName + "\\}").matcher(templateUrl);
            if (!matcher.find()) continue;
            if (CollectionUtils.isEmpty((Collection)serverVar.getEnum()) && serverVar.getDefault() != null) {
                evaluatedUrls.add(templateUrl.replace(matcher.group(0), serverVar.getDefault()));
                continue;
            }
            for (String enumValue : serverVar.getEnum()) {
                evaluatedUrls.add(templateUrl.replace(matcher.group(0), enumValue));
            }
        }
        return evaluatedUrls;
    }
}

