/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.common;

import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;

public interface UuidString {
    public static String generateRandom() {
        return io.gravitee.common.utils.UUID.toString((UUID)io.gravitee.common.utils.UUID.random());
    }

    public static String generateForEnvironment(String environmentId, String ... fields) {
        if (Stream.of(fields).anyMatch(Objects::isNull)) {
            return UuidString.generateRandom();
        }
        StringBuilder b = new StringBuilder();
        b.append(environmentId);
        for (String f : fields) {
            b.append(f);
        }
        String baseStringForUUID = b.toString();
        return io.gravitee.common.utils.UUID.toString((UUID)UUID.nameUUIDFromBytes(baseStringForUUID.getBytes()));
    }
}

