/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.sanitizer;

import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.owasp.html.AttributePolicy;
import org.owasp.html.CssSchema;
import org.owasp.html.HtmlChangeListener;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.PolicyFactory;
import org.owasp.html.Sanitizers;

public final class HtmlSanitizer {
    private static final Parser mdParser = Parser.builder((DataHolder)new MutableDataSet()).build();
    private static final HtmlRenderer htmlRenderer = HtmlRenderer.builder((DataHolder)new MutableDataSet().set(HtmlRenderer.SUPPRESSED_LINKS, (Object)"")).build();
    private static final AttributePolicy INTEGER = new AttributePolicy(){

        public String apply(String elementName, String attributeName, String value) {
            int n = value.length();
            if (n == 0) {
                return null;
            }
            for (int i = 0; i < n; ++i) {
                char ch = value.charAt(i);
                if (ch == '.') {
                    if (i == 0) {
                        return null;
                    }
                    return value.substring(0, i);
                }
                if ('0' <= ch && ch <= '9') continue;
                return null;
            }
            return value;
        }
    };
    private static final PolicyFactory HTML_IMAGES_SANITIZER = new HtmlPolicyBuilder().allowUrlProtocols(new String[]{"data", "http", "https"}).allowElements(new String[]{"img"}).allowAttributes(new String[]{"alt", "title", "src"}).onElements(new String[]{"img"}).allowAttributes(new String[]{"border", "height", "width"}).matching(INTEGER).onElements(new String[]{"img"}).toFactory();
    private static final PolicyFactory HTML_CSS_SANITIZER = new HtmlPolicyBuilder().allowStyling(CssSchema.union((CssSchema[])new CssSchema[]{CssSchema.DEFAULT, CssSchema.withProperties(Collections.singleton("float"))})).toFactory();
    private static final PolicyFactory factory = Sanitizers.BLOCKS.and(Sanitizers.FORMATTING).and(new HtmlPolicyBuilder().allowStandardUrlProtocols().allowElements(new String[]{"a"}).allowAttributes(new String[]{"href", "title"}).onElements(new String[]{"a"}).toFactory()).and(HTML_CSS_SANITIZER).and(Sanitizers.TABLES).and(new HtmlPolicyBuilder().allowElements(new String[]{"pre", "hr"}).toFactory()).and(HTML_IMAGES_SANITIZER).and(new HtmlPolicyBuilder().allowElements(new String[]{"code"}).allowAttributes(new String[]{"class"}).globally().toFactory());

    private HtmlSanitizer() {
    }

    public static String sanitize(String content) {
        if (content == null || content.isEmpty()) {
            return content;
        }
        return factory.sanitize(content);
    }

    public static <CTX> String sanitize(String content, HtmlChangeListener<CTX> listener, CTX context) {
        if (content == null || content.isEmpty()) {
            return content;
        }
        return factory.sanitize(content, listener, context);
    }

    public static SanitizeInfos isSafe(String content) {
        if (content == null || content.isEmpty()) {
            return new SanitizeInfos(true);
        }
        String toSanitize = htmlRenderer.render((Node)mdParser.parse(content));
        ArrayList sanitizedChanges = new ArrayList();
        HtmlChangeListener<List<String>> listener = new HtmlChangeListener<List<String>>(){

            public void discardedTag(@Nullable List<String> context, String elementName) {
                context.add("Tag not allowed: " + elementName);
            }

            public void discardedAttributes(@Nullable List<String> context, String tagName, String ... attributeNames) {
                context.add("Attribute not allowed: [" + tagName + "]" + Arrays.toString(attributeNames));
            }
        };
        HtmlSanitizer.sanitize(toSanitize, listener, sanitizedChanges);
        return new SanitizeInfos(sanitizedChanges.isEmpty(), ((Object)sanitizedChanges).toString());
    }

    public static class SanitizeInfos {
        boolean safe;
        String rejectedMessage;

        public SanitizeInfos(boolean safe) {
            this.safe = safe;
        }

        public SanitizeInfos(boolean safe, String rejectedMessage) {
            this.safe = safe;
            this.rejectedMessage = rejectedMessage;
        }

        public boolean isSafe() {
            return this.safe;
        }

        public String getRejectedMessage() {
            return this.rejectedMessage;
        }
    }
}

