/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.ApplicationRepository;
import io.gravitee.repository.management.api.PlanRepository;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.api.search.UserCriteria;
import io.gravitee.repository.management.model.Plan;
import io.gravitee.repository.management.model.UserStatus;
import io.gravitee.repository.management.model.Workflow;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.model.MembershipEntity;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.SubscriptionEntity;
import io.gravitee.rest.api.model.SubscriptionStatus;
import io.gravitee.rest.api.model.TaskEntity;
import io.gravitee.rest.api.model.TaskType;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.WorkflowReferenceType;
import io.gravitee.rest.api.model.WorkflowState;
import io.gravitee.rest.api.model.WorkflowType;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.PageableImpl;
import io.gravitee.rest.api.model.pagedresult.Metadata;
import io.gravitee.rest.api.model.permissions.ApiPermission;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.subscription.SubscriptionQuery;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.SubscriptionService;
import io.gravitee.rest.api.service.TaskService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.WorkflowService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.exceptions.UnauthorizedAccessException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.promotion.PromotionTasksService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class TaskServiceImpl
extends AbstractService
implements TaskService {
    private final Logger LOGGER = LoggerFactory.getLogger(TaskServiceImpl.class);
    private static final int NUMBER_OF_PENDING_USERS_TO_SEARCH = 100;
    @Autowired
    private SubscriptionService subscriptionService;
    @Autowired
    private MembershipService membershipService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private UserService userService;
    @Autowired
    private WorkflowService workflowService;
    @Autowired
    private PromotionTasksService promotionTasksService;
    @Lazy
    @Autowired
    private ApplicationRepository applicationRepository;
    @Lazy
    @Autowired
    private PlanRepository planRepository;
    @Lazy
    @Autowired
    private ApiRepository apiRepository;
    @Autowired
    private EnvironmentService environmentService;

    @Override
    public List<TaskEntity> findAll(ExecutionContext executionContext, String userId) {
        if (userId == null) {
            throw new UnauthorizedAccessException();
        }
        try {
            Page<UserEntity> pendingUsers;
            List<Object> tasks;
            List<MembershipAndPermissions> userMembershipsAndPermissions = this.getUserMembershipsAndPermissions(userId);
            Set<String> apiIds = this.getApisForAPermission(executionContext, userMembershipsAndPermissions, ApiPermission.SUBSCRIPTION.getName());
            if (apiIds.isEmpty()) {
                tasks = new ArrayList();
            } else {
                SubscriptionQuery query = new SubscriptionQuery();
                query.setStatuses(Collections.singleton(SubscriptionStatus.PENDING));
                query.setApis(apiIds);
                tasks = this.subscriptionService.search(executionContext, query).stream().map(this::convert).collect(Collectors.toList());
            }
            if (this.isEnvironmentAdmin() && (pendingUsers = this.userService.search(executionContext, new UserCriteria.Builder().statuses(new UserStatus[]{UserStatus.PENDING}).build(), (Pageable)new PageableImpl(1, 100))).getContent() != null && !pendingUsers.getContent().isEmpty()) {
                tasks.addAll(pendingUsers.getContent().stream().map(this::convert).collect(Collectors.toList()));
            }
            if (!(apiIds = this.getApisForAPermission(executionContext, userMembershipsAndPermissions, ApiPermission.REVIEWS.getName())).isEmpty()) {
                apiIds.forEach(apiId -> {
                    List<Workflow> workflows = this.workflowService.findByReferenceAndType(WorkflowReferenceType.API, (String)apiId, WorkflowType.REVIEW);
                    if (workflows != null && !workflows.isEmpty()) {
                        Workflow currentWorkflow = workflows.get(0);
                        if (WorkflowState.IN_REVIEW.name().equals(currentWorkflow.getState())) {
                            tasks.add(this.convert(currentWorkflow));
                        }
                    }
                });
            }
            if (!(apiIds = this.getApisForAPermission(executionContext, userMembershipsAndPermissions, ApiPermission.DEFINITION.getName())).isEmpty()) {
                apiIds.forEach(apiId -> {
                    List<Workflow> workflows = this.workflowService.findByReferenceAndType(WorkflowReferenceType.API, (String)apiId, WorkflowType.REVIEW);
                    if (workflows != null && !workflows.isEmpty()) {
                        Workflow currentWorkflow = workflows.get(0);
                        if (WorkflowState.REQUEST_FOR_CHANGES.name().equals(currentWorkflow.getState())) {
                            tasks.add(this.convert(currentWorkflow));
                        }
                    }
                });
            }
            tasks.addAll(this.promotionTasksService.getPromotionTasks(executionContext));
            return tasks;
        }
        catch (TechnicalException e) {
            this.LOGGER.error("Error retrieving user tasks {}", (Object)e.getMessage());
            throw new TechnicalManagementException("Error retreiving user tasks", e);
        }
    }

    private List<MembershipAndPermissions> getUserMembershipsAndPermissions(String userId) {
        Set<MembershipEntity> memberships = this.membershipService.getMembershipsByMemberAndReference(MembershipMemberType.USER, userId, MembershipReferenceType.API);
        memberships.addAll(this.membershipService.getMembershipsByMemberAndReference(MembershipMemberType.USER, userId, MembershipReferenceType.GROUP));
        ArrayList<MembershipAndPermissions> userMembershipAndPermissions = new ArrayList<MembershipAndPermissions>();
        for (MembershipEntity membership : memberships) {
            RoleEntity role = this.roleService.findById(membership.getRoleId());
            if (role.getScope() != RoleScope.API) continue;
            userMembershipAndPermissions.add(new MembershipAndPermissions(membership, role.getPermissions()));
        }
        return userMembershipAndPermissions;
    }

    private Set<String> getApisForAPermission(ExecutionContext executionContext, List<MembershipAndPermissions> membershipsAndPermissions, String permission) throws TechnicalException {
        HashSet<String> apiIds = new HashSet<String>();
        ArrayList<String> groupIds = new ArrayList<String>();
        for (MembershipAndPermissions membershipAndPermissions : membershipsAndPermissions) {
            char[] rights;
            if (membershipAndPermissions == null || (rights = membershipAndPermissions.permission.get(permission)) == null) continue;
            block5: for (char c : rights) {
                if (c != 'U') continue;
                switch (membershipAndPermissions.membership.getReferenceType()) {
                    case GROUP: {
                        groupIds.add(membershipAndPermissions.membership.getReferenceId());
                        continue block5;
                    }
                    case API: {
                        apiIds.add(membershipAndPermissions.membership.getReferenceId());
                        continue block5;
                    }
                }
            }
        }
        ArrayList<ApiCriteria> apiCriteriaList = new ArrayList<ApiCriteria>();
        if (!groupIds.isEmpty()) {
            ApiCriteria criteria = new ApiCriteria.Builder().groups(groupIds).build();
            apiCriteriaList.add(criteria);
        }
        if (this.isEnvironmentAdmin()) {
            List environmentIds = this.environmentService.findByOrganization(executionContext.getOrganizationId()).stream().map(EnvironmentEntity::getId).collect(Collectors.toList());
            ApiCriteria criteria = new ApiCriteria.Builder().environments(environmentIds).build();
            apiCriteriaList.add(criteria);
        }
        apiIds.addAll(this.apiRepository.searchIds(apiCriteriaList, TaskServiceImpl.convert((Pageable)new PageableImpl(1, Integer.MAX_VALUE)), null).getContent());
        return apiIds;
    }

    @Override
    public Metadata getMetadata(ExecutionContext executionContext, List<TaskEntity> tasks) {
        Metadata metadata = new Metadata();
        tasks.forEach(task -> {
            Object data = task.getData();
            if (data instanceof SubscriptionEntity) {
                this.addSubscriptionMetadata(metadata, (SubscriptionEntity)data);
            } else if (data instanceof Workflow) {
                this.addWorkflowMetadata(metadata, (Workflow)data);
            }
        });
        return metadata;
    }

    private void addSubscriptionMetadata(Metadata metadata, SubscriptionEntity subscription) {
        if (!metadata.containsKey(subscription.getApplication())) {
            this.addApplicationMetadata(metadata, subscription);
        }
        if (!metadata.containsKey(subscription.getPlan())) {
            this.addPlanMetadata(metadata, subscription);
        }
    }

    private void addWorkflowMetadata(Metadata metadata, Workflow workflow) {
        if (WorkflowReferenceType.API.name().equals(workflow.getReferenceType()) && !metadata.containsKey(workflow.getReferenceId())) {
            try {
                Optional optionalApi = this.apiRepository.findById((Object)workflow.getReferenceId());
                optionalApi.ifPresent(api -> metadata.put(workflow.getReferenceId(), "name", (Object)api.getName()));
            }
            catch (TechnicalException e) {
                this.LOGGER.error("Error retrieving api task metadata {}", (Object)e.getMessage());
            }
        }
    }

    private void addApplicationMetadata(Metadata metadata, SubscriptionEntity subscription) {
        try {
            Optional application = this.applicationRepository.findById((Object)subscription.getApplication());
            application.ifPresent(value -> metadata.put(subscription.getApplication(), "name", (Object)value.getName()));
        }
        catch (TechnicalException e) {
            this.LOGGER.error("Error retrieving application task metadata {}", (Object)e.getMessage());
        }
    }

    private void addPlanMetadata(Metadata metadata, SubscriptionEntity subscription) {
        try {
            Optional optPlan = this.planRepository.findById((Object)subscription.getPlan());
            if (optPlan.isPresent()) {
                String apiId = ((Plan)optPlan.get()).getApi();
                metadata.put(subscription.getPlan(), "name", (Object)((Plan)optPlan.get()).getName());
                metadata.put(subscription.getPlan(), "api", (Object)apiId);
                Optional optionalApi = this.apiRepository.findById((Object)apiId);
                optionalApi.ifPresent(api -> metadata.put(apiId, "name", (Object)api.getName()));
            }
        }
        catch (TechnicalException e) {
            this.LOGGER.error("Error retrieving plan task metadata {}", (Object)e.getMessage());
        }
    }

    private TaskEntity convert(UserEntity user) {
        TaskEntity taskEntity = new TaskEntity();
        try {
            taskEntity.setType(TaskType.USER_REGISTRATION_APPROVAL);
            taskEntity.setCreatedAt(user.getCreatedAt());
            taskEntity.setData((Object)user);
        }
        catch (Exception e) {
            this.LOGGER.error("Error converting user {} to a Task", (Object)user.getId());
            throw new TechnicalManagementException("Error converting user " + user.getId() + " to a Task", e);
        }
        return taskEntity;
    }

    private TaskEntity convert(SubscriptionEntity subscription) {
        TaskEntity taskEntity = new TaskEntity();
        try {
            taskEntity.setType(TaskType.SUBSCRIPTION_APPROVAL);
            taskEntity.setCreatedAt(subscription.getCreatedAt());
            taskEntity.setData((Object)subscription);
        }
        catch (Exception e) {
            this.LOGGER.error("Error converting subscription {} to a Task", (Object)subscription.getId());
            throw new TechnicalManagementException("Error converting subscription " + subscription.getId() + " to a Task", e);
        }
        return taskEntity;
    }

    private TaskEntity convert(Workflow workflow) {
        TaskEntity taskEntity = new TaskEntity();
        try {
            taskEntity.setType(TaskType.valueOf((String)workflow.getState()));
            taskEntity.setCreatedAt(workflow.getCreatedAt());
            taskEntity.setData((Object)workflow);
        }
        catch (Exception e) {
            String error = "Error converting workflow " + workflow.getId() + " to a Task";
            this.LOGGER.error(error);
            throw new TechnicalManagementException(error, e);
        }
        return taskEntity;
    }

    private class MembershipAndPermissions {
        public MembershipEntity membership;
        public Map<String, char[]> permission;

        MembershipAndPermissions(MembershipEntity membership, Map<String, char[]> permission) {
            this.membership = membership;
            this.permission = permission;
        }
    }
}

