/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl;

import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.model.Api;
import io.gravitee.rest.api.model.CategoryEntity;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.v4.api.ApiEntity;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.service.CategoryService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.ApiNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.v4.ApiSearchService;
import io.gravitee.rest.api.service.v4.PrimaryOwnerService;
import io.gravitee.rest.api.service.v4.mapper.ApiMapper;
import io.gravitee.rest.api.service.v4.mapper.GenericApiMapper;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component(value="ApiSearchServiceImplV4")
public class ApiSearchServiceImpl
extends AbstractService
implements ApiSearchService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiSearchServiceImpl.class);
    private final ApiRepository apiRepository;
    private final ApiMapper apiMapper;
    private final GenericApiMapper genericApiMapper;
    private final PrimaryOwnerService primaryOwnerService;
    private final CategoryService categoryService;

    public ApiSearchServiceImpl(@Lazy ApiRepository apiRepository, ApiMapper apiMapper, GenericApiMapper genericApiMapper, PrimaryOwnerService primaryOwnerService, CategoryService categoryService) {
        this.apiRepository = apiRepository;
        this.apiMapper = apiMapper;
        this.genericApiMapper = genericApiMapper;
        this.primaryOwnerService = primaryOwnerService;
        this.categoryService = categoryService;
    }

    @Override
    public ApiEntity findById(ExecutionContext executionContext, String apiId) {
        Api api = this.findApiById(executionContext, apiId, true);
        PrimaryOwnerEntity primaryOwner = this.primaryOwnerService.getPrimaryOwner(executionContext, api.getId());
        return this.apiMapper.toEntity(executionContext, api, primaryOwner, null, true);
    }

    @Override
    public GenericApiEntity findGenericById(ExecutionContext executionContext, String apiId) {
        Api api = this.findApiById(executionContext, apiId, false);
        PrimaryOwnerEntity primaryOwner = this.primaryOwnerService.getPrimaryOwner(executionContext, api.getId());
        return this.genericApiMapper.toGenericApi(api, primaryOwner);
    }

    @Override
    public Optional<String> findIdByEnvironmentIdAndCrossId(String environment, String crossId) {
        try {
            return this.apiRepository.findIdByEnvironmentIdAndCrossId(environment, crossId);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("An error occurred while finding API by environment " + environment + " and crossId " + crossId, e);
        }
    }

    @Override
    public boolean exists(String apiId) {
        try {
            return this.apiRepository.existById(apiId);
        }
        catch (TechnicalException te) {
            String msg = "An error occurs while checking if the API exists: " + apiId;
            log.error(msg, (Throwable)te);
            throw new TechnicalManagementException(msg, te);
        }
    }

    @Override
    public Set<GenericApiEntity> findGenericByEnvironmentAndIdIn(ExecutionContext executionContext, Set<String> apiIds) {
        if (apiIds.isEmpty()) {
            return Collections.emptySet();
        }
        ApiCriteria criteria = new ApiCriteria.Builder().ids(apiIds).environmentId(executionContext.getEnvironmentId()).build();
        List apisFound = this.apiRepository.search(criteria);
        return this.toGenericApis(executionContext, apisFound);
    }

    @Override
    public Set<GenericApiEntity> findAllGenericByEnvironment(ExecutionContext executionContext) {
        ApiCriteria criteria = new ApiCriteria.Builder().environmentId(executionContext.getEnvironmentId()).build();
        List apisFound = this.apiRepository.search(criteria);
        return this.toGenericApis(executionContext, apisFound);
    }

    @Override
    public Api findRepositoryApiById(ExecutionContext executionContext, String apiId) {
        return this.findApiById(executionContext, apiId, true);
    }

    private Api findApiById(ExecutionContext executionContext, String apiId, boolean throwWhenNotV4) {
        try {
            log.debug("Find API by ID: {}", (Object)apiId);
            Optional<Api> optApi = this.apiRepository.findById((Object)apiId);
            if (executionContext.hasEnvironmentId()) {
                optApi = optApi.filter(result -> result.getEnvironmentId().equals(executionContext.getEnvironmentId()));
            }
            Api api = (Api)optApi.orElseThrow(() -> new ApiNotFoundException(apiId));
            if (throwWhenNotV4 && api.getDefinitionVersion() != DefinitionVersion.V4) {
                throw new IllegalArgumentException(String.format("Api found doesn't support v%s definition model.", DefinitionVersion.V4.getLabel()));
            }
            return api;
        }
        catch (TechnicalException ex) {
            log.error("An error occurs while trying to find an API using its ID: {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find an API using its ID: " + apiId, ex);
        }
    }

    private Set<GenericApiEntity> toGenericApis(ExecutionContext executionContext, List<Api> apis) {
        if (apis == null || apis.isEmpty()) {
            return Collections.emptySet();
        }
        List<String> apiIds = apis.stream().map(Api::getId).collect(Collectors.toList());
        Map<String, PrimaryOwnerEntity> primaryOwners = this.primaryOwnerService.getPrimaryOwners(executionContext, apiIds);
        Set apiWithoutPo = apiIds.stream().filter(apiId -> !primaryOwners.containsKey(apiId)).collect(Collectors.toSet());
        Stream<Object> streamApis = apis.stream();
        if (!apiWithoutPo.isEmpty()) {
            String apisAsString = String.join((CharSequence)" / ", apiWithoutPo);
            log.error("{} apis has no identified primary owners in this list {}.", (Object)apiWithoutPo.size(), (Object)apisAsString);
            streamApis = streamApis.filter(api -> !apiIds.contains(api.getId()));
        }
        List<CategoryEntity> categories = this.categoryService.findAll(executionContext.getEnvironmentId());
        return streamApis.map(publicApi -> this.genericApiMapper.toGenericApi(executionContext, (Api)publicApi, (PrimaryOwnerEntity)primaryOwners.get(publicApi.getId()), categories)).collect(Collectors.toSet());
    }
}

