/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade;

import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiKeyRepository;
import io.gravitee.repository.management.model.ApiKey;
import io.gravitee.rest.api.service.impl.upgrade.OneShotUpgrader;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ApiKeySubscriptionsUpgrader
extends OneShotUpgrader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiKeySubscriptionsUpgrader.class);
    private final ApiKeyRepository apiKeyRepository;

    @Autowired
    public ApiKeySubscriptionsUpgrader(@Lazy ApiKeyRepository apiKeyRepository) {
        super("API_KEY_SUBSCRIPTIONS_UPGRADER_STATUS");
        this.apiKeyRepository = apiKeyRepository;
    }

    @Override
    public int getOrder() {
        return 501;
    }

    @Override
    protected void processOneShotUpgrade() throws TechnicalException {
        this.apiKeyRepository.findAll().forEach(this::updateApiKeySubscriptions);
    }

    private void updateApiKeySubscriptions(ApiKey apiKey) {
        try {
            List allSubscriptions;
            LOGGER.debug("Updating subscriptions for API key [{}]", (Object)apiKey);
            List list = allSubscriptions = apiKey.getSubscriptions() != null ? apiKey.getSubscriptions() : new ArrayList();
            if (apiKey.getSubscription() != null && !allSubscriptions.contains(apiKey.getSubscription())) {
                allSubscriptions.add(apiKey.getSubscription());
            }
            apiKey.setSubscriptions(allSubscriptions);
            this.apiKeyRepository.update(apiKey);
        }
        catch (TechnicalException e) {
            LOGGER.error("Failed to update subscriptions for API key [{}]", (Object)apiKey, (Object)e);
        }
    }
}

