/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.promotion;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.PromotionRepository;
import io.gravitee.repository.management.api.search.PromotionCriteria;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Promotion;
import io.gravitee.repository.management.model.PromotionAuthor;
import io.gravitee.repository.management.model.PromotionStatus;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.Sortable;
import io.gravitee.rest.api.model.common.SortableImpl;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.promotion.PromotionEntity;
import io.gravitee.rest.api.model.promotion.PromotionEntityAuthor;
import io.gravitee.rest.api.model.promotion.PromotionEntityStatus;
import io.gravitee.rest.api.model.promotion.PromotionQuery;
import io.gravitee.rest.api.model.promotion.PromotionRequestEntity;
import io.gravitee.rest.api.model.promotion.PromotionTargetEntity;
import io.gravitee.rest.api.service.ApiDuplicatorService;
import io.gravitee.rest.api.service.ApiExportService;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.PermissionService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.cockpit.command.bridge.operation.BridgeOperation;
import io.gravitee.rest.api.service.cockpit.services.CockpitPromotionService;
import io.gravitee.rest.api.service.cockpit.services.CockpitReply;
import io.gravitee.rest.api.service.cockpit.services.CockpitReplyStatus;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.exceptions.BridgeOperationException;
import io.gravitee.rest.api.service.exceptions.ForbiddenAccessException;
import io.gravitee.rest.api.service.exceptions.PromotionAlreadyInProgressException;
import io.gravitee.rest.api.service.exceptions.PromotionNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.jackson.ser.api.ApiSerializer;
import io.gravitee.rest.api.service.promotion.PromotionService;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class PromotionServiceImpl
extends AbstractService
implements PromotionService {
    private final Logger LOGGER = LoggerFactory.getLogger(PromotionServiceImpl.class);
    private final ApiService apiService;
    private final ApiDuplicatorService apiDuplicatorService;
    private final ApiExportService apiExportService;
    private final CockpitPromotionService cockpitPromotionService;
    private final PromotionRepository promotionRepository;
    private final EnvironmentService environmentService;
    private final UserService userService;
    private final PermissionService permissionService;
    private final AuditService auditService;
    private final ObjectMapper objectMapper;

    public PromotionServiceImpl(ApiService apiService, ApiDuplicatorService apiDuplicatorService, ApiExportService apiExportService, CockpitPromotionService cockpitPromotionService, PromotionRepository promotionRepository, EnvironmentService environmentService, UserService userService, PermissionService permissionService, AuditService auditService, ObjectMapper objectMapper) {
        this.apiService = apiService;
        this.apiDuplicatorService = apiDuplicatorService;
        this.apiExportService = apiExportService;
        this.cockpitPromotionService = cockpitPromotionService;
        this.promotionRepository = promotionRepository;
        this.environmentService = environmentService;
        this.userService = userService;
        this.permissionService = permissionService;
        this.auditService = auditService;
        this.objectMapper = objectMapper;
    }

    @Override
    public List<PromotionTargetEntity> listPromotionTargets(String organizationId, String environmentId) {
        EnvironmentEntity environmentEntity = this.environmentService.findById(environmentId);
        CockpitReply<List<PromotionTargetEntity>> listCockpitReply = this.cockpitPromotionService.listPromotionTargets(organizationId, environmentId);
        if (listCockpitReply.getStatus() == CockpitReplyStatus.SUCCEEDED) {
            return listCockpitReply.getReply().stream().filter(target -> !target.getId().equals(environmentEntity.getCockpitId())).collect(Collectors.toList());
        }
        throw new BridgeOperationException(BridgeOperation.LIST_ENVIRONMENT);
    }

    @Override
    public PromotionEntity promote(ExecutionContext executionContext, String sourceEnvironmentId, String apiId, PromotionRequestEntity promotionRequest, String userId) {
        EnvironmentEntity currentEnvironmentEntity = this.environmentService.findById(sourceEnvironmentId);
        String apiDefinition = this.apiExportService.exportAsJson(new ExecutionContext(currentEnvironmentEntity.getOrganizationId(), currentEnvironmentEntity.getId()), apiId, ApiSerializer.Version.DEFAULT.getVersion(), "members", "groups");
        UserEntity author = this.userService.findById(executionContext, userId);
        PromotionQuery promotionQuery = new PromotionQuery();
        promotionQuery.setStatuses(List.of(PromotionEntityStatus.CREATED, PromotionEntityStatus.TO_BE_VALIDATED));
        promotionQuery.setApiId(apiId);
        List inProgressPromotions = this.search(promotionQuery, null, null).getContent().stream().filter(promotionEntity -> promotionEntity.getTargetEnvCockpitId().equals(promotionRequest.getTargetEnvCockpitId())).collect(Collectors.toList());
        if (!inProgressPromotions.isEmpty()) {
            throw new PromotionAlreadyInProgressException(((PromotionEntity)inProgressPromotions.get(0)).getId());
        }
        Promotion promotionToSave = this.convert(apiId, apiDefinition, currentEnvironmentEntity, promotionRequest, author);
        promotionToSave.setId(UuidString.generateRandom());
        Promotion createdPromotion = null;
        try {
            createdPromotion = (Promotion)this.promotionRepository.create((Object)promotionToSave);
            this.auditService.createApiAuditLog(executionContext, createdPromotion.getApiId(), Collections.emptyMap(), (Audit.AuditEvent)Promotion.AuditEvent.PROMOTION_CREATED, createdPromotion.getCreatedAt(), null, createdPromotion);
        }
        catch (TechnicalException exception) {
            throw new TechnicalManagementException(String.format("An error occurs while trying to create a promotion request for API %s", apiId), exception);
        }
        PromotionEntity promotionEntity2 = this.convert(createdPromotion);
        CockpitReply<PromotionEntity> cockpitReply = this.cockpitPromotionService.requestPromotion(executionContext, promotionEntity2);
        promotionEntity2.setStatus(cockpitReply.getStatus() != CockpitReplyStatus.SUCCEEDED ? PromotionEntityStatus.ERROR : PromotionEntityStatus.TO_BE_VALIDATED);
        try {
            this.promotionRepository.update((Object)this.convert(promotionEntity2));
        }
        catch (TechnicalException exception) {
            throw new TechnicalManagementException(String.format("An error occurs while trying to update promotion %s", promotionEntity2.getId()), exception);
        }
        if (cockpitReply.getStatus() != CockpitReplyStatus.SUCCEEDED) {
            throw new BridgeOperationException(BridgeOperation.PROMOTE_API);
        }
        return promotionEntity2;
    }

    @Override
    public PromotionEntity createOrUpdate(PromotionEntity promotionEntity) {
        try {
            Promotion createdOrUpdatedPromotion;
            Optional existingPromotion = this.promotionRepository.findById((Object)promotionEntity.getId());
            Promotion promotion = this.convert(promotionEntity);
            if (existingPromotion.isPresent()) {
                this.LOGGER.debug("Updating existing promotion: {}", (Object)promotion.getId());
                createdOrUpdatedPromotion = (Promotion)this.promotionRepository.update((Object)promotion);
            } else {
                this.LOGGER.debug("Creating promotion: {}", (Object)promotion.getId());
                createdOrUpdatedPromotion = (Promotion)this.promotionRepository.create((Object)promotion);
            }
            return this.convert(createdOrUpdatedPromotion);
        }
        catch (TechnicalException e) {
            this.LOGGER.error("An error occurs while trying to create or update a promotion using its id {}", (Object)promotionEntity.getId(), (Object)e);
            throw new TechnicalManagementException("An error occurs while trying to create or update a promotion using its id {}" + promotionEntity.getId(), e);
        }
    }

    @Override
    public Page<PromotionEntity> search(PromotionQuery query, Sortable sortable, Pageable pageable) {
        try {
            this.LOGGER.debug("Searching promotions");
            PromotionCriteria criteria = this.queryToCriteriaBuilder(query).build();
            Page promotions = this.promotionRepository.search(criteria, PromotionServiceImpl.convert(sortable), PromotionServiceImpl.convert(pageable));
            List entities = promotions.getContent().stream().map(this::convert).collect(Collectors.toList());
            this.LOGGER.debug("Searching promotions - Done with {} elements", (Object)entities.size());
            return new Page(entities, promotions.getPageNumber() + 1, (int)promotions.getPageElements(), promotions.getTotalElements());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to search promotions", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to search promotions", ex);
        }
    }

    @Override
    public PromotionEntity processPromotion(ExecutionContext executionContext, String promotionId, boolean accepted) {
        try {
            PromotionEntity promotionEntity;
            CockpitReply<PromotionEntity> cockpitReply;
            Promotion promotion = (Promotion)this.promotionRepository.findById((Object)promotionId).orElseThrow(() -> new PromotionNotFoundException(promotionId));
            EnvironmentEntity environment = this.environmentService.findByCockpitId(promotion.getTargetEnvCockpitId());
            ExecutionContext targetExecutionContext = new ExecutionContext(executionContext.getOrganizationId(), environment.getId());
            promotion.setStatus(accepted ? PromotionStatus.ACCEPTED : PromotionStatus.REJECTED);
            JsonNode apiDefinition = this.objectMapper.readTree(promotion.getApiDefinition());
            ApiEntity apiToUpdate = this.findAlreadyPromotedTargetApi(executionContext, environment, promotion, apiDefinition);
            if (PromotionStatus.ACCEPTED.equals((Object)promotion.getStatus())) {
                ApiEntity promoted = null;
                if (apiToUpdate == null) {
                    if (!this.permissionService.hasPermission(targetExecutionContext, RolePermission.ENVIRONMENT_API, environment.getId(), RolePermissionAction.CREATE)) {
                        throw new ForbiddenAccessException();
                    }
                    promoted = this.apiDuplicatorService.createWithImportedDefinition(targetExecutionContext, promotion.getApiDefinition());
                } else {
                    if (!this.permissionService.hasPermission(targetExecutionContext, RolePermission.ENVIRONMENT_API, environment.getId(), RolePermissionAction.UPDATE)) {
                        throw new ForbiddenAccessException();
                    }
                    promoted = this.apiDuplicatorService.updateWithImportedDefinition(targetExecutionContext, apiToUpdate.getId(), apiDefinition.toString());
                }
                promotion.setTargetApiId(promoted.getId());
            }
            if ((cockpitReply = this.cockpitPromotionService.processPromotion(targetExecutionContext, promotionEntity = this.convert(promotion))).getStatus() != CockpitReplyStatus.SUCCEEDED) {
                throw new BridgeOperationException(BridgeOperation.PROMOTE_API);
            }
            Promotion updated = (Promotion)this.promotionRepository.update((Object)promotion);
            return this.convert(updated);
        }
        catch (TechnicalException | IOException ex) {
            this.LOGGER.error("An error occurs while trying to process promotion", ex);
            throw new TechnicalManagementException("An error occurs while trying to process promotion", ex);
        }
    }

    private Promotion convert(String apiId, String apiDefinition, EnvironmentEntity source, PromotionRequestEntity target, UserEntity author) {
        PromotionAuthor promotionAuthor = new PromotionAuthor();
        promotionAuthor.setUserId(author.getId());
        promotionAuthor.setDisplayName(author.getDisplayName());
        promotionAuthor.setEmail(author.getEmail());
        promotionAuthor.setPicture(author.getPicture());
        promotionAuthor.setSource(author.getSource());
        promotionAuthor.setSourceId(author.getSourceId());
        Promotion promotion = new Promotion();
        promotion.setCreatedAt(new Date());
        promotion.setStatus(PromotionStatus.CREATED);
        promotion.setApiDefinition(apiDefinition);
        promotion.setApiId(apiId);
        promotion.setSourceEnvCockpitId(source.getCockpitId());
        promotion.setSourceEnvName(source.getName());
        promotion.setTargetEnvCockpitId(target.getTargetEnvCockpitId());
        promotion.setTargetEnvName(target.getTargetEnvName());
        promotion.setAuthor(promotionAuthor);
        return promotion;
    }

    private PromotionEntity convert(Promotion promotion) {
        PromotionEntityAuthor promotionEntityAuthor = new PromotionEntityAuthor();
        promotionEntityAuthor.setUserId(promotion.getAuthor().getUserId());
        promotionEntityAuthor.setDisplayName(promotion.getAuthor().getDisplayName());
        promotionEntityAuthor.setEmail(promotion.getAuthor().getEmail());
        promotionEntityAuthor.setPicture(promotion.getAuthor().getPicture());
        promotionEntityAuthor.setSource(promotion.getAuthor().getSource());
        promotionEntityAuthor.setSourceId(promotion.getAuthor().getSourceId());
        PromotionEntity promotionEntity = new PromotionEntity();
        promotionEntity.setId(promotion.getId());
        promotionEntity.setApiId(promotion.getApiId());
        promotionEntity.setCreatedAt(promotion.getCreatedAt());
        promotionEntity.setUpdatedAt(promotion.getUpdatedAt());
        promotionEntity.setSourceEnvCockpitId(promotion.getSourceEnvCockpitId());
        promotionEntity.setSourceEnvName(promotion.getSourceEnvName());
        promotionEntity.setTargetEnvCockpitId(promotion.getTargetEnvCockpitId());
        promotionEntity.setTargetEnvName(promotion.getTargetEnvName());
        promotionEntity.setApiDefinition(promotion.getApiDefinition());
        promotionEntity.setStatus(this.convert(promotion.getStatus()));
        promotionEntity.setAuthor(promotionEntityAuthor);
        promotionEntity.setTargetApiId(promotion.getTargetApiId());
        return promotionEntity;
    }

    private Promotion convert(PromotionEntity promotionEntity) {
        PromotionAuthor promotionAuthor = new PromotionAuthor();
        promotionAuthor.setUserId(promotionEntity.getAuthor().getUserId());
        promotionAuthor.setDisplayName(promotionEntity.getAuthor().getDisplayName());
        promotionAuthor.setEmail(promotionEntity.getAuthor().getEmail());
        promotionAuthor.setPicture(promotionEntity.getAuthor().getPicture());
        promotionAuthor.setSource(promotionEntity.getAuthor().getSource());
        promotionAuthor.setSourceId(promotionEntity.getAuthor().getSourceId());
        Promotion promotion = new Promotion();
        promotion.setId(promotionEntity.getId());
        promotion.setApiId(promotionEntity.getApiId());
        promotion.setCreatedAt(promotionEntity.getCreatedAt());
        promotion.setUpdatedAt(promotionEntity.getUpdatedAt());
        promotion.setSourceEnvCockpitId(promotionEntity.getSourceEnvCockpitId());
        promotion.setSourceEnvName(promotionEntity.getSourceEnvName());
        promotion.setTargetEnvCockpitId(promotionEntity.getTargetEnvCockpitId());
        promotion.setTargetEnvName(promotionEntity.getTargetEnvName());
        promotion.setApiDefinition(promotionEntity.getApiDefinition());
        promotion.setStatus(this.convert(promotionEntity.getStatus()));
        promotion.setAuthor(promotionAuthor);
        return promotion;
    }

    private PromotionEntityStatus convert(PromotionStatus promotionStatus) {
        return PromotionEntityStatus.valueOf((String)promotionStatus.name());
    }

    private PromotionStatus convert(PromotionEntityStatus promotionEntityStatus) {
        return PromotionStatus.valueOf((String)promotionEntityStatus.name());
    }

    private PromotionCriteria.Builder queryToCriteriaBuilder(PromotionQuery query) {
        PromotionCriteria.Builder builder = new PromotionCriteria.Builder();
        if (query == null) {
            return builder;
        }
        if (!CollectionUtils.isEmpty((Collection)query.getTargetEnvCockpitIds())) {
            builder.targetEnvCockpitIds(query.getTargetEnvCockpitIds().toArray(new String[0]));
        }
        if (query.getStatuses() != null) {
            builder.statuses(query.getStatuses().stream().map(this::convert).collect(Collectors.toList()));
        }
        if (query.getTargetApiExists() != null) {
            builder.targetApiExists(query.getTargetApiExists());
        }
        if (!StringUtils.isEmpty((Object)query.getApiId())) {
            builder.apiId(query.getApiId());
        }
        return builder;
    }

    protected ApiEntity findAlreadyPromotedTargetApi(ExecutionContext executionContext, EnvironmentEntity environment, Promotion promotion, JsonNode apiDefinition) {
        return this.findAlreadyPromotedApiByCrossId(environment, apiDefinition).orElseGet(() -> this.findAlreadyPromotedApiFromLastPromotion(executionContext, promotion));
    }

    private Optional<ApiEntity> findAlreadyPromotedApiByCrossId(EnvironmentEntity environment, JsonNode apiDefinition) {
        return apiDefinition.hasNonNull("crossId") ? this.apiService.findByEnvironmentIdAndCrossId(environment.getId(), apiDefinition.get("crossId").asText()) : Optional.empty();
    }

    private ApiEntity findAlreadyPromotedApiFromLastPromotion(ExecutionContext executionContext, Promotion promotion) {
        PromotionQuery promotionQuery = new PromotionQuery();
        promotionQuery.setStatuses(Collections.singletonList(PromotionEntityStatus.ACCEPTED));
        promotionQuery.setTargetEnvCockpitIds(Collections.singletonList(promotion.getTargetEnvCockpitId()));
        promotionQuery.setTargetApiExists(Boolean.valueOf(true));
        promotionQuery.setApiId(promotion.getApiId());
        List previousPromotions = this.search(promotionQuery, (Sortable)new SortableImpl("created_at", false), null).getContent();
        if (!CollectionUtils.isEmpty((Collection)previousPromotions)) {
            PromotionEntity lastAcceptedPromotion = (PromotionEntity)previousPromotions.get(0);
            return this.apiService.exists(lastAcceptedPromotion.getTargetApiId()) ? this.apiService.findById(executionContext, lastAcceptedPromotion.getTargetApiId()) : null;
        }
        return null;
    }
}

