/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.InvitationRepository;
import io.gravitee.repository.management.model.Invitation;
import io.gravitee.rest.api.model.GroupEntity;
import io.gravitee.rest.api.model.InvitationEntity;
import io.gravitee.rest.api.model.InvitationReferenceType;
import io.gravitee.rest.api.model.MembershipEntity;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.NewInvitationEntity;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.UpdateInvitationEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.service.EmailService;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.InvitationService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.PermissionService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.builder.EmailNotificationBuilder;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.JWTHelper;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.exceptions.InvitationEmailAlreadyExistsException;
import io.gravitee.rest.api.service.exceptions.InvitationNotFoundException;
import io.gravitee.rest.api.service.exceptions.MemberEmailAlreadyExistsException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.TransactionalService;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InvitationServiceImpl
extends TransactionalService
implements InvitationService {
    private final Logger LOGGER = LoggerFactory.getLogger(InvitationServiceImpl.class);
    @Autowired
    private InvitationRepository invitationRepository;
    @Autowired
    private EmailService emailService;
    @Autowired
    private UserService userService;
    @Autowired
    private MembershipService membershipService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private GroupService groupService;
    @Autowired
    PermissionService permissionService;

    @Override
    public InvitationEntity create(ExecutionContext executionContext, NewInvitationEntity invitation) {
        List<InvitationEntity> invitations = this.findByReference(invitation.getReferenceType(), invitation.getReferenceId());
        if (invitations.stream().map(InvitationEntity::getEmail).anyMatch(invitation.getEmail()::equals)) {
            throw new InvitationEmailAlreadyExistsException(invitation.getEmail());
        }
        try {
            Optional<UserEntity> existingUser = this.userService.findByEmail(executionContext, invitation.getEmail());
            if (existingUser.isPresent()) {
                UserEntity user = existingUser.get();
                Set groupUsers = this.membershipService.getMembershipsByReference(MembershipReferenceType.GROUP, invitation.getReferenceId()).stream().map(MembershipEntity::getMemberId).collect(Collectors.toSet());
                GroupEntity group = this.groupService.findById(executionContext, invitation.getReferenceId());
                if (groupUsers.contains(user.getId())) {
                    throw new MemberEmailAlreadyExistsException(invitation.getEmail());
                }
                boolean hasPermission = this.permissionService.hasPermission(executionContext, RolePermission.ENVIRONMENT_GROUP, executionContext.getEnvironmentId(), RolePermissionAction.CREATE, RolePermissionAction.UPDATE, RolePermissionAction.DELETE);
                if (!hasPermission && group.isLockApiRole()) {
                    invitation.setApiRole(null);
                }
                if (!hasPermission && group.isLockApplicationRole()) {
                    invitation.setApplicationRole(null);
                }
                this.addMember(executionContext, invitation.getReferenceType().name(), invitation.getReferenceId(), user.getId(), invitation.getApiRole(), invitation.getApplicationRole());
                return null;
            }
            this.sendGroupInvitationEmail(executionContext, invitation);
            Invitation createdInvitation = (Invitation)this.invitationRepository.create((Object)this.convert(invitation));
            return this.convert(createdInvitation);
        }
        catch (TechnicalException ex) {
            String message = "An error occurs while trying to create invitation for email " + invitation.getEmail();
            this.LOGGER.error(message, (Throwable)ex);
            throw new TechnicalManagementException(message, ex);
        }
    }

    @Override
    public InvitationEntity update(UpdateInvitationEntity invitation) {
        try {
            Optional invitationOptional = this.invitationRepository.findById((Object)invitation.getId());
            if (invitationOptional.isPresent()) {
                Invitation invitationToUpdate = (Invitation)invitationOptional.get();
                if (!invitationToUpdate.getReferenceId().equals(invitation.getReferenceId())) {
                    throw new InvitationNotFoundException(invitation.getId());
                }
                invitationToUpdate.setApiRole(invitation.getApiRole());
                invitationToUpdate.setApplicationRole(invitation.getApplicationRole());
                invitationToUpdate.setUpdatedAt(new Date());
                return this.convert((Invitation)this.invitationRepository.update((Object)invitationToUpdate));
            }
            throw new InvitationNotFoundException(invitation.getId());
        }
        catch (TechnicalException ex) {
            String message = "An error occurs while trying to update invitation with email " + invitation.getEmail();
            this.LOGGER.error(message, (Throwable)ex);
            throw new TechnicalManagementException(message, ex);
        }
    }

    @Override
    public void addMember(ExecutionContext executionContext, String referenceType, String referenceId, String userId, String apiRole, String applicationRole) {
        this.addOrUpdateMemberByScope(executionContext, referenceType, referenceId, userId, RoleScope.API, apiRole);
        this.addOrUpdateMemberByScope(executionContext, referenceType, referenceId, userId, RoleScope.APPLICATION, applicationRole);
        this.addOrUpdateMemberByScope(executionContext, referenceType, referenceId, userId, RoleScope.GROUP, null);
    }

    private void addOrUpdateMemberByScope(ExecutionContext executionContext, String referenceType, String referenceId, String userId, RoleScope roleScope, String defaultRole) {
        String defaultRoleName = null;
        if (defaultRole == null) {
            List<RoleEntity> defaultRoles = this.roleService.findDefaultRoleByScopes(executionContext.getOrganizationId(), roleScope);
            if (defaultRoles != null && !defaultRoles.isEmpty()) {
                defaultRoleName = defaultRoles.get(0).getName();
            }
        } else {
            defaultRoleName = defaultRole;
        }
        if (defaultRoleName != null) {
            this.membershipService.addRoleToMemberOnReference(executionContext, new MembershipService.MembershipReference(MembershipReferenceType.valueOf((String)referenceType), referenceId), new MembershipService.MembershipMember(userId, null, MembershipMemberType.USER), new MembershipService.MembershipRole(roleScope, defaultRoleName));
        }
    }

    private void sendGroupInvitationEmail(ExecutionContext executionContext, NewInvitationEntity invitation) {
        UserEntity userEntity = new UserEntity();
        userEntity.setEmail(invitation.getEmail());
        GroupEntity group = this.groupService.findById(executionContext, invitation.getReferenceId());
        this.emailService.sendEmailNotification(executionContext, new EmailNotificationBuilder().to(invitation.getEmail()).template(EmailNotificationBuilder.EmailTemplate.TEMPLATES_FOR_ACTION_USER_GROUP_INVITATION).params(this.userService.getTokenRegistrationParams(executionContext, userEntity, "/#!/registration/confirm/", JWTHelper.ACTION.GROUP_INVITATION)).param("group", group).build());
    }

    @Override
    public List<InvitationEntity> findAll() {
        try {
            Set invitations = this.invitationRepository.findAll();
            return invitations.stream().map(this::convert).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            String message = "An error occurs while trying to list all invitations";
            this.LOGGER.error("An error occurs while trying to list all invitations", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to list all invitations", ex);
        }
    }

    @Override
    public List<InvitationEntity> findByReference(InvitationReferenceType referenceType, String referenceId) {
        try {
            List invitations = this.invitationRepository.findByReference(referenceType.name(), referenceId);
            return invitations.stream().map(this::convert).sorted(Comparator.comparing(InvitationEntity::getEmail)).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            String message = "An error occurs while trying to list invitations by reference " + referenceType + "/" + referenceId;
            this.LOGGER.error(message, (Throwable)ex);
            throw new TechnicalManagementException(message, ex);
        }
    }

    @Override
    public void delete(String invitationId, String referenceId) {
        try {
            Optional optionalInvitation = this.invitationRepository.findById((Object)invitationId);
            if (!optionalInvitation.isPresent() || !((Invitation)optionalInvitation.get()).getReferenceId().equals(referenceId)) {
                throw new InvitationNotFoundException(invitationId);
            }
            this.invitationRepository.delete((Object)invitationId);
        }
        catch (TechnicalException te) {
            String msg = "An error occurs while trying to delete the invitation " + invitationId;
            this.LOGGER.error(msg, (Throwable)te);
            throw new TechnicalManagementException(msg, te);
        }
    }

    private Invitation convert(NewInvitationEntity invitationEntity) {
        Invitation invitation = new Invitation();
        invitation.setId(UuidString.generateRandom());
        invitation.setReferenceId(invitationEntity.getReferenceId());
        invitation.setReferenceType(invitationEntity.getReferenceType().name());
        invitation.setApiRole(invitationEntity.getApiRole());
        invitation.setApplicationRole(invitationEntity.getApplicationRole());
        invitation.setEmail(invitationEntity.getEmail());
        Date now = new Date();
        invitation.setCreatedAt(now);
        return invitation;
    }

    private InvitationEntity convert(Invitation invitation) {
        InvitationEntity invitationEntity = new InvitationEntity();
        invitationEntity.setId(invitation.getId());
        invitationEntity.setReferenceId(invitation.getReferenceId());
        invitationEntity.setReferenceType(InvitationReferenceType.valueOf((String)invitation.getReferenceType()));
        invitationEntity.setApiRole(invitation.getApiRole());
        invitationEntity.setApplicationRole(invitation.getApplicationRole());
        invitationEntity.setEmail(invitation.getEmail());
        invitationEntity.setCreatedAt(invitation.getCreatedAt());
        return invitationEntity;
    }
}

