/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.gravitee.alert.api.condition.Filter;
import io.gravitee.alert.api.condition.StringCondition;
import io.gravitee.alert.api.trigger.Dampening;
import io.gravitee.alert.api.trigger.Trigger;
import io.gravitee.common.event.Event;
import io.gravitee.notifier.api.Notification;
import io.gravitee.repository.management.api.AlertTriggerRepository;
import io.gravitee.rest.api.model.ApplicationEntity;
import io.gravitee.rest.api.model.MembershipEntity;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.alert.AlertReferenceType;
import io.gravitee.rest.api.model.alert.AlertStatusEntity;
import io.gravitee.rest.api.model.alert.AlertTriggerEntity;
import io.gravitee.rest.api.model.alert.ApplicationAlertEventType;
import io.gravitee.rest.api.model.alert.ApplicationAlertMembershipEvent;
import io.gravitee.rest.api.model.alert.NewAlertTriggerEntity;
import io.gravitee.rest.api.model.alert.UpdateAlertTriggerEntity;
import io.gravitee.rest.api.model.application.ApplicationListItem;
import io.gravitee.rest.api.model.event.AbstractOrganizationEvent;
import io.gravitee.rest.api.model.notification.NotificationTemplateEntity;
import io.gravitee.rest.api.model.notification.NotificationTemplateEvent;
import io.gravitee.rest.api.service.AlertService;
import io.gravitee.rest.api.service.ApplicationAlertService;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.notification.AlertHook;
import io.gravitee.rest.api.service.notification.HookScope;
import io.gravitee.rest.api.service.notification.NotificationTemplateService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class ApplicationAlertServiceImpl
implements ApplicationAlertService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationAlertServiceImpl.class);
    public static final String DEFAULT_EMAIL_NOTIFIER = "default-email";
    public static final String DEFAULT_WEBHOOK_NOTIFIER = "webhook-notifier";
    public static final String STATUS_ALERT = "METRICS_RATE";
    public static final String RESPONSE_TIME_ALERT = "METRICS_AGGREGATION";
    private final ApplicationService applicationService;
    private final AlertService alertService;
    private final AlertTriggerRepository alertTriggerRepository;
    private final MembershipService membershipService;
    private final UserService userService;
    private final ObjectMapper mapper;
    private final NotificationTemplateService notificationTemplateService;
    private final String emailFrom;

    public ApplicationAlertServiceImpl(ApplicationService applicationService, AlertService alertService, AlertTriggerRepository alertTriggerRepository, MembershipService membershipService, UserService userService, ObjectMapper mapper, NotificationTemplateService notificationTemplateService, @Value(value="${email.from}") String emailFrom) {
        this.applicationService = applicationService;
        this.alertService = alertService;
        this.alertTriggerRepository = alertTriggerRepository;
        this.membershipService = membershipService;
        this.userService = userService;
        this.mapper = mapper;
        this.notificationTemplateService = notificationTemplateService;
        this.emailFrom = emailFrom;
    }

    @Override
    public AlertTriggerEntity create(ExecutionContext executionContext, String applicationId, NewAlertTriggerEntity alert) {
        ApplicationEntity application = this.applicationService.findById(executionContext, applicationId);
        alert.setName(this.generateAlertName(application, alert));
        alert.setReferenceType(AlertReferenceType.APPLICATION);
        alert.setReferenceId(application.getId());
        alert.setSource("REQUEST");
        alert.setSeverity(Trigger.Severity.INFO);
        alert.setDampening(Dampening.strictCount((int)1));
        alert.setFilters(this.combineFilters(applicationId, alert.getFilters()));
        List<String> recipients = this.getNotificationRecipients(executionContext, application.getId(), application.getGroups());
        if (!CollectionUtils.isEmpty(recipients)) {
            alert.setNotifications(this.combineNotifications(alert.getNotifications(), this.createNotification(alert.getType(), recipients, executionContext.getOrganizationId())));
        }
        return this.alertService.create(executionContext, alert);
    }

    private List<Notification> createNotification(String alertType, String organizationId) {
        return this.createNotification(alertType, new ArrayList<String>(), organizationId);
    }

    private List<Notification> createNotification(String alertType, List<String> recipients, String organizationId) {
        try {
            Notification notification = new Notification();
            notification.setType(DEFAULT_EMAIL_NOTIFIER);
            ObjectNode configuration = this.mapper.createObjectNode();
            configuration.put("from", this.emailFrom);
            configuration.put("to", String.join((CharSequence)",", recipients));
            this.generateNotificationBodyFromTemplate(configuration, alertType, organizationId);
            notification.setPeriods(Collections.emptyList());
            notification.setConfiguration(this.mapper.writeValueAsString((Object)configuration));
            return Collections.singletonList(notification);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("An error occurs while trying to create the Alert notification", (Throwable)e);
            throw new TechnicalManagementException("An error occurs while trying to create the Alert notification");
        }
    }

    @Override
    public List<AlertTriggerEntity> findByApplication(String applicationId) {
        return this.alertService.findByReference(AlertReferenceType.APPLICATION, applicationId);
    }

    @Override
    public AlertTriggerEntity update(ExecutionContext executionContext, String applicationId, UpdateAlertTriggerEntity alert) {
        AlertTriggerEntity alertTrigger = this.alertService.findById(alert.getId());
        alert.setName(alertTrigger.getName());
        alert.setReferenceType(AlertReferenceType.APPLICATION);
        alert.setReferenceId(alertTrigger.getReferenceId());
        alert.setSource("REQUEST");
        alert.setSeverity(Trigger.Severity.INFO);
        alert.setDampening(Dampening.strictCount((int)1));
        alert.setFilters(this.combineFilters(applicationId, alert.getFilters()));
        alertTrigger.getNotifications().removeIf(n -> DEFAULT_WEBHOOK_NOTIFIER.equals(n.getType()));
        alert.setNotifications(this.combineNotifications(alert.getNotifications(), alertTrigger.getNotifications()));
        return this.alertService.update(executionContext, alert);
    }

    @Override
    public void delete(String alertId, String applicationId) {
        this.alertService.delete(alertId, applicationId);
    }

    @Override
    public AlertStatusEntity getStatus(ExecutionContext executionContext) {
        return this.alertService.getStatus(executionContext);
    }

    @Override
    public void addMemberToApplication(ExecutionContext executionContext, String applicationId, String email) {
        if (StringUtils.isEmpty((Object)email)) {
            return;
        }
        this.applicationService.findById(executionContext, applicationId);
        this.alertService.findByReference(AlertReferenceType.APPLICATION, applicationId).forEach(trigger -> {
            Optional<Notification> notificationOpt;
            if (trigger.getNotifications() == null) {
                trigger.setNotifications(this.createNotification(trigger.getType(), executionContext.getOrganizationId()));
            }
            if ((notificationOpt = trigger.getNotifications().stream().filter(n -> DEFAULT_EMAIL_NOTIFIER.equals(n.getType())).findFirst()).isPresent()) {
                Notification notification = notificationOpt.get();
                try {
                    ObjectNode configuration = this.mapper.createObjectNode();
                    JsonNode emailNode = this.mapper.readTree(notification.getConfiguration());
                    configuration.put("to", emailNode.path("to").asText() + "," + email);
                    configuration.put("from", emailNode.path("from").asText());
                    configuration.put("subject", emailNode.path("subject").asText());
                    configuration.put("body", emailNode.path("body").asText());
                    notification.setConfiguration(this.mapper.writeValueAsString((Object)configuration));
                }
                catch (JsonProcessingException e) {
                    LOGGER.error("An error occurs while trying to add a recipient to the Alert notification", (Throwable)e);
                    throw new TechnicalManagementException("An error occurs while trying to add a recipient to the Alert notification");
                }
            } else {
                trigger.setNotifications(this.createNotification(trigger.getType(), Collections.singletonList(email), executionContext.getOrganizationId()));
            }
            this.alertService.update(executionContext, this.convert((AlertTriggerEntity)trigger));
        });
    }

    @Override
    public void deleteMemberFromApplication(ExecutionContext executionContext, String applicationId, String email) {
        if (StringUtils.isEmpty((Object)email)) {
            return;
        }
        this.applicationService.findById(executionContext, applicationId);
        this.alertService.findByReference(AlertReferenceType.APPLICATION, applicationId).forEach(trigger -> {
            Optional<Notification> notificationOpt;
            if (trigger.getNotifications() == null) {
                trigger.setNotifications(this.createNotification(trigger.getType(), executionContext.getOrganizationId()));
            }
            if ((notificationOpt = trigger.getNotifications().stream().filter(n -> DEFAULT_EMAIL_NOTIFIER.equals(n.getType())).findFirst()).isPresent()) {
                Notification notification = notificationOpt.get();
                try {
                    ObjectNode configuration = this.mapper.createObjectNode();
                    JsonNode emailNode = this.mapper.readTree(notification.getConfiguration());
                    String to = Arrays.stream(emailNode.path("to").asText().split(",|;|\\s")).filter(mailTo -> !mailTo.equals(email)).collect(Collectors.joining(","));
                    if (StringUtils.isEmpty((Object)to)) {
                        trigger.setNotifications(Collections.emptyList());
                    } else {
                        configuration.put("to", to);
                        configuration.put("from", emailNode.path("from").asText());
                        configuration.put("subject", emailNode.path("subject").asText());
                        configuration.put("body", emailNode.path("body").asText());
                        notification.setConfiguration(this.mapper.writeValueAsString((Object)configuration));
                    }
                    this.alertService.update(executionContext, this.convert((AlertTriggerEntity)trigger));
                }
                catch (JsonProcessingException e) {
                    LOGGER.error("An error occurs while trying to add a recipient to the Alert notification", (Throwable)e);
                    throw new TechnicalManagementException("An error occurs while trying to add a recipient to the Alert notification");
                }
            }
        });
    }

    @Override
    public void deleteAll(String applicationId) {
        this.alertService.findByReference(AlertReferenceType.APPLICATION, applicationId).forEach(trigger -> this.alertService.delete(trigger.getId(), applicationId));
    }

    @Override
    @Async
    public void handleEvent(Event<ApplicationAlertEventType, Object> event) {
        AbstractOrganizationEvent abstractEvent = (AbstractOrganizationEvent)event.content();
        String organizationId = abstractEvent.getOrganizationId();
        switch ((ApplicationAlertEventType)event.type()) {
            case NOTIFICATION_TEMPLATE_UPDATE: {
                NotificationTemplateEvent notificationEvent = (NotificationTemplateEvent)event.content();
                NotificationTemplateEntity notificationTemplate = notificationEvent.getNotificationTemplateEntity();
                if (notificationTemplate.getHook().equals(AlertHook.CONSUMER_HTTP_STATUS.name())) {
                    this.updateAllAlertsBody(organizationId, STATUS_ALERT, notificationTemplate.getContent(), notificationTemplate.getTitle());
                    break;
                }
                if (!notificationTemplate.getHook().equals(AlertHook.CONSUMER_RESPONSE_TIME.name())) break;
                this.updateAllAlertsBody(organizationId, RESPONSE_TIME_ALERT, notificationTemplate.getContent(), notificationTemplate.getTitle());
                break;
            }
            case APPLICATION_MEMBERSHIP_UPDATE: {
                this.updateAlertsRecipients((ApplicationAlertMembershipEvent)event.content(), organizationId);
            }
        }
    }

    private void updateAlertsRecipients(ApplicationAlertMembershipEvent alertMembershipEvent, String organizationId) {
        HashSet applicationIds = new HashSet(alertMembershipEvent.getApplicationIds());
        ExecutionContext executionContext = new ExecutionContext(organizationId, null);
        if (!CollectionUtils.isEmpty((Collection)alertMembershipEvent.getGroupIds())) {
            this.applicationService.findByGroups(executionContext, new ArrayList<String>(alertMembershipEvent.getGroupIds())).stream().map(ApplicationListItem::getId).forEach(applicationIds::add);
        }
        Map<String, List> recipientsByApplicationId = this.applicationService.findByIds(executionContext, new ArrayList<String>(applicationIds)).stream().collect(Collectors.toMap(ApplicationListItem::getId, app -> this.getNotificationRecipients(executionContext, app.getId(), app.getGroups())));
        this.alertService.findByReferences(AlertReferenceType.APPLICATION, new ArrayList<String>(applicationIds)).forEach(trigger -> {
            if (trigger.getNotifications() == null) {
                trigger.setNotifications(this.createNotification(trigger.getType(), organizationId));
            }
            this.updateTriggerNotification(executionContext, (AlertTriggerEntity)trigger, (List)recipientsByApplicationId.get(trigger.getReferenceId()));
        });
    }

    private void updateAllAlertsBody(String organizationId, String type, String body, String subject) {
        ExecutionContext executionContext = new ExecutionContext(organizationId, null);
        Set<String> ids = this.applicationService.findIdsByOrganization(organizationId);
        this.alertService.findByReferences(AlertReferenceType.APPLICATION, List.copyOf(ids)).stream().filter(alert -> alert.getType().equals(type)).forEach(trigger -> {
            if (trigger.getNotifications() == null) {
                trigger.setNotifications(this.createNotification(trigger.getType(), organizationId));
            }
            this.updateTriggerNotification(executionContext, (AlertTriggerEntity)trigger, body, subject);
        });
    }

    private String generateAlertName(ApplicationEntity application, NewAlertTriggerEntity alert) {
        return String.format("%s - %s", alert.getType(), application.getId());
    }

    private List<String> getNotificationRecipients(ExecutionContext executionContext, String applicationId, Set<String> groupIds) {
        List<String> members = this.membershipService.getMembershipsByReference(MembershipReferenceType.APPLICATION, applicationId).stream().map(MembershipEntity::getMemberId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(groupIds)) {
            groupIds.forEach(group -> members.addAll(this.membershipService.getMembershipsByReference(MembershipReferenceType.GROUP, (String)group).stream().map(MembershipEntity::getMemberId).collect(Collectors.toList())));
        }
        return this.userService.findByIds(executionContext, members).stream().map(UserEntity::getEmail).filter(mail -> !StringUtils.isEmpty((Object)mail)).collect(Collectors.toList());
    }

    private void generateNotificationBodyFromTemplate(ObjectNode configuration, String alertType, String organizationId) {
        Consumer<NotificationTemplateEntity> templateConsumer = template -> {
            configuration.put("subject", template.getTitle());
            configuration.put("body", template.getContent());
        };
        if (STATUS_ALERT.equals(alertType)) {
            this.notificationTemplateService.findByHookAndScope(organizationId, AlertHook.CONSUMER_HTTP_STATUS.name(), HookScope.TEMPLATES_FOR_ALERT.name()).stream().findFirst().ifPresent(templateConsumer);
        } else if (RESPONSE_TIME_ALERT.equals(alertType)) {
            this.notificationTemplateService.findByHookAndScope(organizationId, AlertHook.CONSUMER_RESPONSE_TIME.name(), HookScope.TEMPLATES_FOR_ALERT.name()).stream().findFirst().ifPresent(templateConsumer);
        }
    }

    private void updateTriggerNotification(ExecutionContext executionContext, AlertTriggerEntity trigger, List<String> recipients) {
        this.updateTriggerNotification(executionContext, trigger, null, null, recipients);
    }

    private void updateTriggerNotification(ExecutionContext executionContext, AlertTriggerEntity trigger, String body, String subject) {
        this.updateTriggerNotification(executionContext, trigger, body, subject, null);
    }

    private void updateTriggerNotification(ExecutionContext executionContext, AlertTriggerEntity trigger, String body, String subject, List<String> recipients) {
        if (CollectionUtils.isEmpty((Collection)trigger.getNotifications())) {
            return;
        }
        trigger.getNotifications().stream().filter(n -> DEFAULT_EMAIL_NOTIFIER.equals(n.getType())).findFirst().ifPresent(notification -> {
            try {
                ObjectNode configuration = this.mapper.createObjectNode();
                JsonNode emailNode = this.mapper.readTree(notification.getConfiguration());
                configuration.put("to", recipients == null ? emailNode.path("to").asText() : String.join((CharSequence)",", recipients));
                configuration.put("from", emailNode.path("from").asText());
                configuration.put("subject", subject == null ? emailNode.path("subject").asText() : subject);
                configuration.put("body", body == null ? emailNode.path("body").asText() : body);
                notification.setConfiguration(this.mapper.writeValueAsString((Object)configuration));
                this.alertService.update(executionContext, this.convert(trigger));
            }
            catch (JsonProcessingException e) {
                LOGGER.error("An error occurs while trying to update Alert notification", (Throwable)e);
                throw new TechnicalManagementException("An error occurs while trying to update Alert notification");
            }
        });
    }

    private UpdateAlertTriggerEntity convert(AlertTriggerEntity trigger) {
        UpdateAlertTriggerEntity updating = new UpdateAlertTriggerEntity();
        updating.setId(trigger.getId());
        updating.setName(trigger.getName());
        updating.setEnabled(trigger.isEnabled());
        updating.setDescription(trigger.getDescription());
        updating.setReferenceType(trigger.getReferenceType());
        updating.setReferenceId(trigger.getReferenceId());
        updating.setSeverity(trigger.getSeverity());
        updating.setEventRules(trigger.getEventRules());
        updating.setConditions(trigger.getConditions());
        updating.setDampening(trigger.getDampening());
        updating.setFilters(trigger.getFilters());
        updating.setMetadata(trigger.getMetadata());
        updating.setNotifications(trigger.getNotifications());
        updating.setNotificationPeriods(trigger.getNotificationPeriods());
        updating.setSource(trigger.getSource());
        return updating;
    }

    private List<Filter> combineFilters(String applicationId, List<Filter> filtersToAdd) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        filters.add((Filter)StringCondition.equals((String)"application", (String)applicationId).build());
        if (filtersToAdd != null) {
            filters.addAll(filtersToAdd);
        }
        return filters;
    }

    private List<Notification> combineNotifications(List<Notification> ... notificationsToAdd) {
        return Arrays.stream(notificationsToAdd).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

