/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.filtering;

import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.search.Order;
import io.gravitee.rest.api.model.CategoryEntity;
import io.gravitee.rest.api.model.SubscriptionEntity;
import io.gravitee.rest.api.model.SubscriptionStatus;
import io.gravitee.rest.api.model.TopApiEntity;
import io.gravitee.rest.api.model.api.ApiQuery;
import io.gravitee.rest.api.model.subscription.SubscriptionQuery;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.PermissionService;
import io.gravitee.rest.api.service.RatingService;
import io.gravitee.rest.api.service.SubscriptionService;
import io.gravitee.rest.api.service.TopApiService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.filtering.FilteringService;
import io.gravitee.rest.api.service.impl.AbstractService;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FilteringServiceImpl
extends AbstractService
implements FilteringService {
    @Autowired
    SubscriptionService subscriptionService;
    @Autowired
    RatingService ratingService;
    @Autowired
    TopApiService topApiService;
    @Autowired
    ApplicationService applicationService;
    @Autowired
    ApiService apiService;
    @Autowired
    PermissionService permissionService;

    @Override
    public Collection<String> getApisOrderByNumberOfSubscriptions(Collection<String> apis, boolean excluded) {
        SubscriptionQuery subscriptionQuery = new SubscriptionQuery();
        subscriptionQuery.setStatuses(Arrays.asList(SubscriptionStatus.ACCEPTED, SubscriptionStatus.PAUSED));
        subscriptionQuery.setApis(apis);
        Set<String> apisOrderByNumberOfSubscriptions = this.subscriptionService.findReferenceIdsOrderByNumberOfSubscriptions(subscriptionQuery, Order.DESC);
        if (excluded) {
            apis.removeAll(apisOrderByNumberOfSubscriptions);
            return apis;
        }
        apisOrderByNumberOfSubscriptions.addAll(apis);
        return apisOrderByNumberOfSubscriptions;
    }

    @Override
    public Collection<String> getApplicationsOrderByNumberOfSubscriptions(Collection<String> ids, Order order) {
        SubscriptionQuery subscriptionQuery = new SubscriptionQuery();
        subscriptionQuery.setStatuses(Arrays.asList(SubscriptionStatus.ACCEPTED, SubscriptionStatus.PAUSED));
        subscriptionQuery.setApplications(ids);
        Set<String> ranking = this.subscriptionService.findReferenceIdsOrderByNumberOfSubscriptions(subscriptionQuery, order);
        ranking.addAll(ids);
        return ranking;
    }

    @Override
    public Collection<String> filterApis(ExecutionContext executionContext, Set<String> apis, FilteringService.FilterType filterType, FilteringService.FilterType excludedFilterType) {
        FilteringService.FilterType filter;
        if (apis == null || apis.isEmpty()) {
            return apis;
        }
        FilteringService.FilterType filterType2 = filter = excludedFilterType == null ? filterType : excludedFilterType;
        if (filter == null) {
            return apis;
        }
        boolean excluded = excludedFilterType != null;
        switch (filter) {
            case MINE: {
                if (this.isAuthenticated()) {
                    return this.getCurrentUserSubscribedApis(executionContext, apis, excluded);
                }
                return Collections.emptyList();
            }
            case STARRED: {
                if (this.ratingService.isEnabled(executionContext)) {
                    return this.getRatedApis(executionContext, apis, excluded);
                }
                return Collections.emptyList();
            }
            case TRENDINGS: {
                return this.getApisOrderByNumberOfSubscriptions(apis, excluded);
            }
            case FEATURED: {
                return this.getTopApis(executionContext, apis, excluded);
            }
        }
        return apis;
    }

    @Override
    public Collection<String> filterApis(ExecutionContext executionContext, String userId, FilteringService.FilterType filterType, FilteringService.FilterType excludedFilterType, ApiQuery apiQuery) {
        Set<String> apis = this.apiService.findPublishedIdsByUser(executionContext, userId, apiQuery);
        return this.filterApis(executionContext, apis, filterType, excludedFilterType);
    }

    @Override
    public Collection<String> searchApis(ExecutionContext executionContext, String userId, String query) throws TechnicalException {
        Set<String> apis = this.apiService.findPublishedIdsByUser(executionContext, userId);
        HashMap<String, Object> filters = new HashMap<String, Object>();
        filters.put("api", apis);
        return this.apiService.searchIds(executionContext, query, filters, null);
    }

    @Override
    public Set<CategoryEntity> listCategories(ExecutionContext executionContext, String userId, FilteringService.FilterType filterType, FilteringService.FilterType excludedFilterType) {
        Set<String> apisForUser = this.apiService.findPublishedIdsByUser(executionContext, userId);
        Collection<String> apis = this.filterApis(executionContext, apisForUser, filterType, excludedFilterType);
        return this.apiService.listCategories(apis, executionContext.getEnvironmentId());
    }

    private Collection<String> getTopApis(ExecutionContext executionContext, Set<String> apis, boolean excluded) {
        Map<String, Integer> topApiIdAndOrderMap = this.topApiService.findAll(executionContext).stream().collect(Collectors.toMap(TopApiEntity::getApi, TopApiEntity::getOrder));
        if (topApiIdAndOrderMap.isEmpty()) {
            if (excluded) {
                return apis;
            }
            return Collections.emptyList();
        }
        if (excluded) {
            return apis.stream().filter(api -> !topApiIdAndOrderMap.containsKey(api)).collect(Collectors.toList());
        }
        return apis.stream().filter(topApiIdAndOrderMap::containsKey).sorted(Comparator.comparing(topApiIdAndOrderMap::get)).collect(Collectors.toList());
    }

    private Collection<String> getRatedApis(ExecutionContext executionContext, Set<String> apis, boolean excluded) {
        Set<String> ratings = this.ratingService.findReferenceIdsOrderByRate(executionContext, apis);
        if (excluded) {
            apis.removeAll(ratings);
            return apis;
        }
        ratings.addAll(apis);
        return ratings;
    }

    private Collection<String> getCurrentUserSubscribedApis(ExecutionContext executionContext, Set<String> apis, boolean excluded) {
        Set<String> currentUserApplicationsId = this.applicationService.findIdsByUser(executionContext, this.getAuthenticatedUser().getUsername());
        SubscriptionQuery subscriptionQuery = new SubscriptionQuery();
        subscriptionQuery.setApplications(currentUserApplicationsId);
        List subscribedApis = this.subscriptionService.search(executionContext, subscriptionQuery).stream().map(SubscriptionEntity::getApi).distinct().collect(Collectors.toList());
        return apis.stream().filter(api -> !excluded && subscribedApis.contains(api) || excluded && !subscribedApis.contains(api)).collect(Collectors.toList());
    }
}

