/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade;

import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.OrganizationRepository;
import io.gravitee.repository.management.model.Organization;
import io.gravitee.rest.api.service.Upgrader;
import io.gravitee.rest.api.service.common.ExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;

public abstract class OrganizationUpgrader
implements Upgrader,
Ordered {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrganizationUpgrader.class);
    @Autowired
    private OrganizationRepository organizationRepository;

    protected abstract void upgradeOrganization(ExecutionContext var1);

    @Override
    public final boolean upgrade() {
        try {
            this.organizationRepository.findAll().forEach(organization -> {
                ExecutionContext executionContext = new ExecutionContext((Organization)organization);
                LOGGER.info("Starting {} for {}", (Object)this.getClass().getSimpleName(), (Object)executionContext);
                this.upgradeOrganization(executionContext);
            });
        }
        catch (TechnicalException e) {
            LOGGER.error("{} execution failed", (Object)this.getClass().getSimpleName(), (Object)e);
            return false;
        }
        return true;
    }
}

