/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.converter;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.common.component.Lifecycle;
import io.gravitee.definition.model.VirtualHost;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.LifecycleState;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.PropertiesEntity;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.api.ApiLifecycleState;
import io.gravitee.rest.api.model.api.UpdateApiEntity;
import io.gravitee.rest.api.service.common.GraviteeContext;
import java.io.IOException;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApiConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiConverter.class);
    @Autowired
    private ObjectMapper objectMapper;

    public ApiEntity toApiEntity(Api api, PrimaryOwnerEntity primaryOwnerEntity) {
        io.gravitee.repository.management.model.ApiLifecycleState lifecycleState;
        ApiEntity apiEntity = new ApiEntity();
        apiEntity.setId(api.getId());
        apiEntity.setCrossId(api.getCrossId());
        apiEntity.setEnvironmentId(api.getEnvironmentId());
        apiEntity.setName(api.getName());
        apiEntity.setDeployedAt(api.getDeployedAt());
        apiEntity.setCreatedAt(api.getCreatedAt());
        apiEntity.setGroups(api.getGroups());
        apiEntity.setDisableMembershipNotifications(api.isDisableMembershipNotifications());
        apiEntity.setReferenceType(GraviteeContext.ReferenceContextType.ENVIRONMENT.name());
        apiEntity.setReferenceId(api.getEnvironmentId());
        apiEntity.setCategories(api.getCategories());
        if (api.getDefinition() != null) {
            try {
                io.gravitee.definition.model.Api apiDefinition = (io.gravitee.definition.model.Api)this.objectMapper.readValue(api.getDefinition(), io.gravitee.definition.model.Api.class);
                apiEntity.setProxy(apiDefinition.getProxy());
                apiEntity.setPaths(apiDefinition.getPaths());
                apiEntity.setServices(apiDefinition.getServices());
                apiEntity.setResources(apiDefinition.getResources());
                apiEntity.setProperties(apiDefinition.getProperties());
                apiEntity.setTags(apiDefinition.getTags());
                if (apiDefinition.getDefinitionVersion() != null) {
                    apiEntity.setGraviteeDefinitionVersion(apiDefinition.getDefinitionVersion().getLabel());
                }
                if (apiDefinition.getExecutionMode() != null) {
                    apiEntity.setExecutionMode(apiDefinition.getExecutionMode());
                }
                if (apiDefinition.getFlowMode() != null) {
                    apiEntity.setFlowMode(apiDefinition.getFlowMode());
                }
                if (apiDefinition.getFlows() != null) {
                    apiEntity.setFlows(apiDefinition.getFlows());
                }
                if (apiDefinition.getProxy().getVirtualHosts() != null && !apiDefinition.getProxy().getVirtualHosts().isEmpty()) {
                    apiEntity.setContextPath(((VirtualHost)apiDefinition.getProxy().getVirtualHosts().get(0)).getPath());
                }
                if (apiDefinition.getPathMappings() != null) {
                    apiEntity.setPathMappings(new HashSet(apiDefinition.getPathMappings().keySet()));
                }
                apiEntity.setResponseTemplates(apiDefinition.getResponseTemplates());
            }
            catch (IOException ioe) {
                LOGGER.error("Unexpected error while generating API definition", (Throwable)ioe);
            }
        }
        apiEntity.setUpdatedAt(api.getUpdatedAt());
        apiEntity.setVersion(api.getVersion());
        apiEntity.setDescription(api.getDescription());
        apiEntity.setPicture(api.getPicture());
        apiEntity.setBackground(api.getBackground());
        apiEntity.setLabels(api.getLabels());
        LifecycleState state = api.getLifecycleState();
        if (state != null) {
            apiEntity.setState(Lifecycle.State.valueOf((String)state.name()));
        }
        if (api.getVisibility() != null) {
            apiEntity.setVisibility(Visibility.valueOf((String)api.getVisibility().toString()));
        }
        if ((lifecycleState = api.getApiLifecycleState()) != null) {
            apiEntity.setLifecycleState(ApiLifecycleState.valueOf((String)lifecycleState.name()));
        }
        if (primaryOwnerEntity != null) {
            apiEntity.setPrimaryOwner(primaryOwnerEntity);
        }
        return apiEntity;
    }

    public UpdateApiEntity toUpdateApiEntity(ApiEntity apiEntity) {
        return this.toUpdateApiEntity(apiEntity, false);
    }

    public UpdateApiEntity toUpdateApiEntity(ApiEntity apiEntity, boolean resetCrossId) {
        UpdateApiEntity updateApiEntity = new UpdateApiEntity();
        updateApiEntity.setCrossId(resetCrossId ? null : apiEntity.getCrossId());
        updateApiEntity.setProxy(apiEntity.getProxy());
        updateApiEntity.setVersion(apiEntity.getVersion());
        updateApiEntity.setName(apiEntity.getName());
        updateApiEntity.setProperties(new PropertiesEntity(apiEntity.getProperties()));
        updateApiEntity.setDescription(apiEntity.getDescription());
        updateApiEntity.setGroups(apiEntity.getGroups());
        updateApiEntity.setPaths(apiEntity.getPaths());
        updateApiEntity.setPicture(apiEntity.getPicture());
        updateApiEntity.setBackground(apiEntity.getBackground());
        updateApiEntity.setResources(apiEntity.getResources());
        updateApiEntity.setTags(apiEntity.getTags());
        updateApiEntity.setServices(apiEntity.getServices());
        updateApiEntity.setVisibility(apiEntity.getVisibility());
        updateApiEntity.setLabels(apiEntity.getLabels());
        updateApiEntity.setPathMappings(apiEntity.getPathMappings());
        updateApiEntity.setLifecycleState(apiEntity.getLifecycleState());
        updateApiEntity.setPlans(apiEntity.getPlans());
        updateApiEntity.setFlows(apiEntity.getFlows());
        updateApiEntity.setGraviteeDefinitionVersion(apiEntity.getGraviteeDefinitionVersion());
        updateApiEntity.setFlowMode(apiEntity.getFlowMode());
        updateApiEntity.setResponseTemplates(apiEntity.getResponseTemplates());
        updateApiEntity.setCategories(apiEntity.getCategories());
        updateApiEntity.setDisableMembershipNotifications(apiEntity.isDisableMembershipNotifications());
        return updateApiEntity;
    }
}

