/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.exceptions;

import io.gravitee.rest.api.model.InstallationEntity;
import io.gravitee.rest.api.model.InstallationStatus;
import io.gravitee.rest.api.service.exceptions.AbstractManagementException;
import java.util.HashMap;
import java.util.Map;

public class InstallationNotAcceptedException
extends AbstractManagementException {
    private final String installationId;
    private final Map<String, String> parameters = new HashMap<String, String>();

    public InstallationNotAcceptedException(InstallationEntity installationEntity, InstallationStatus status) {
        this.installationId = installationEntity.getId();
        this.parameters.put("installationId", installationEntity.getId());
        this.parameters.put("cockpitURL", installationEntity.getCockpitURL());
        this.parameters.put("status", status.name());
    }

    @Override
    public int getHttpStatusCode() {
        return 400;
    }

    @Override
    public String getMessage() {
        return "Installation [" + this.installationId + "] not accepted.";
    }

    @Override
    public String getTechnicalCode() {
        return "installation.notAccepted";
    }

    @Override
    public Map<String, String> getParameters() {
        return this.parameters;
    }
}

