/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Strings;
import io.gravitee.common.data.domain.Page;
import io.gravitee.common.util.DataEncryptor;
import io.gravitee.definition.model.Api;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.Endpoint;
import io.gravitee.definition.model.EndpointGroup;
import io.gravitee.definition.model.Logging;
import io.gravitee.definition.model.LoggingMode;
import io.gravitee.definition.model.Policy;
import io.gravitee.definition.model.Proxy;
import io.gravitee.definition.model.Rule;
import io.gravitee.definition.model.VirtualHost;
import io.gravitee.definition.model.flow.Flow;
import io.gravitee.definition.model.flow.Step;
import io.gravitee.definition.model.plugins.resources.Resource;
import io.gravitee.definition.model.services.discovery.EndpointDiscoveryService;
import io.gravitee.definition.model.services.healthcheck.HealthCheckService;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiQualityRuleRepository;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.api.search.ApiFieldFilter;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.ApiLifecycleState;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Event;
import io.gravitee.repository.management.model.GroupEvent;
import io.gravitee.repository.management.model.LifecycleState;
import io.gravitee.repository.management.model.NotificationReferenceType;
import io.gravitee.repository.management.model.Visibility;
import io.gravitee.repository.management.model.Workflow;
import io.gravitee.repository.management.model.flow.FlowReferenceType;
import io.gravitee.rest.api.model.ApiMetadataEntity;
import io.gravitee.rest.api.model.ApiModelEntity;
import io.gravitee.rest.api.model.CategoryEntity;
import io.gravitee.rest.api.model.EntrypointEntity;
import io.gravitee.rest.api.model.EventEntity;
import io.gravitee.rest.api.model.EventQuery;
import io.gravitee.rest.api.model.EventType;
import io.gravitee.rest.api.model.GroupEntity;
import io.gravitee.rest.api.model.GroupMemberEntity;
import io.gravitee.rest.api.model.ImportSwaggerDescriptorEntity;
import io.gravitee.rest.api.model.InlinePictureEntity;
import io.gravitee.rest.api.model.MemberEntity;
import io.gravitee.rest.api.model.MembershipEntity;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.MetadataFormat;
import io.gravitee.rest.api.model.NewApiMetadataEntity;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.PageType;
import io.gravitee.rest.api.model.PlanEntity;
import io.gravitee.rest.api.model.PlanStatus;
import io.gravitee.rest.api.model.PolicyEntity;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.PropertiesEntity;
import io.gravitee.rest.api.model.PropertyEntity;
import io.gravitee.rest.api.model.ProxyModelEntity;
import io.gravitee.rest.api.model.ReviewEntity;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.SubscriptionEntity;
import io.gravitee.rest.api.model.TagReferenceType;
import io.gravitee.rest.api.model.UpdateApiMetadataEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.WorkflowReferenceType;
import io.gravitee.rest.api.model.WorkflowState;
import io.gravitee.rest.api.model.WorkflowType;
import io.gravitee.rest.api.model.alert.AlertReferenceType;
import io.gravitee.rest.api.model.alert.AlertTriggerEntity;
import io.gravitee.rest.api.model.api.ApiDeploymentEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.api.ApiEntrypointEntity;
import io.gravitee.rest.api.model.api.ApiQuery;
import io.gravitee.rest.api.model.api.NewApiEntity;
import io.gravitee.rest.api.model.api.RollbackApiEntity;
import io.gravitee.rest.api.model.api.SwaggerApiEntity;
import io.gravitee.rest.api.model.api.UpdateApiEntity;
import io.gravitee.rest.api.model.api.header.ApiHeaderEntity;
import io.gravitee.rest.api.model.application.ApplicationListItem;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.PageableImpl;
import io.gravitee.rest.api.model.common.Sortable;
import io.gravitee.rest.api.model.notification.GenericNotificationConfigEntity;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.model.permissions.ApiPermission;
import io.gravitee.rest.api.model.permissions.Permission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.model.search.Indexable;
import io.gravitee.rest.api.model.settings.ApiPrimaryOwnerMode;
import io.gravitee.rest.api.model.subscription.SubscriptionQuery;
import io.gravitee.rest.api.service.AlertService;
import io.gravitee.rest.api.service.ApiDuplicatorService;
import io.gravitee.rest.api.service.ApiHeaderService;
import io.gravitee.rest.api.service.ApiMetadataService;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.CategoryService;
import io.gravitee.rest.api.service.ConnectorService;
import io.gravitee.rest.api.service.EmailService;
import io.gravitee.rest.api.service.EntrypointService;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.EventService;
import io.gravitee.rest.api.service.GenericNotificationConfigService;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.HttpClientService;
import io.gravitee.rest.api.service.JupiterModeService;
import io.gravitee.rest.api.service.MediaService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.NotifierService;
import io.gravitee.rest.api.service.PageService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.PlanService;
import io.gravitee.rest.api.service.PolicyService;
import io.gravitee.rest.api.service.PortalNotificationConfigService;
import io.gravitee.rest.api.service.ResourceService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.SubscriptionService;
import io.gravitee.rest.api.service.SwaggerService;
import io.gravitee.rest.api.service.TagService;
import io.gravitee.rest.api.service.TopApiService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.VirtualHostService;
import io.gravitee.rest.api.service.WorkflowService;
import io.gravitee.rest.api.service.builder.EmailNotificationBuilder;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.TimeBoundedCharSequence;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.configuration.flow.FlowService;
import io.gravitee.rest.api.service.converter.ApiConverter;
import io.gravitee.rest.api.service.exceptions.AllowOriginNotAllowedException;
import io.gravitee.rest.api.service.exceptions.ApiAlreadyExistsException;
import io.gravitee.rest.api.service.exceptions.ApiMetadataNotFoundException;
import io.gravitee.rest.api.service.exceptions.ApiNotDeletableException;
import io.gravitee.rest.api.service.exceptions.ApiNotFoundException;
import io.gravitee.rest.api.service.exceptions.ApiRunningStateException;
import io.gravitee.rest.api.service.exceptions.DefinitionVersionException;
import io.gravitee.rest.api.service.exceptions.EndpointMissingException;
import io.gravitee.rest.api.service.exceptions.EndpointNameInvalidException;
import io.gravitee.rest.api.service.exceptions.GroupNotFoundException;
import io.gravitee.rest.api.service.exceptions.GroupsNotFoundException;
import io.gravitee.rest.api.service.exceptions.HealthcheckInheritanceException;
import io.gravitee.rest.api.service.exceptions.InvalidDataException;
import io.gravitee.rest.api.service.exceptions.LifecycleStateChangeNotAllowedException;
import io.gravitee.rest.api.service.exceptions.NoPrimaryOwnerGroupForUserException;
import io.gravitee.rest.api.service.exceptions.PaginationInvalidException;
import io.gravitee.rest.api.service.exceptions.PrimaryOwnerNotFoundException;
import io.gravitee.rest.api.service.exceptions.RoleNotFoundException;
import io.gravitee.rest.api.service.exceptions.TagNotAllowedException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.exceptions.UserNotFoundException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.impl.search.SearchResult;
import io.gravitee.rest.api.service.jackson.ser.api.ApiSerializer;
import io.gravitee.rest.api.service.migration.APIV1toAPIV2Converter;
import io.gravitee.rest.api.service.notification.ApiHook;
import io.gravitee.rest.api.service.notification.HookScope;
import io.gravitee.rest.api.service.notification.NotificationParamsBuilder;
import io.gravitee.rest.api.service.notification.NotificationTemplateService;
import io.gravitee.rest.api.service.processor.ApiSynchronizationProcessor;
import io.gravitee.rest.api.service.search.SearchEngineService;
import io.gravitee.rest.api.service.search.query.Query;
import io.gravitee.rest.api.service.search.query.QueryBuilder;
import io.gravitee.rest.api.service.spring.ImportConfiguration;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Component;

@Component
public class ApiServiceImpl
extends AbstractService
implements ApiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiServiceImpl.class);
    private static final Pattern DUPLICATE_SLASH_REMOVER = Pattern.compile("(?<!(http:|https:))[//]+");
    private static final Pattern CORS_REGEX_PATTERN = Pattern.compile("^((\\*)|(null)|(^(([^:\\/?#]+):)?(\\/\\/([^\\/?#]*))?))$");
    private static final String[] CORS_REGEX_CHARS = new String[]{"{", "[", "(", "*"};
    private static final String URI_PATH_SEPARATOR = "/";
    @Autowired
    private ApiRepository apiRepository;
    @Autowired
    private ApiQualityRuleRepository apiQualityRuleRepository;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private EventService eventService;
    @Autowired
    private UserService userService;
    @Autowired
    private PageService pageService;
    @Autowired
    private MembershipService membershipService;
    @Autowired
    private GroupService groupService;
    @Autowired
    private PlanService planService;
    @Autowired
    private ApiSynchronizationProcessor apiSynchronizationProcessor;
    @Autowired
    private ApiMetadataService apiMetadataService;
    @Autowired
    private SubscriptionService subscriptionService;
    @Autowired
    private AuditService auditService;
    @Autowired
    private TopApiService topApiService;
    @Autowired
    private GenericNotificationConfigService genericNotificationConfigService;
    @Autowired
    private PortalNotificationConfigService portalNotificationConfigService;
    @Autowired
    private NotifierService notifierService;
    @Autowired
    private SwaggerService swaggerService;
    @Autowired
    private SearchEngineService searchEngineService;
    @Autowired
    private ApiHeaderService apiHeaderService;
    @Autowired
    private NotificationTemplateService notificationTemplateService;
    @Autowired
    private ParameterService parameterService;
    @Autowired
    private TagService tagService;
    @Autowired
    private EntrypointService entrypointService;
    @Autowired
    private WorkflowService workflowService;
    @Autowired
    private HttpClientService httpClientService;
    @Autowired
    private VirtualHostService virtualHostService;
    @Autowired
    private AlertService alertService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private CategoryService categoryService;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private ImportConfiguration importConfiguration;
    @Autowired
    private PolicyService policyService;
    @Autowired
    private MediaService mediaService;
    @Autowired
    private EmailService emailService;
    @Autowired
    private APIV1toAPIV2Converter apiv1toAPIV2Converter;
    @Autowired
    private DataEncryptor dataEncryptor;
    @Autowired
    private ApiDuplicatorService apiDuplicatorService;
    @Autowired
    private ConnectorService connectorService;
    @Autowired
    private EnvironmentService environmentService;
    @Autowired
    private ApiConverter apiConverter;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private FlowService flowService;
    @Autowired
    private JupiterModeService jupiterModeService;
    @Value(value="${configuration.default-api-icon:}")
    private String defaultApiIcon;
    private static final Pattern LOGGING_MAX_DURATION_PATTERN = Pattern.compile("(?<before>.*)\\#request.timestamp\\s*\\<\\=?\\s*(?<timestamp>\\d*)l(?<after>.*)");
    private static final String LOGGING_MAX_DURATION_CONDITION = "#request.timestamp <= %dl";
    private static final String LOGGING_DELIMITER_BASE = "\\s+(\\|\\||\\&\\&)\\s+";
    private static final String ENDPOINTS_DELIMITER = "\n";
    private static final Duration REGEX_TIMEOUT = Duration.ofSeconds(2L);

    @Override
    public ApiEntity createFromSwagger(ExecutionContext executionContext, SwaggerApiEntity swaggerApiEntity, String userId, ImportSwaggerDescriptorEntity swaggerDescriptor) throws ApiAlreadyExistsException {
        ApiEntity createdApi = this.createFromUpdateApiEntity(executionContext, (UpdateApiEntity)swaggerApiEntity, userId, swaggerDescriptor);
        this.apiMetadataService.create(executionContext, swaggerApiEntity.getMetadata(), createdApi.getId());
        return createdApi;
    }

    private void checkGroupExistence(Set<String> groups) {
        if (groups != null && !groups.isEmpty()) {
            try {
                this.groupService.findByIds(new HashSet<String>(groups));
            }
            catch (GroupsNotFoundException gnfe) {
                throw new InvalidDataException("These groups [" + gnfe.getParameters().get("groups") + "] do not exist");
            }
        }
    }

    private Set<String> removePOGroups(ExecutionContext executionContext, Set<String> groups, String apiId) {
        MembershipEntity primaryOwner;
        Stream<Object> groupEntityStream = this.groupService.findByIds(groups).stream();
        groupEntityStream = apiId != null ? ((primaryOwner = this.membershipService.getPrimaryOwner(executionContext.getOrganizationId(), MembershipReferenceType.API, apiId)).getMemberType() == MembershipMemberType.GROUP ? groupEntityStream.filter(group -> StringUtils.isEmpty((CharSequence)group.getApiPrimaryOwner()) || group.getId().equals(primaryOwner.getMemberId())) : groupEntityStream.filter(group -> StringUtils.isEmpty((CharSequence)group.getApiPrimaryOwner()))) : groupEntityStream.filter(group -> StringUtils.isEmpty((CharSequence)group.getApiPrimaryOwner()));
        return groupEntityStream.map(GroupEntity::getId).collect(Collectors.toSet());
    }

    @Override
    public ApiEntity create(ExecutionContext executionContext, NewApiEntity newApiEntity, String userId) throws ApiAlreadyExistsException {
        List declaredPaths;
        UpdateApiEntity apiEntity = new UpdateApiEntity();
        apiEntity.setName(newApiEntity.getName());
        apiEntity.setDescription(newApiEntity.getDescription());
        apiEntity.setVersion(newApiEntity.getVersion());
        apiEntity.setGraviteeDefinitionVersion(newApiEntity.getGraviteeDefinitionVersion());
        apiEntity.setFlows(newApiEntity.getFlows());
        apiEntity.setFlowMode(newApiEntity.getFlowMode());
        Set<String> groups = newApiEntity.getGroups();
        if (groups != null && !groups.isEmpty()) {
            this.checkGroupExistence(groups);
            groups = this.removePOGroups(executionContext, groups, null);
            newApiEntity.setGroups(groups);
        }
        apiEntity.setGroups((Set)groups);
        Proxy proxy = new Proxy();
        proxy.setVirtualHosts(Collections.singletonList(new VirtualHost(newApiEntity.getContextPath())));
        EndpointGroup group = new EndpointGroup();
        group.setName("default-group");
        String[] endpoints = null;
        if (newApiEntity.getEndpoint() != null) {
            endpoints = newApiEntity.getEndpoint().split(ENDPOINTS_DELIMITER);
        }
        if (endpoints == null) {
            group.setEndpoints(Collections.singleton(new Endpoint("default", null)));
        } else if (endpoints.length == 1) {
            group.setEndpoints(Collections.singleton(new Endpoint("default", endpoints[0])));
        } else {
            group.setEndpoints(new HashSet());
            for (int i = 0; i < endpoints.length; ++i) {
                group.getEndpoints().add(new Endpoint("server" + (i + 1), endpoints[i]));
            }
        }
        proxy.setGroups(Collections.singleton(group));
        apiEntity.setProxy(proxy);
        List list = declaredPaths = newApiEntity.getPaths() != null ? newApiEntity.getPaths() : new ArrayList();
        if (!declaredPaths.contains(URI_PATH_SEPARATOR)) {
            declaredPaths.add(0, URI_PATH_SEPARATOR);
        }
        apiEntity.setPathMappings(new HashSet(declaredPaths));
        return this.createFromUpdateApiEntity(executionContext, apiEntity, userId, null);
    }

    @Override
    public ApiEntity createWithApiDefinition(ExecutionContext executionContext, UpdateApiEntity api, String userId, JsonNode apiDefinition) throws ApiAlreadyExistsException {
        try {
            LOGGER.debug("Create {} for user {}", (Object)api, (Object)userId);
            String apiId = apiDefinition != null && apiDefinition.has("id") ? apiDefinition.get("id").asText() : null;
            String id = apiId != null && UUID.fromString(apiId) != null ? apiId : UuidString.generateRandom();
            Optional checkApi = this.apiRepository.findById((Object)id);
            if (checkApi.isPresent()) {
                throw new ApiAlreadyExistsException(id);
            }
            this.checkShardingTags(api, null, executionContext);
            Collection<VirtualHost> sanitizedVirtualHosts = this.virtualHostService.sanitizeAndValidate(executionContext, api.getProxy().getVirtualHosts());
            api.getProxy().setVirtualHosts(new ArrayList<VirtualHost>(sanitizedVirtualHosts));
            this.checkEndpointsConfiguration(api);
            this.checkHealthcheckInheritance(api);
            this.addLoggingMaxDuration(executionContext, api.getProxy().getLogging());
            this.validateRegexfields(api);
            this.checkPolicyConfigurations(api);
            this.checkResourceConfigurations(api);
            PrimaryOwnerEntity primaryOwner = this.findPrimaryOwner(executionContext, apiDefinition, userId);
            if (apiDefinition != null) {
                apiDefinition = ((ObjectNode)apiDefinition).put("id", id);
            }
            if (api.getExecutionMode() == null) {
                api.setExecutionMode(this.jupiterModeService.getExecutionModeFor(apiDefinition));
            }
            io.gravitee.repository.management.model.Api repoApi = this.convert(executionContext, id, api, apiDefinition != null ? apiDefinition.toString() : null);
            repoApi.setId(id);
            repoApi.setEnvironmentId(executionContext.getEnvironmentId());
            repoApi.setCreatedAt(new Date());
            repoApi.setUpdatedAt(repoApi.getCreatedAt());
            repoApi.setLifecycleState(LifecycleState.STOPPED);
            repoApi.setVisibility(api.getVisibility() == null ? Visibility.PRIVATE : Visibility.valueOf((String)api.getVisibility().toString()));
            Set defaultGroups = this.groupService.findByEvent(executionContext.getEnvironmentId(), GroupEvent.API_CREATE).stream().map(GroupEntity::getId).collect(Collectors.toSet());
            if (repoApi.getGroups() == null) {
                repoApi.setGroups(defaultGroups.isEmpty() ? null : defaultGroups);
            } else {
                repoApi.getGroups().addAll(defaultGroups);
            }
            if (ApiPrimaryOwnerMode.GROUP.name().equals(primaryOwner.getType())) {
                if (repoApi.getGroups() == null) {
                    repoApi.setGroups(new HashSet());
                }
                repoApi.getGroups().add(primaryOwner.getId());
            }
            repoApi.setApiLifecycleState(ApiLifecycleState.CREATED);
            if (this.parameterService.findAsBoolean(executionContext, Key.API_REVIEW_ENABLED, ParameterReferenceType.ENVIRONMENT)) {
                this.workflowService.create(WorkflowReferenceType.API, id, WorkflowType.REVIEW, userId, WorkflowState.DRAFT, "");
            }
            io.gravitee.repository.management.model.Api createdApi = (io.gravitee.repository.management.model.Api)this.apiRepository.create((Object)repoApi);
            this.auditService.createApiAuditLog(executionContext, createdApi.getId(), Collections.emptyMap(), (Audit.AuditEvent)Api.AuditEvent.API_CREATED, createdApi.getCreatedAt(), null, createdApi);
            this.membershipService.addRoleToMemberOnReference(executionContext, new MembershipService.MembershipReference(MembershipReferenceType.API, createdApi.getId()), new MembershipService.MembershipMember(primaryOwner.getId(), null, MembershipMemberType.valueOf((String)primaryOwner.getType())), new MembershipService.MembershipRole(RoleScope.API, SystemRole.PRIMARY_OWNER.name()));
            String emailMetadataValue = "${(api.primaryOwner.email)!''}";
            GenericNotificationConfigEntity notificationConfigEntity = new GenericNotificationConfigEntity();
            notificationConfigEntity.setName("Default Mail Notifications");
            notificationConfigEntity.setReferenceType(HookScope.API.name());
            notificationConfigEntity.setReferenceId(createdApi.getId());
            notificationConfigEntity.setHooks(Arrays.stream(ApiHook.values()).map(Enum::name).collect(Collectors.toList()));
            notificationConfigEntity.setNotifier("default-email");
            notificationConfigEntity.setConfig("${(api.primaryOwner.email)!''}");
            this.genericNotificationConfigService.create(notificationConfigEntity);
            NewApiMetadataEntity newApiMetadataEntity = new NewApiMetadataEntity();
            newApiMetadataEntity.setFormat(MetadataFormat.MAIL);
            newApiMetadataEntity.setName("email-support");
            newApiMetadataEntity.setDefaultValue("${(api.primaryOwner.email)!''}");
            newApiMetadataEntity.setValue("${(api.primaryOwner.email)!''}");
            newApiMetadataEntity.setApiId(createdApi.getId());
            this.apiMetadataService.create(executionContext, newApiMetadataEntity);
            this.flowService.save(FlowReferenceType.API, createdApi.getId(), api.getFlows());
            ApiEntity apiEntity = this.convert(executionContext, createdApi, primaryOwner, null);
            ApiEntity apiWithMetadata = this.fetchMetadataForApi(executionContext, apiEntity);
            this.searchEngineService.index(executionContext, (Indexable)apiWithMetadata, false);
            return apiEntity;
        }
        catch (TechnicalException | IllegalStateException ex) {
            LOGGER.error("An error occurs while trying to create {} for user {}", new Object[]{api, userId, ex});
            throw new TechnicalManagementException("An error occurs while trying create " + api + " for user " + userId, ex);
        }
    }

    private ApiEntity createFromUpdateApiEntity(ExecutionContext executionContext, UpdateApiEntity apiEntity, String userId, ImportSwaggerDescriptorEntity swaggerDescriptor) {
        ApiEntity createdApi = this.createWithApiDefinition(executionContext, apiEntity, userId, null);
        this.pageService.createAsideFolder(executionContext, createdApi.getId());
        this.pageService.createOrUpdateSwaggerPage(executionContext, createdApi.getId(), swaggerDescriptor, true);
        return createdApi;
    }

    public PrimaryOwnerEntity findPrimaryOwner(ExecutionContext executionContext, JsonNode apiDefinition, String userId) {
        ApiPrimaryOwnerMode poMode = ApiPrimaryOwnerMode.valueOf((String)this.parameterService.find(executionContext, Key.API_PRIMARY_OWNER_MODE, ParameterReferenceType.ENVIRONMENT));
        PrimaryOwnerEntity primaryOwnerFromDefinition = this.findPrimaryOwnerFromApiDefinition(apiDefinition);
        switch (poMode) {
            case USER: {
                if (primaryOwnerFromDefinition == null || ApiPrimaryOwnerMode.GROUP.name().equals(primaryOwnerFromDefinition.getType())) {
                    return new PrimaryOwnerEntity(this.userService.findById(executionContext, userId));
                }
                if (!ApiPrimaryOwnerMode.USER.name().equals(primaryOwnerFromDefinition.getType())) break;
                try {
                    return new PrimaryOwnerEntity(this.userService.findById(executionContext, primaryOwnerFromDefinition.getId()));
                }
                catch (UserNotFoundException unfe) {
                    return new PrimaryOwnerEntity(this.userService.findById(executionContext, userId));
                }
            }
            case GROUP: {
                if (primaryOwnerFromDefinition == null) {
                    return this.getFirstPoGroupUserBelongsTo(userId);
                }
                if (ApiPrimaryOwnerMode.GROUP.name().equals(primaryOwnerFromDefinition.getType())) {
                    try {
                        return new PrimaryOwnerEntity(this.groupService.findById(executionContext, primaryOwnerFromDefinition.getId()));
                    }
                    catch (GroupNotFoundException unfe) {
                        return this.getFirstPoGroupUserBelongsTo(userId);
                    }
                }
                if (!ApiPrimaryOwnerMode.USER.name().equals(primaryOwnerFromDefinition.getType())) break;
                try {
                    String poUserId = primaryOwnerFromDefinition.getId();
                    this.userService.findById(executionContext, poUserId);
                    Set poGroupsOfPoUser = this.groupService.findByUser(poUserId).stream().filter(group -> group.getApiPrimaryOwner() != null && !group.getApiPrimaryOwner().isEmpty()).collect(Collectors.toSet());
                    if (poGroupsOfPoUser.isEmpty()) {
                        return this.getFirstPoGroupUserBelongsTo(userId);
                    }
                    return new PrimaryOwnerEntity((GroupEntity)poGroupsOfPoUser.iterator().next());
                }
                catch (UserNotFoundException unfe) {
                    return this.getFirstPoGroupUserBelongsTo(userId);
                }
            }
            default: {
                if (primaryOwnerFromDefinition == null) {
                    return new PrimaryOwnerEntity(this.userService.findById(executionContext, userId));
                }
                if (ApiPrimaryOwnerMode.GROUP.name().equals(primaryOwnerFromDefinition.getType())) {
                    try {
                        return new PrimaryOwnerEntity(this.groupService.findById(executionContext, primaryOwnerFromDefinition.getId()));
                    }
                    catch (GroupNotFoundException unfe) {
                        try {
                            return this.getFirstPoGroupUserBelongsTo(userId);
                        }
                        catch (NoPrimaryOwnerGroupForUserException ex) {
                            return new PrimaryOwnerEntity(this.userService.findById(executionContext, userId));
                        }
                    }
                }
                if (!ApiPrimaryOwnerMode.USER.name().equals(primaryOwnerFromDefinition.getType())) break;
                try {
                    return new PrimaryOwnerEntity(this.userService.findById(executionContext, primaryOwnerFromDefinition.getId()));
                }
                catch (UserNotFoundException unfe) {
                    return new PrimaryOwnerEntity(this.userService.findById(executionContext, userId));
                }
            }
        }
        return new PrimaryOwnerEntity(this.userService.findById(executionContext, userId));
    }

    @NotNull
    private PrimaryOwnerEntity getFirstPoGroupUserBelongsTo(String userId) {
        Set poGroupsOfCurrentUser = this.groupService.findByUser(userId).stream().filter(group -> !StringUtils.isEmpty((CharSequence)group.getApiPrimaryOwner())).collect(Collectors.toSet());
        if (poGroupsOfCurrentUser.isEmpty()) {
            throw new NoPrimaryOwnerGroupForUserException(userId);
        }
        return new PrimaryOwnerEntity((GroupEntity)poGroupsOfCurrentUser.iterator().next());
    }

    private PrimaryOwnerEntity findPrimaryOwnerFromApiDefinition(JsonNode apiDefinition) {
        PrimaryOwnerEntity primaryOwnerEntity = null;
        if (apiDefinition != null && apiDefinition.has("primaryOwner")) {
            try {
                primaryOwnerEntity = (PrimaryOwnerEntity)this.objectMapper.readValue(apiDefinition.get("primaryOwner").toString(), PrimaryOwnerEntity.class);
            }
            catch (JsonProcessingException e) {
                LOGGER.warn("Cannot parse primary owner from definition, continue with current user", (Throwable)e);
            }
        }
        return primaryOwnerEntity;
    }

    private void checkEndpointsConfiguration(UpdateApiEntity api) {
        if (api.getProxy() != null && api.getProxy().getGroups() != null) {
            for (EndpointGroup group : api.getProxy().getGroups()) {
                this.assertEndpointNameNotContainsInvalidCharacters(group.getName());
                if (group.getEndpoints() == null) continue;
                for (Endpoint endpoint : group.getEndpoints()) {
                    this.assertEndpointNameNotContainsInvalidCharacters(endpoint.getName());
                    endpoint.setConfiguration(this.connectorService.validateConnectorConfiguration(endpoint.getType(), endpoint.getConfiguration()));
                }
            }
        }
    }

    private void checkEndpointsExists(UpdateApiEntity api) {
        EndpointDiscoveryService endpointDiscoveryService;
        if (api.getProxy().getGroups() == null || api.getProxy().getGroups().isEmpty()) {
            throw new EndpointMissingException();
        }
        EndpointGroup endpointGroup = (EndpointGroup)api.getProxy().getGroups().iterator().next();
        EndpointDiscoveryService endpointDiscoveryService2 = endpointDiscoveryService = endpointGroup.getServices() == null ? null : (EndpointDiscoveryService)endpointGroup.getServices().get(EndpointDiscoveryService.class);
        if (!(endpointDiscoveryService != null && endpointDiscoveryService.isEnabled() || endpointGroup.getEndpoints() != null && !endpointGroup.getEndpoints().isEmpty())) {
            throw new EndpointMissingException();
        }
    }

    private void validateHealtcheckSchedule(UpdateApiEntity api) {
        String schedule;
        HealthCheckService healthCheckService;
        if (api.getServices() != null && (healthCheckService = (HealthCheckService)api.getServices().get(HealthCheckService.class)) != null && (schedule = healthCheckService.getSchedule()) != null) {
            try {
                new CronTrigger(schedule);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidDataException(e);
            }
        }
    }

    private void checkHealthcheckInheritance(UpdateApiEntity api) {
        boolean inherit = false;
        if (api.getProxy() != null && api.getProxy().getGroups() != null) {
            block0: for (EndpointGroup group : api.getProxy().getGroups()) {
                if (group.getEndpoints() == null) continue;
                for (Endpoint endpoint : group.getEndpoints()) {
                    if (!this.isHttpEndpoint(endpoint) || endpoint.getHealthCheck() == null || !endpoint.getHealthCheck().isInherit()) continue;
                    inherit = true;
                    continue block0;
                }
            }
        }
        if (inherit) {
            boolean hcServiceExists = false;
            if (api.getServices() != null) {
                HealthCheckService healthCheckService = (HealthCheckService)api.getServices().get(HealthCheckService.class);
                boolean bl = hcServiceExists = healthCheckService != null;
            }
            if (!hcServiceExists) {
                throw new HealthcheckInheritanceException();
            }
        }
    }

    private boolean isHttpEndpoint(Endpoint endpoint) {
        return "grpc".equalsIgnoreCase(endpoint.getType()) || "http".equalsIgnoreCase(endpoint.getType());
    }

    private void assertEndpointNameNotContainsInvalidCharacters(String name) {
        if (name != null && name.contains(":")) {
            throw new EndpointNameInvalidException(name);
        }
    }

    private void addLoggingMaxDuration(ExecutionContext executionContext, Logging logging) {
        Optional optionalMaxDuration;
        if (logging != null && !LoggingMode.NONE.equals((Object)logging.getMode()) && (optionalMaxDuration = this.parameterService.findAll(executionContext, Key.LOGGING_DEFAULT_MAX_DURATION, Long::valueOf, ParameterReferenceType.ORGANIZATION).stream().findFirst()).isPresent() && (Long)optionalMaxDuration.get() > 0L) {
            long maxEndDate = System.currentTimeMillis() + (Long)optionalMaxDuration.get();
            if (logging.getCondition() == null || logging.getCondition().isEmpty()) {
                logging.setCondition("{" + String.format(LOGGING_MAX_DURATION_CONDITION, maxEndDate) + "}");
            } else {
                String conditionWithoutBraces = logging.getCondition().trim().replaceAll("\\{", "").replaceAll("\\}", "");
                Matcher matcher = LOGGING_MAX_DURATION_PATTERN.matcher(new TimeBoundedCharSequence(conditionWithoutBraces, REGEX_TIMEOUT));
                if (matcher.matches()) {
                    String currentDurationAsStr = matcher.group("timestamp");
                    String before = this.formatExpression(matcher, "before");
                    String after = this.formatExpression(matcher, "after");
                    try {
                        long currentDuration = Long.parseLong(currentDurationAsStr);
                        if (currentDuration > maxEndDate || !before.isEmpty() || !after.isEmpty()) {
                            logging.setCondition("{" + before + String.format(LOGGING_MAX_DURATION_CONDITION, maxEndDate) + after + "}");
                        }
                    }
                    catch (NumberFormatException nfe) {
                        LOGGER.error("Wrong format of the logging condition. Add the default one", (Throwable)nfe);
                        logging.setCondition("{" + before + String.format(LOGGING_MAX_DURATION_CONDITION, maxEndDate) + after + "}");
                    }
                } else {
                    logging.setCondition("{" + String.format(LOGGING_MAX_DURATION_CONDITION, maxEndDate) + " && (" + conditionWithoutBraces + ")}");
                }
            }
        }
    }

    private String formatExpression(Matcher matcher, String group) {
        Object expression;
        String matchedExpression = Optional.ofNullable(matcher.group(group)).orElse("");
        boolean expressionBlank = "".equals(matchedExpression);
        boolean after = "after".equals(group);
        if (after) {
            if (matchedExpression.startsWith(" && (") && matchedExpression.endsWith(")")) {
                matchedExpression = matchedExpression.substring(5, matchedExpression.length() - 1);
            }
            expression = expressionBlank ? "" : " && (" + matchedExpression + ")";
            expression = ((String)expression).replaceAll("\\(\\s+(\\|\\||\\&\\&)\\s+", "\\(");
        } else {
            if (matchedExpression.startsWith("(") && matchedExpression.endsWith(") && ")) {
                matchedExpression = matchedExpression.substring(1, matchedExpression.length() - 5);
            }
            expression = expressionBlank ? "" : "(" + matchedExpression + ") && ";
            expression = ((String)expression).replaceAll("\\s+(\\|\\||\\&\\&)\\s+\\)", "\\)");
        }
        return expression;
    }

    @Override
    public ApiEntity findById(ExecutionContext executionContext, String apiId) {
        io.gravitee.repository.management.model.Api api = this.findApiById(executionContext, apiId);
        ApiEntity apiEntity = this.convert(executionContext, api, this.getPrimaryOwner(executionContext, api), null);
        this.calculateEntrypoints(executionContext, apiEntity);
        return apiEntity;
    }

    @Override
    public Optional<ApiEntity> findByEnvironmentIdAndCrossId(String environment, String crossId) {
        try {
            return this.apiRepository.findByEnvironmentIdAndCrossId(environment, crossId).map(api -> this.apiConverter.toApiEntity((io.gravitee.repository.management.model.Api)api, null));
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("An error occurred while finding API by environment " + environment + " and crossId " + crossId, e);
        }
    }

    @Override
    public PrimaryOwnerEntity getPrimaryOwner(ExecutionContext executionContext, String apiId) throws TechnicalManagementException {
        MembershipEntity primaryOwnerMemberEntity = this.membershipService.getPrimaryOwner(executionContext.getOrganizationId(), MembershipReferenceType.API, apiId);
        if (primaryOwnerMemberEntity == null) {
            throw new PrimaryOwnerNotFoundException(apiId);
        }
        if (MembershipMemberType.GROUP == primaryOwnerMemberEntity.getMemberType()) {
            return new PrimaryOwnerEntity(this.groupService.findById(executionContext, primaryOwnerMemberEntity.getMemberId()));
        }
        return new PrimaryOwnerEntity(this.userService.findById(executionContext, primaryOwnerMemberEntity.getMemberId()));
    }

    private PrimaryOwnerEntity getPrimaryOwner(ExecutionContext executionContext, io.gravitee.repository.management.model.Api api) throws TechnicalManagementException {
        return this.getPrimaryOwner(executionContext, api.getId());
    }

    @Override
    public void calculateEntrypoints(ExecutionContext executionContext, ApiEntity api) {
        ArrayList apiEntrypoints = new ArrayList();
        if (api.getProxy() != null) {
            String defaultEntrypoint = this.parameterService.find(executionContext, Key.PORTAL_ENTRYPOINT, executionContext.getEnvironmentId(), ParameterReferenceType.ENVIRONMENT);
            String scheme = this.getScheme(defaultEntrypoint);
            if (api.getTags() != null && !api.getTags().isEmpty()) {
                List<EntrypointEntity> entrypoints = this.entrypointService.findAll(executionContext);
                entrypoints.forEach(entrypoint -> {
                    HashSet<String> tagEntrypoints = new HashSet<String>(Arrays.asList(entrypoint.getTags()));
                    tagEntrypoints.retainAll(api.getTags());
                    if (tagEntrypoints.size() == entrypoint.getTags().length) {
                        api.getProxy().getVirtualHosts().forEach(virtualHost -> {
                            Object targetHost;
                            Object object = targetHost = virtualHost.getHost() == null || !virtualHost.isOverrideEntrypoint() ? entrypoint.getValue() : virtualHost.getHost();
                            if (!((String)targetHost).toLowerCase().startsWith("http")) {
                                targetHost = scheme + "://" + (String)targetHost;
                            }
                            apiEntrypoints.add(new ApiEntrypointEntity(tagEntrypoints, DUPLICATE_SLASH_REMOVER.matcher((String)targetHost + URI_PATH_SEPARATOR + virtualHost.getPath()).replaceAll(URI_PATH_SEPARATOR), virtualHost.getHost()));
                        });
                    }
                });
            }
            if (apiEntrypoints.isEmpty()) {
                api.getProxy().getVirtualHosts().forEach(virtualHost -> {
                    Object targetHost;
                    Object object = targetHost = virtualHost.getHost() == null || !virtualHost.isOverrideEntrypoint() ? defaultEntrypoint : virtualHost.getHost();
                    if (!((String)targetHost).toLowerCase().startsWith("http")) {
                        targetHost = scheme + "://" + (String)targetHost;
                    }
                    apiEntrypoints.add(new ApiEntrypointEntity(DUPLICATE_SLASH_REMOVER.matcher((String)targetHost + URI_PATH_SEPARATOR + virtualHost.getPath()).replaceAll(URI_PATH_SEPARATOR), virtualHost.getHost()));
                });
            }
        }
        api.setEntrypoints(apiEntrypoints);
    }

    @Override
    public Map<String, Object> findByIdAsMap(String id) throws TechnicalException {
        io.gravitee.repository.management.model.Api api = (io.gravitee.repository.management.model.Api)this.apiRepository.findById((Object)id).orElseThrow(() -> new ApiNotFoundException(id));
        ExecutionContext executionContext = new ExecutionContext(this.environmentService.findById(api.getEnvironmentId()));
        ApiEntity apiEntity = this.convert(executionContext, api, this.getPrimaryOwner(executionContext, api), null);
        Map dataAsMap = (Map)this.objectMapper.convertValue((Object)apiEntity, Map.class);
        dataAsMap.put("id", id);
        dataAsMap.put("primaryOwner", this.objectMapper.convertValue((Object)apiEntity.getPrimaryOwner(), Map.class));
        dataAsMap.remove("picture");
        dataAsMap.remove("proxy");
        dataAsMap.remove("paths");
        dataAsMap.remove("properties");
        dataAsMap.remove("services");
        dataAsMap.remove("resources");
        dataAsMap.remove("response_templates");
        dataAsMap.remove("path_mappings");
        List<ApiMetadataEntity> metadataList = this.apiMetadataService.findAllByApi(id);
        HashMap mapMetadata = new HashMap(metadataList.size());
        metadataList.forEach(m -> mapMetadata.put(m.getKey(), m.getValue() == null ? m.getDefaultValue() : m.getValue()));
        dataAsMap.put("metadata", this.objectMapper.convertValue(mapMetadata, Map.class));
        return dataAsMap;
    }

    private String getScheme(String defaultEntrypoint) {
        String scheme = "https";
        if (defaultEntrypoint != null) {
            try {
                scheme = new URL(defaultEntrypoint).getProtocol();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return scheme;
    }

    @Override
    public Set<ApiEntity> findByEnvironmentAndIdIn(ExecutionContext executionContext, Set<String> ids) {
        LOGGER.debug("Find APIs by environment {} and ID in {}", (Object)executionContext.getEnvironmentId(), ids);
        try {
            if (ids.isEmpty()) {
                return Collections.emptySet();
            }
            ApiCriteria criteria = new ApiCriteria.Builder().ids(ids).environmentId(executionContext.getEnvironmentId()).build();
            return this.convert(executionContext, this.apiRepository.search(criteria, null, new ApiFieldFilter.Builder().excludePicture().build()).collect(Collectors.toList())).stream().collect(Collectors.toSet());
        }
        catch (TechnicalException e) {
            LOGGER.error("An error occurs while trying to find APIs by environment and ids", (Throwable)e);
            throw new TechnicalManagementException("An error occurs while trying to find APIs by environment and ids", e);
        }
    }

    @Override
    public Set<ApiEntity> findByUser(ExecutionContext executionContext, String userId, ApiQuery apiQuery, boolean portal) {
        return new HashSet<ApiEntity>(this.findByUser(executionContext, userId, apiQuery, null, null, portal).getContent());
    }

    @Override
    public Set<String> findIdsByUser(ExecutionContext executionContext, String userId, ApiQuery apiQuery, Sortable sortable, boolean portal) {
        List<ApiCriteria> apiCriteriaList;
        Optional<Collection<String>> optionalTargetIds = this.searchInDefinition(executionContext, apiQuery);
        if (optionalTargetIds.isPresent()) {
            Collection<String> targetIds = optionalTargetIds.get();
            if (targetIds.isEmpty()) {
                return Collections.emptySet();
            }
            apiQuery.setIds(targetIds);
        }
        if ((apiCriteriaList = this.computeApiCriteriaForUser(executionContext, userId, apiQuery, portal)).isEmpty()) {
            return Set.of();
        }
        PageableImpl pageable = new PageableImpl(1, Integer.MAX_VALUE);
        List apiIds = this.apiRepository.searchIds(apiCriteriaList, ApiServiceImpl.convert((Pageable)pageable), ApiServiceImpl.convert(sortable)).getContent();
        return new LinkedHashSet<String>(apiIds);
    }

    @NotNull
    private List<ApiCriteria> computeApiCriteriaForUser(ExecutionContext executionContext, String userId, ApiQuery apiQuery, boolean portal) {
        ArrayList<ApiCriteria> apiCriteriaList = new ArrayList<ApiCriteria>();
        if (portal) {
            apiCriteriaList.add(this.queryToCriteria(executionContext, apiQuery).visibility(Visibility.PUBLIC).build());
        }
        if (apiQuery == null) {
            apiQuery = new ApiQuery();
        }
        if (userId != null) {
            Set applications;
            Set<String> userGroupApiIds;
            Set userApiIds = this.membershipService.getMembershipsByMemberAndReference(MembershipMemberType.USER, userId, MembershipReferenceType.API).stream().filter(membership -> membership.getRoleId() != null).filter(membership -> {
                RoleEntity role = this.roleService.findById(membership.getRoleId());
                if (!portal) {
                    return this.canManageApi(role);
                }
                return role.getScope().equals((Object)RoleScope.API);
            }).map(MembershipEntity::getReferenceId).collect(Collectors.toSet());
            if (!userApiIds.isEmpty()) {
                apiCriteriaList.add(this.queryToCriteria(executionContext, apiQuery).ids(userApiIds).build());
            }
            if (!(userGroupApiIds = this.findApiIdsByUserGroups(executionContext, userId, apiQuery, portal)).isEmpty()) {
                apiCriteriaList.add(this.queryToCriteria(executionContext, apiQuery).ids(userGroupApiIds).build());
            }
            if (portal && !(applications = this.applicationService.findByUser(executionContext, userId).stream().map(ApplicationListItem::getId).collect(Collectors.toSet())).isEmpty()) {
                SubscriptionQuery query = new SubscriptionQuery();
                query.setApplications(applications);
                Collection<SubscriptionEntity> subscriptions = this.subscriptionService.search(executionContext, query);
                if (subscriptions != null && !subscriptions.isEmpty()) {
                    apiCriteriaList.add(this.queryToCriteria(executionContext, apiQuery).ids((Collection)subscriptions.stream().map(SubscriptionEntity::getApi).distinct().collect(Collectors.toList())).build());
                }
            }
        }
        return apiCriteriaList;
    }

    @Override
    public Set<CategoryEntity> listCategories(Collection<String> apis, String environment) {
        try {
            ApiCriteria criteria = new ApiCriteria.Builder().ids(apis.toArray(new String[apis.size()])).build();
            Set categoryIds = this.apiRepository.listCategories(criteria);
            return this.categoryService.findByIdIn(environment, categoryIds);
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to list categories for APIs {}", apis, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to list categories for APIs {}" + apis, ex);
        }
    }

    @Override
    public Page<ApiEntity> findByUser(ExecutionContext executionContext, String userId, ApiQuery apiQuery, Sortable sortable, Pageable pageable, boolean portal) {
        try {
            LOGGER.debug("Find APIs page by user {}", (Object)userId);
            Set<String> apiIds = this.findIdsByUser(executionContext, userId, apiQuery, sortable, portal);
            return this.loadPage(executionContext, apiIds, pageable);
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to find APIs for user {}", (Object)userId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find APIs for user " + userId, ex);
        }
    }

    private io.gravitee.repository.management.model.Api findApiById(ExecutionContext executionContext, String apiId) {
        try {
            LOGGER.debug("Find API by ID: {}", (Object)apiId);
            Optional<io.gravitee.repository.management.model.Api> optApi = this.apiRepository.findById((Object)apiId);
            if (executionContext.hasEnvironmentId()) {
                optApi = optApi.filter(result -> result.getEnvironmentId().equals(executionContext.getEnvironmentId()));
            }
            return (io.gravitee.repository.management.model.Api)optApi.orElseThrow(() -> new ApiNotFoundException(apiId));
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to find an API using its ID: {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find an API using its ID: " + apiId, ex);
        }
    }

    private Set<String> findApiIdsByUserGroups(ExecutionContext executionContext, String userId, ApiQuery apiQuery, boolean portal) {
        HashSet<String> apis = new HashSet<String>();
        Map<String, RoleEntity> apiRoles = this.roleService.findByScope(RoleScope.API, executionContext.getOrganizationId()).stream().collect(Collectors.toMap(RoleEntity::getId, Function.identity()));
        List<String> nonPOGroupApiIds = this.findApiIdsByGroupWithUserHavingNonPOApiRole(executionContext, userId, apiQuery, apiRoles, portal);
        List<String> poGroupApiIds = this.findApiIdsByGroupWithUserHavingPOApiRole(executionContext, userId, apiQuery, apiRoles, portal);
        apis.addAll(nonPOGroupApiIds);
        apis.addAll(poGroupApiIds);
        return apis;
    }

    private List<String> findApiIdsByGroupWithUserHavingNonPOApiRole(ExecutionContext executionContext, String userId, ApiQuery apiQuery, Map<String, RoleEntity> apiRoles, boolean portal) {
        Set<String> nonPoRoleIds = apiRoles.values().stream().filter(role -> !role.isApiPrimaryOwner()).map(RoleEntity::getId).collect(Collectors.toSet());
        String[] groupIds = (String[])this.membershipService.getMembershipsByMemberAndReferenceAndRoleIn(MembershipMemberType.USER, userId, MembershipReferenceType.GROUP, nonPoRoleIds).stream().filter(membership -> {
            RoleEntity roleInGroup = (RoleEntity)apiRoles.get(membership.getRoleId());
            return portal || this.canManageApi(roleInGroup);
        }).map(MembershipEntity::getReferenceId).filter(Objects::nonNull).toArray(String[]::new);
        if (groupIds.length > 0) {
            List<String> apiIds = this.apiRepository.searchIds(List.of(this.queryToCriteria(executionContext, apiQuery).groups(groupIds).build()), new PageableBuilder().pageSize(Integer.MAX_VALUE).build(), null).getContent();
            return apiIds != null ? apiIds : List.of();
        }
        return List.of();
    }

    private List<String> findApiIdsByGroupWithUserHavingPOApiRole(ExecutionContext executionContext, String userId, ApiQuery apiQuery, Map<String, RoleEntity> apiRoles, boolean portal) {
        String apiPrimaryOwnerRoleId = apiRoles.values().stream().filter(RoleEntity::isApiPrimaryOwner).map(RoleEntity::getId).findFirst().orElseThrow(() -> new TechnicalManagementException("Unable to find API Primary Owner System Role"));
        String[] poGroupIds = (String[])this.membershipService.getMembershipsByMemberAndReferenceAndRole(MembershipMemberType.USER, userId, MembershipReferenceType.GROUP, apiPrimaryOwnerRoleId).stream().map(MembershipEntity::getReferenceId).filter(Objects::nonNull).toArray(String[]::new);
        Map apiRolesByName = apiRoles.values().stream().collect(Collectors.toMap(RoleEntity::getName, Function.identity()));
        Set<GroupEntity> userGroups = this.groupService.findByIds(Set.of(poGroupIds));
        if (poGroupIds.length > 0) {
            return this.apiRepository.search(this.queryToCriteria(executionContext, apiQuery).groups(poGroupIds).build(), null, ApiFieldFilter.allFields()).filter(api -> {
                PrimaryOwnerEntity primaryOwner = this.getPrimaryOwner(executionContext, (io.gravitee.repository.management.model.Api)api);
                if (Set.of(poGroupIds).contains(primaryOwner.getId())) {
                    return true;
                }
                return userGroups.stream().map(GroupEntity::getRoles).filter(Objects::nonNull).anyMatch(groupDefaultRoles -> {
                    String defaultApiRoleName = (String)groupDefaultRoles.get(RoleScope.API);
                    return portal || this.canManageApi((RoleEntity)apiRolesByName.get(defaultApiRoleName));
                });
            }).map(io.gravitee.repository.management.model.Api::getId).collect(Collectors.toList());
        }
        return List.of();
    }

    @Override
    public boolean canManageApi(RoleEntity role) {
        return role != null && role.getScope().equals((Object)RoleScope.API) && role.getPermissions().entrySet().stream().filter(entry -> this.isApiManagementPermission((String)entry.getKey())).anyMatch(entry -> {
            String stringPerm = new String((char[])entry.getValue());
            return stringPerm.contains("C") || stringPerm.contains("U") || stringPerm.contains("D");
        });
    }

    private boolean isApiManagementPermission(String permissionAsString) {
        return Arrays.stream(ApiPermission.values()).filter(permission -> permission != ApiPermission.RATING && permission != ApiPermission.RATING_ANSWER).anyMatch(permission -> permission.name().equals(permissionAsString));
    }

    @Override
    public Set<ApiEntity> findPublishedByUser(ExecutionContext executionContext, String userId, ApiQuery apiQuery) {
        if (apiQuery == null) {
            apiQuery = new ApiQuery();
        }
        apiQuery.setLifecycleStates(Collections.singletonList(io.gravitee.rest.api.model.api.ApiLifecycleState.PUBLISHED));
        return this.findByUser(executionContext, userId, apiQuery, true);
    }

    @Override
    public Set<String> findPublishedIdsByUser(ExecutionContext executionContext, String userId, ApiQuery apiQuery) {
        if (apiQuery == null) {
            apiQuery = new ApiQuery();
        }
        apiQuery.setLifecycleStates(Collections.singletonList(io.gravitee.rest.api.model.api.ApiLifecycleState.PUBLISHED));
        return this.findIdsByUser(executionContext, userId, apiQuery, true);
    }

    @Override
    public Page<ApiEntity> findPublishedByUser(ExecutionContext executionContext, String userId, ApiQuery apiQuery, Sortable sortable, Pageable pageable) {
        if (apiQuery == null) {
            apiQuery = new ApiQuery();
        }
        apiQuery.setLifecycleStates(Collections.singletonList(io.gravitee.rest.api.model.api.ApiLifecycleState.PUBLISHED));
        return this.findByUser(executionContext, userId, apiQuery, sortable, pageable, true);
    }

    @Override
    public Set<ApiEntity> findPublishedByUser(ExecutionContext executionContext, String userId) {
        return this.findPublishedByUser(executionContext, userId, null);
    }

    private Set merge(List originSet, Collection setToAdd) {
        if (originSet == null) {
            return this.merge(Collections.emptySet(), setToAdd);
        }
        return this.merge(new HashSet(originSet), setToAdd);
    }

    private Set merge(Set originSet, Collection setToAdd) {
        if (setToAdd != null && !setToAdd.isEmpty()) {
            if (originSet == null) {
                originSet = new HashSet();
            }
            originSet.addAll(setToAdd);
        }
        return originSet;
    }

    @Override
    public ApiEntity updateFromSwagger(ExecutionContext executionContext, String apiId, SwaggerApiEntity swaggerApiEntity, ImportSwaggerDescriptorEntity swaggerDescriptor) {
        ApiEntity apiEntityToUpdate = this.findById(executionContext, apiId);
        UpdateApiEntity updateApiEntity = this.apiConverter.toUpdateApiEntity(apiEntityToUpdate);
        updateApiEntity.setVersion(swaggerApiEntity.getVersion());
        updateApiEntity.setName(swaggerApiEntity.getName());
        updateApiEntity.setDescription(swaggerApiEntity.getDescription());
        updateApiEntity.setCategories(this.merge(updateApiEntity.getCategories(), (Collection)swaggerApiEntity.getCategories()));
        if (swaggerApiEntity.getProxy() != null) {
            Proxy proxy = updateApiEntity.getProxy();
            if (proxy == null) {
                proxy = new Proxy();
            }
            proxy.setGroups(this.merge(proxy.getGroups(), (Collection)swaggerApiEntity.getProxy().getGroups()));
            List virtualHostsToAdd = swaggerApiEntity.getProxy().getVirtualHosts();
            if (virtualHostsToAdd != null && !virtualHostsToAdd.isEmpty()) {
                virtualHostsToAdd = virtualHostsToAdd.stream().map(this.virtualHostService::sanitize).collect(Collectors.toList());
                proxy.setVirtualHosts(new ArrayList(this.merge(proxy.getVirtualHosts().stream().map(this.virtualHostService::sanitize).collect(Collectors.toSet()), virtualHostsToAdd)));
            }
            updateApiEntity.setProxy(proxy);
        }
        updateApiEntity.setGroups(this.merge(updateApiEntity.getGroups(), (Collection)swaggerApiEntity.getGroups()));
        updateApiEntity.setLabels(new ArrayList(this.merge(updateApiEntity.getLabels(), (Collection)swaggerApiEntity.getLabels())));
        if (swaggerApiEntity.getPicture() != null) {
            updateApiEntity.setPicture(swaggerApiEntity.getPicture());
        }
        updateApiEntity.setTags(this.merge(updateApiEntity.getTags(), (Collection)swaggerApiEntity.getTags()));
        if (swaggerApiEntity.getVisibility() != null) {
            updateApiEntity.setVisibility(swaggerApiEntity.getVisibility());
        }
        if (swaggerApiEntity.getProperties() != null) {
            PropertiesEntity properties = updateApiEntity.getProperties();
            if (properties == null) {
                properties = new PropertiesEntity();
            }
            properties.setProperties(new ArrayList(this.merge(properties.getProperties(), (Collection)swaggerApiEntity.getProperties().getProperties())));
            updateApiEntity.setProperties(properties);
        }
        if (swaggerDescriptor != null) {
            if (swaggerDescriptor.isWithPathMapping()) {
                updateApiEntity.setPathMappings(swaggerApiEntity.getPathMappings());
            }
            if (swaggerDescriptor.isWithPolicyPaths()) {
                if (DefinitionVersion.V2.getLabel().equals(updateApiEntity.getGraviteeDefinitionVersion())) {
                    updateApiEntity.setFlows(swaggerApiEntity.getFlows());
                } else {
                    updateApiEntity.setPaths(swaggerApiEntity.getPaths());
                }
            }
        }
        this.pageService.createOrUpdateSwaggerPage(executionContext, apiEntityToUpdate.getId(), swaggerDescriptor, false);
        ApiEntity updatedApi = this.update(executionContext, apiId, updateApiEntity);
        if (swaggerApiEntity.getMetadata() != null && !swaggerApiEntity.getMetadata().isEmpty()) {
            swaggerApiEntity.getMetadata().forEach(data -> {
                try {
                    ApiMetadataEntity apiMetadataEntity = this.apiMetadataService.findByIdAndApi(data.getKey(), apiId);
                    UpdateApiMetadataEntity updateApiMetadataEntity = new UpdateApiMetadataEntity();
                    updateApiMetadataEntity.setApiId(apiId);
                    updateApiMetadataEntity.setFormat(data.getFormat());
                    updateApiMetadataEntity.setKey(apiMetadataEntity.getKey());
                    updateApiMetadataEntity.setName(data.getName());
                    updateApiMetadataEntity.setValue(data.getValue());
                    ApiMetadataEntity metadata = this.apiMetadataService.update(executionContext, updateApiMetadataEntity);
                    updatedApi.getMetadata().put(metadata.getKey(), metadata.getValue());
                }
                catch (ApiMetadataNotFoundException amnfe) {
                    NewApiMetadataEntity newMD = new NewApiMetadataEntity();
                    newMD.setApiId(apiId);
                    newMD.setFormat(data.getFormat());
                    newMD.setName(data.getName());
                    newMD.setValue(data.getValue());
                    ApiMetadataEntity metadata = this.apiMetadataService.create(executionContext, newMD);
                    updatedApi.getMetadata().put(metadata.getKey(), metadata.getValue());
                }
            });
        }
        this.searchEngineService.index(executionContext, (Indexable)updatedApi, false);
        return updatedApi;
    }

    @Override
    public ApiEntity update(ExecutionContext executionContext, String apiId, UpdateApiEntity updateApiEntity) {
        return this.update(executionContext, apiId, updateApiEntity, false);
    }

    @Override
    public ApiEntity update(ExecutionContext executionContext, String apiId, UpdateApiEntity updateApiEntity, boolean checkPlans) {
        return this.update(executionContext, apiId, updateApiEntity, checkPlans, true);
    }

    @Override
    public ApiEntity update(ExecutionContext executionContext, String apiId, UpdateApiEntity updateApiEntity, boolean checkPlans, boolean updatePlansAndFlows) {
        try {
            LOGGER.debug("Update API {}", (Object)apiId);
            io.gravitee.repository.management.model.Api apiToUpdate = (io.gravitee.repository.management.model.Api)this.apiRepository.findById((Object)apiId).orElseThrow(() -> new ApiNotFoundException(apiId));
            Collection<VirtualHost> sanitizedVirtualHosts = this.virtualHostService.sanitizeAndValidate(executionContext, updateApiEntity.getProxy().getVirtualHosts(), apiId);
            updateApiEntity.getProxy().setVirtualHosts(new ArrayList<VirtualHost>(sanitizedVirtualHosts));
            this.checkEndpointsExists(updateApiEntity);
            this.checkEndpointsConfiguration(updateApiEntity);
            this.checkHealthcheckInheritance(updateApiEntity);
            this.validateHealtcheckSchedule(updateApiEntity);
            this.checkAllowOriginFormat(updateApiEntity);
            this.addLoggingMaxDuration(executionContext, updateApiEntity.getProxy().getLogging());
            this.validateRegexfields(updateApiEntity);
            this.checkPolicyConfigurations(updateApiEntity);
            this.checkResourceConfigurations(updateApiEntity);
            ApiEntity apiToCheck = this.convert(executionContext, apiToUpdate);
            this.checkDefinitionVersion(updateApiEntity, apiToCheck);
            this.checkShardingTags(updateApiEntity, apiToCheck, executionContext);
            if (updateApiEntity.getLifecycleState() == null) {
                updateApiEntity.setLifecycleState(apiToCheck.getLifecycleState());
            }
            this.checkLifecycleState(updateApiEntity, apiToCheck);
            Set<String> groups = updateApiEntity.getGroups();
            if (groups != null && !groups.isEmpty()) {
                this.checkGroupExistence(groups);
                groups = this.removePOGroups(executionContext, groups, apiId);
                updateApiEntity.setGroups(groups);
            }
            if (Objects.equals(updateApiEntity.getGraviteeDefinitionVersion(), DefinitionVersion.V1.getLabel()) && (updateApiEntity.getPaths() == null || updateApiEntity.getPaths().isEmpty())) {
                updateApiEntity.setPaths(Collections.singletonMap(URI_PATH_SEPARATOR, new ArrayList()));
            }
            if (updateApiEntity.getPlans() == null) {
                updateApiEntity.setPlans(new HashSet());
            } else if (checkPlans) {
                Set existingPlans = apiToCheck.getPlans();
                HashMap<String, PlanStatus> planStatuses = new HashMap<String, PlanStatus>();
                if (existingPlans != null && !existingPlans.isEmpty()) {
                    planStatuses.putAll(existingPlans.stream().collect(Collectors.toMap(PlanEntity::getId, PlanEntity::getStatus)));
                }
                updateApiEntity.getPlans().forEach(planToUpdate -> {
                    if (!planStatuses.containsKey(planToUpdate.getId()) || planStatuses.containsKey(planToUpdate.getId()) && planStatuses.get(planToUpdate.getId()) == PlanStatus.CLOSED && planStatuses.get(planToUpdate.getId()) != planToUpdate.getStatus()) {
                        throw new InvalidDataException("Invalid status for plan '" + planToUpdate.getName() + "'");
                    }
                });
            }
            this.encryptProperties(updateApiEntity.getPropertyList());
            if (io.gravitee.rest.api.model.api.ApiLifecycleState.DEPRECATED.equals((Object)updateApiEntity.getLifecycleState())) {
                this.planService.findByApi(executionContext, apiId).forEach(plan -> {
                    if (PlanStatus.PUBLISHED.equals((Object)plan.getStatus()) || PlanStatus.STAGING.equals((Object)plan.getStatus())) {
                        this.planService.deprecate(executionContext, plan.getId(), true);
                        updateApiEntity.getPlans().stream().filter(p -> p.getId().equals(plan.getId())).forEach(p -> p.setStatus(PlanStatus.DEPRECATED));
                    }
                });
            }
            io.gravitee.repository.management.model.Api api = this.convert(executionContext, apiId, updateApiEntity, apiToUpdate.getDefinition());
            api.setUpdatedAt(new Date());
            api.setEnvironmentId(apiToUpdate.getEnvironmentId());
            api.setDeployedAt(apiToUpdate.getDeployedAt());
            api.setCreatedAt(apiToUpdate.getCreatedAt());
            api.setLifecycleState(apiToUpdate.getLifecycleState());
            if (updateApiEntity.getCrossId() == null) {
                api.setCrossId(apiToUpdate.getCrossId());
            }
            if (updateApiEntity.getPicture() == null && updateApiEntity.getPictureUrl() != null && updateApiEntity.getPictureUrl().indexOf("?hash") > 0) {
                api.setPicture(apiToUpdate.getPicture());
            }
            if (updateApiEntity.getBackground() == null && updateApiEntity.getBackgroundUrl() != null && updateApiEntity.getBackgroundUrl().indexOf("?hash") > 0) {
                api.setBackground(apiToUpdate.getBackground());
            }
            if (updateApiEntity.getGroups() == null) {
                api.setGroups(apiToUpdate.getGroups());
            }
            if (updateApiEntity.getLabels() == null && apiToUpdate.getLabels() != null) {
                api.setLabels(new ArrayList(new HashSet(apiToUpdate.getLabels())));
            }
            if (updateApiEntity.getCategories() == null) {
                api.setCategories(apiToUpdate.getCategories());
            }
            if (ApiLifecycleState.DEPRECATED.equals((Object)api.getApiLifecycleState())) {
                this.triggerApiDeprecatedNotification(executionContext, apiId, apiToCheck);
            }
            io.gravitee.repository.management.model.Api updatedApi = (io.gravitee.repository.management.model.Api)this.apiRepository.update((Object)api);
            if (updatePlansAndFlows) {
                this.flowService.save(FlowReferenceType.API, api.getId(), updateApiEntity.getFlows());
                updateApiEntity.getPlans().forEach(plan -> {
                    plan.setApi(api.getId());
                    this.planService.createOrUpdatePlan(executionContext, (PlanEntity)plan);
                });
            }
            this.auditService.createApiAuditLog(executionContext, updatedApi.getId(), Collections.emptyMap(), (Audit.AuditEvent)Api.AuditEvent.API_UPDATED, updatedApi.getUpdatedAt(), apiToUpdate, updatedApi);
            if (this.parameterService.findAsBoolean(executionContext, Key.LOGGING_AUDIT_TRAIL_ENABLED, ParameterReferenceType.ENVIRONMENT)) {
                this.auditApiLogging(executionContext, apiToUpdate, updatedApi);
            }
            ApiEntity apiEntity = this.convert(executionContext, Collections.singletonList(updatedApi)).iterator().next();
            ApiEntity apiWithMetadata = this.fetchMetadataForApi(executionContext, apiEntity);
            this.triggerNotification(executionContext, apiId, ApiHook.API_UPDATED, apiEntity);
            this.searchEngineService.index(executionContext, (Indexable)apiWithMetadata, false);
            return apiEntity;
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to update API {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to update API " + apiId, ex);
        }
    }

    private String buildApiDefinition(String apiId, String apiDefinition, UpdateApiEntity updateApiEntity) {
        try {
            Api updateApiDefinition;
            if (apiDefinition == null || apiDefinition.isEmpty()) {
                updateApiDefinition = new Api();
                updateApiDefinition.setDefinitionVersion(DefinitionVersion.valueOfLabel((String)updateApiEntity.getGraviteeDefinitionVersion()));
            } else {
                updateApiDefinition = (Api)this.objectMapper.readValue(apiDefinition, Api.class);
                updateApiDefinition.setPlans(Collections.emptyList());
                updateApiDefinition.setFlows(Collections.emptyList());
            }
            updateApiDefinition.setId(apiId);
            updateApiDefinition.setName(updateApiEntity.getName());
            updateApiDefinition.setVersion(updateApiEntity.getVersion());
            updateApiDefinition.setProxy(updateApiEntity.getProxy());
            if (updateApiEntity.getExecutionMode() != null) {
                updateApiDefinition.setExecutionMode(updateApiEntity.getExecutionMode());
            }
            if (StringUtils.isNotEmpty((CharSequence)updateApiEntity.getGraviteeDefinitionVersion())) {
                updateApiDefinition.setDefinitionVersion(DefinitionVersion.valueOfLabel((String)updateApiEntity.getGraviteeDefinitionVersion()));
            }
            if (updateApiEntity.getFlowMode() != null) {
                updateApiDefinition.setFlowMode(updateApiEntity.getFlowMode());
            }
            if (updateApiEntity.getPaths() != null) {
                updateApiDefinition.setPaths(updateApiEntity.getPaths());
            }
            if (updateApiEntity.getPathMappings() != null) {
                updateApiDefinition.setPathMappings(updateApiEntity.getPathMappings().stream().collect(Collectors.toMap(pathMapping -> pathMapping, pathMapping -> Pattern.compile(""))));
            }
            updateApiDefinition.setServices(updateApiEntity.getServices());
            updateApiDefinition.setResources(updateApiEntity.getResources());
            if (updateApiEntity.getProperties() != null) {
                updateApiDefinition.setProperties(updateApiEntity.getProperties().toDefinition());
            }
            updateApiDefinition.setTags(updateApiEntity.getTags());
            updateApiDefinition.setResponseTemplates(updateApiEntity.getResponseTemplates());
            return this.objectMapper.writeValueAsString((Object)updateApiDefinition);
        }
        catch (JsonProcessingException jse) {
            LOGGER.error("Unexpected error while generating API definition", (Throwable)jse);
            throw new TechnicalManagementException("An error occurs while trying to parse API definition " + jse);
        }
    }

    private void checkAllowOriginFormat(UpdateApiEntity updateApiEntity) {
        Set accessControlAllowOrigin;
        if (updateApiEntity.getProxy() != null && updateApiEntity.getProxy().getCors() != null && (accessControlAllowOrigin = updateApiEntity.getProxy().getCors().getAccessControlAllowOrigin()) != null && !accessControlAllowOrigin.isEmpty()) {
            for (String allowOriginItem : accessControlAllowOrigin) {
                if (CORS_REGEX_PATTERN.matcher(allowOriginItem).matches()) continue;
                if (StringUtils.indexOfAny((CharSequence)allowOriginItem, (CharSequence[])CORS_REGEX_CHARS) >= 0) {
                    try {
                        Pattern.compile(allowOriginItem);
                        continue;
                    }
                    catch (PatternSyntaxException e) {
                        throw new AllowOriginNotAllowedException(allowOriginItem);
                    }
                }
                throw new AllowOriginNotAllowedException(allowOriginItem);
            }
        }
    }

    private void checkDefinitionVersion(UpdateApiEntity updateApiEntity, ApiEntity existingAPI) {
        if (existingAPI != null && updateApiEntity.getGraviteeDefinitionVersion() != null) {
            DefinitionVersion updateDefinitionVersion = DefinitionVersion.valueOfLabel((String)updateApiEntity.getGraviteeDefinitionVersion());
            if (updateDefinitionVersion == null) {
                throw new InvalidDataException("Invalid definition version for api '" + existingAPI.getId() + "'");
            }
            DefinitionVersion existingDefinitionVersion = DefinitionVersion.valueOfLabel((String)existingAPI.getGraviteeDefinitionVersion());
            if (updateDefinitionVersion.asInteger() < existingDefinitionVersion.asInteger()) {
                throw new DefinitionVersionException();
            }
        }
    }

    private void checkShardingTags(UpdateApiEntity updateApiEntity, ApiEntity existingAPI, ExecutionContext executionContext) {
        Set<String> userTags;
        Set<Object> updatedTags;
        Set tagsToUpdate;
        Set set = tagsToUpdate = updateApiEntity.getTags() == null ? new HashSet() : updateApiEntity.getTags();
        if (existingAPI == null) {
            updatedTags = tagsToUpdate;
        } else {
            Set existingAPITags = existingAPI.getTags() == null ? new HashSet() : existingAPI.getTags();
            updatedTags = existingAPITags.stream().filter(tag -> !tagsToUpdate.contains(tag)).collect(Collectors.toSet());
            updatedTags.addAll(tagsToUpdate.stream().filter(tag -> !existingAPITags.contains(tag)).collect(Collectors.toSet()));
        }
        if (updatedTags != null && !updatedTags.isEmpty() && !(userTags = this.tagService.findByUser(this.getAuthenticatedUsername(), executionContext.getOrganizationId(), TagReferenceType.ORGANIZATION)).containsAll(updatedTags)) {
            String[] notAllowedTags = (String[])updatedTags.stream().filter(tag -> !userTags.contains(tag)).toArray(String[]::new);
            throw new TagNotAllowedException(notAllowedTags);
        }
    }

    private void checkResourceConfigurations(UpdateApiEntity updateApiEntity) {
        List resources = updateApiEntity.getResources();
        if (resources != null) {
            resources.stream().filter(Resource::isEnabled).forEach(resource -> this.resourceService.validateResourceConfiguration((Resource)resource));
        }
    }

    private void checkPolicyConfigurations(UpdateApiEntity updateApiEntity) {
        this.checkPolicyConfigurations(updateApiEntity.getPaths(), updateApiEntity.getFlows(), updateApiEntity.getPlans());
    }

    @Override
    public void checkPolicyConfigurations(Map<String, List<Rule>> paths, List<Flow> flows, Set<PlanEntity> plans) {
        this.checkPathsPolicyConfiguration(paths);
        this.checkFlowsPolicyConfiguration(flows);
        if (plans != null) {
            plans.stream().forEach(plan -> {
                this.checkPathsPolicyConfiguration(plan.getPaths());
                this.checkFlowsPolicyConfiguration(plan.getFlows());
            });
        }
    }

    private void checkPathsPolicyConfiguration(Map<String, List<Rule>> paths) {
        if (paths != null) {
            paths.forEach((s, rules) -> rules.stream().filter(Rule::isEnabled).map(Rule::getPolicy).forEach(policy -> this.policyService.validatePolicyConfiguration((Policy)policy)));
        }
    }

    private void checkFlowsPolicyConfiguration(List<Flow> flows) {
        if (flows != null) {
            flows.stream().filter(flow -> flow.getPre() != null).forEach(flow -> flow.getPre().stream().filter(Step::isEnabled).forEach(step -> this.policyService.validatePolicyConfiguration((Step)step)));
            flows.stream().filter(flow -> flow.getPost() != null).forEach(flow -> flow.getPost().stream().filter(Step::isEnabled).forEach(step -> this.policyService.validatePolicyConfiguration((Step)step)));
        }
    }

    private void validateRegexfields(UpdateApiEntity updateApiEntity) {
        if (updateApiEntity.getPaths() != null) {
            updateApiEntity.getPaths().forEach((path, v) -> {
                try {
                    Pattern.compile(path);
                }
                catch (PatternSyntaxException pse) {
                    LOGGER.error("An error occurs while trying to parse the path {}", path, (Object)pse);
                    throw new TechnicalManagementException("An error occurs while trying to parse the path " + path, pse);
                }
            });
        }
        if (updateApiEntity.getPathMappings() != null) {
            updateApiEntity.getPathMappings().forEach(pathMapping -> {
                try {
                    Pattern.compile(pathMapping);
                }
                catch (PatternSyntaxException pse) {
                    LOGGER.error("An error occurs while trying to parse the path mapping {}", pathMapping, (Object)pse);
                    throw new TechnicalManagementException("An error occurs while trying to parse the path mapping" + pathMapping, pse);
                }
            });
        }
    }

    private void checkLifecycleState(UpdateApiEntity updateApiEntity, ApiEntity existingAPI) {
        if (io.gravitee.rest.api.model.api.ApiLifecycleState.DEPRECATED.equals((Object)existingAPI.getLifecycleState())) {
            throw new LifecycleStateChangeNotAllowedException(updateApiEntity.getLifecycleState().name());
        }
        if (existingAPI.getLifecycleState().name().equals(updateApiEntity.getLifecycleState().name())) {
            return;
        }
        if (io.gravitee.rest.api.model.api.ApiLifecycleState.ARCHIVED.equals((Object)existingAPI.getLifecycleState()) ? !io.gravitee.rest.api.model.api.ApiLifecycleState.ARCHIVED.equals((Object)updateApiEntity.getLifecycleState()) : (io.gravitee.rest.api.model.api.ApiLifecycleState.UNPUBLISHED.equals((Object)existingAPI.getLifecycleState()) ? io.gravitee.rest.api.model.api.ApiLifecycleState.CREATED.equals((Object)updateApiEntity.getLifecycleState()) : io.gravitee.rest.api.model.api.ApiLifecycleState.CREATED.equals((Object)existingAPI.getLifecycleState()) && WorkflowState.IN_REVIEW.equals((Object)existingAPI.getWorkflowState()))) {
            throw new LifecycleStateChangeNotAllowedException(updateApiEntity.getLifecycleState().name());
        }
    }

    @Override
    public void delete(ExecutionContext executionContext, String apiId) {
        try {
            LOGGER.debug("Delete API {}", (Object)apiId);
            io.gravitee.repository.management.model.Api api = (io.gravitee.repository.management.model.Api)this.apiRepository.findById((Object)apiId).orElseThrow(() -> new ApiNotFoundException(apiId));
            if (api.getLifecycleState() == LifecycleState.STARTED) {
                throw new ApiRunningStateException(apiId);
            }
            Set<PlanEntity> plans = this.planService.findByApi(executionContext, apiId);
            Set<String> plansNotClosed = plans.stream().filter(plan -> plan.getStatus() == PlanStatus.PUBLISHED).map(PlanEntity::getName).collect(Collectors.toSet());
            if (!plansNotClosed.isEmpty()) {
                throw new ApiNotDeletableException(plansNotClosed);
            }
            Collection<SubscriptionEntity> subscriptions = this.subscriptionService.findByApi(executionContext, apiId);
            subscriptions.forEach(sub -> this.subscriptionService.delete(executionContext, sub.getId()));
            plans.forEach(plan -> this.planService.delete(executionContext, plan.getId()));
            this.flowService.save(FlowReferenceType.API, apiId, null);
            EventQuery query = new EventQuery();
            query.setApi(apiId);
            this.eventService.search(executionContext, query).forEach(event -> this.eventService.delete(event.getId()));
            HashMap<String, String> properties = new HashMap<String, String>(2);
            properties.put(Event.EventProperties.API_ID.getValue(), apiId);
            if (this.getAuthenticatedUser() != null) {
                properties.put(Event.EventProperties.USER.getValue(), this.getAuthenticatedUser().getUsername());
            }
            this.eventService.createApiEvent(executionContext, Collections.singleton(executionContext.getEnvironmentId()), EventType.UNPUBLISH_API, null, properties);
            this.pageService.deleteAllByApi(executionContext, apiId);
            this.topApiService.delete(executionContext, apiId);
            this.apiRepository.delete((Object)apiId);
            this.membershipService.deleteReference(executionContext, MembershipReferenceType.API, apiId);
            this.genericNotificationConfigService.deleteReference(NotificationReferenceType.API, apiId);
            this.portalNotificationConfigService.deleteReference(NotificationReferenceType.API, apiId);
            List<AlertTriggerEntity> alerts = this.alertService.findByReferenceWithEventCounts(AlertReferenceType.API, apiId);
            alerts.forEach(alert -> this.alertService.delete(alert.getId(), alert.getReferenceId()));
            this.apiQualityRuleRepository.deleteByApi(apiId);
            this.auditService.createApiAuditLog(executionContext, apiId, Collections.emptyMap(), (Audit.AuditEvent)Api.AuditEvent.API_DELETED, new Date(), api, null);
            this.searchEngineService.delete(executionContext, (Indexable)this.convert(executionContext, api));
            this.mediaService.deleteAllByApi(apiId);
            this.apiMetadataService.deleteAllByApi(executionContext, apiId);
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to delete API {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete API " + apiId, ex);
        }
    }

    @Override
    public ApiEntity start(ExecutionContext executionContext, String apiId, String userId) {
        try {
            LOGGER.debug("Start API {}", (Object)apiId);
            ApiEntity apiEntity = this.updateLifecycle(executionContext, apiId, LifecycleState.STARTED, userId);
            this.notifierService.trigger(executionContext, ApiHook.API_STARTED, apiId, new NotificationParamsBuilder().api(apiEntity).user(this.userService.findById(executionContext, userId)).build());
            return apiEntity;
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to start API {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to start API " + apiId, ex);
        }
    }

    @Override
    public ApiEntity stop(ExecutionContext executionContext, String apiId, String userId) {
        try {
            LOGGER.debug("Stop API {}", (Object)apiId);
            ApiEntity apiEntity = this.updateLifecycle(executionContext, apiId, LifecycleState.STOPPED, userId);
            this.notifierService.trigger(executionContext, ApiHook.API_STOPPED, apiId, new NotificationParamsBuilder().api(apiEntity).user(this.userService.findById(executionContext, userId)).build());
            return apiEntity;
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to stop API {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to stop API " + apiId, ex);
        }
    }

    @Override
    public boolean isSynchronized(ExecutionContext executionContext, String apiId) {
        try {
            ApiEntity api = this.findById(executionContext, apiId);
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put(Event.EventProperties.API_ID.getValue(), apiId);
            Page<EventEntity> events = this.eventService.search(executionContext, Arrays.asList(EventType.PUBLISH_API, EventType.UNPUBLISH_API), properties, 0L, 0L, 0, 1, Collections.singletonList(executionContext.getEnvironmentId()));
            if (!events.getContent().isEmpty()) {
                EventEntity lastEvent = (EventEntity)events.getContent().get(0);
                boolean sync = false;
                if (EventType.PUBLISH_API.equals((Object)lastEvent.getType())) {
                    boolean enabled = this.objectMapper.getDeserializationConfig().isEnabled(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
                    this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                    io.gravitee.repository.management.model.Api payloadEntity = (io.gravitee.repository.management.model.Api)this.objectMapper.readValue(lastEvent.getPayload(), io.gravitee.repository.management.model.Api.class);
                    this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, enabled);
                    ApiEntity deployedApi = this.convert(executionContext, payloadEntity, false);
                    this.removeDescriptionFromPolicies(api);
                    this.removeDescriptionFromPolicies(deployedApi);
                    this.removeIdsFromFlows(api);
                    this.removeIdsFromFlows(deployedApi);
                    sync = this.apiSynchronizationProcessor.processCheckSynchronization(deployedApi, api);
                    if (sync) {
                        Set<PlanEntity> plans = this.planService.findByApi(executionContext, api.getId());
                        sync = plans.stream().filter(plan -> plan.getStatus() != PlanStatus.STAGING).filter(plan -> plan.getNeedRedeployAt().after(api.getDeployedAt())).count() == 0L;
                    }
                }
                return sync;
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurs while trying to check API synchronization state {}", (Object)apiId, (Object)e);
        }
        return false;
    }

    private void removeIdsFromFlows(ApiEntity api) {
        api.getFlows().forEach(flow -> flow.setId(null));
        api.getPlans().forEach(plan -> plan.getFlows().forEach(flow -> flow.setId(null)));
    }

    private void removeDescriptionFromPolicies(ApiEntity api) {
        if (api.getPaths() != null) {
            api.getPaths().forEach((s, rules) -> {
                if (rules != null) {
                    rules.forEach(rule -> rule.setDescription(""));
                }
            });
        }
    }

    @Override
    public ApiEntity deploy(ExecutionContext executionContext, String apiId, String userId, EventType eventType, ApiDeploymentEntity apiDeploymentEntity) {
        try {
            LOGGER.debug("Deploy API : {}", (Object)apiId);
            return this.deployCurrentAPI(executionContext, apiId, userId, eventType, apiDeploymentEntity);
        }
        catch (Exception ex) {
            LOGGER.error("An error occurs while trying to deploy API: {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to deploy API: " + apiId, ex);
        }
    }

    @Override
    public ApiEntity rollback(ExecutionContext executionContext, String apiId, RollbackApiEntity rollbackApiEntity) {
        LOGGER.debug("Rollback API : {}", (Object)apiId);
        try {
            this.auditService.createApiAuditLog(executionContext, apiId, Collections.emptyMap(), (Audit.AuditEvent)Api.AuditEvent.API_ROLLBACKED, new Date(), null, null);
            return this.apiDuplicatorService.updateWithImportedDefinition(executionContext, apiId, this.objectMapper.writeValueAsString((Object)rollbackApiEntity));
        }
        catch (Exception ex) {
            LOGGER.error("An error occurs while trying to rollback API: {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to rollback API: " + apiId, ex);
        }
    }

    private ApiEntity deployCurrentAPI(ExecutionContext executionContext, String apiId, String userId, EventType eventType, ApiDeploymentEntity apiDeploymentEntity) throws Exception {
        io.gravitee.repository.management.model.Api api = (io.gravitee.repository.management.model.Api)this.apiRepository.findById((Object)apiId).orElseThrow(() -> new ApiNotFoundException(apiId));
        api.setUpdatedAt(new Date());
        api.setDeployedAt(api.getUpdatedAt());
        api = (io.gravitee.repository.management.model.Api)this.apiRepository.update((Object)api);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(Event.EventProperties.API_ID.getValue(), api.getId());
        properties.put(Event.EventProperties.USER.getValue(), userId);
        api.setPicture(null);
        this.addDeploymentLabelToProperties(executionContext, apiId, eventType, properties, apiDeploymentEntity);
        this.eventService.createApiEvent(executionContext, Collections.singleton(executionContext.getEnvironmentId()), eventType, api, properties);
        ApiEntity deployed = this.convert(executionContext, Collections.singletonList(api)).iterator().next();
        if (!this.getAuthenticatedUser().isSystem()) {
            this.notifierService.trigger(executionContext, ApiHook.API_DEPLOYED, apiId, new NotificationParamsBuilder().api(deployed).user(this.userService.findById(executionContext, userId)).build());
        }
        return deployed;
    }

    private void addDeploymentLabelToProperties(ExecutionContext executionContext, String apiId, EventType eventType, Map<String, String> properties, ApiDeploymentEntity apiDeploymentEntity) {
        if (EventType.PUBLISH_API.equals((Object)eventType)) {
            EventQuery query = new EventQuery();
            query.setApi(apiId);
            query.setTypes(Collections.singleton(EventType.PUBLISH_API));
            Optional<EventEntity> optEvent = this.eventService.search(executionContext, query).stream().max(Comparator.comparing(EventEntity::getCreatedAt));
            String lastDeployNumber = optEvent.isPresent() ? optEvent.get().getProperties().getOrDefault(Event.EventProperties.DEPLOYMENT_NUMBER.getValue(), "0") : "0";
            String newDeployNumber = Long.toString(Long.parseLong(lastDeployNumber) + 1L);
            properties.put(Event.EventProperties.DEPLOYMENT_NUMBER.getValue(), newDeployNumber);
            if (apiDeploymentEntity != null && StringUtils.isNotEmpty((CharSequence)apiDeploymentEntity.getDeploymentLabel())) {
                properties.put(Event.EventProperties.DEPLOYMENT_LABEL.getValue(), apiDeploymentEntity.getDeploymentLabel());
            }
        }
    }

    private ApiEntity deployLastPublishedAPI(ExecutionContext executionContext, String apiId, String userId, EventType eventType) throws TechnicalException {
        EventQuery query = new EventQuery();
        query.setApi(apiId);
        query.setTypes(Collections.singleton(EventType.PUBLISH_API));
        Optional<EventEntity> optEvent = this.eventService.search(executionContext, query).stream().max(Comparator.comparing(EventEntity::getCreatedAt));
        try {
            if (optEvent.isPresent()) {
                EventEntity event = optEvent.get();
                JsonNode node = this.objectMapper.readTree(event.getPayload());
                io.gravitee.repository.management.model.Api lastPublishedAPI = (io.gravitee.repository.management.model.Api)this.objectMapper.convertValue((Object)node, io.gravitee.repository.management.model.Api.class);
                lastPublishedAPI.setLifecycleState(this.convert(eventType));
                lastPublishedAPI.setUpdatedAt(new Date());
                lastPublishedAPI.setDeployedAt(new Date());
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put(Event.EventProperties.API_ID.getValue(), lastPublishedAPI.getId());
                properties.put(Event.EventProperties.USER.getValue(), userId);
                lastPublishedAPI.setPicture(null);
                this.eventService.createApiEvent(executionContext, Collections.singleton(executionContext.getEnvironmentId()), eventType, lastPublishedAPI, properties);
                return null;
            }
            return this.deploy(executionContext, apiId, userId, EventType.PUBLISH_API, new ApiDeploymentEntity());
        }
        catch (Exception e) {
            LOGGER.error("An error occurs while trying to deploy last published API {}", (Object)apiId, (Object)e);
            throw new TechnicalException("An error occurs while trying to deploy last published API " + apiId, (Throwable)e);
        }
    }

    @Override
    public String exportAsJson(ExecutionContext executionContext, String apiId, String exportVersion, String ... filteredFields) {
        ApiEntity apiEntity = this.findById(executionContext, apiId);
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put(ApiSerializer.METADATA_EXPORT_VERSION, exportVersion);
        metadata.put(ApiSerializer.METADATA_FILTERED_FIELDS_LIST, Arrays.asList(filteredFields));
        apiEntity.setMetadata(metadata);
        try {
            return this.objectMapper.writeValueAsString((Object)apiEntity);
        }
        catch (Exception e) {
            LOGGER.error("An error occurs while trying to JSON serialize the API {}", (Object)apiEntity, (Object)e);
            return "";
        }
    }

    @Override
    public InlinePictureEntity getPicture(ExecutionContext executionContext, String apiId) {
        io.gravitee.repository.management.model.Api api = this.findApiById(executionContext, apiId);
        InlinePictureEntity imageEntity = new InlinePictureEntity();
        if (api.getPicture() != null) {
            String[] parts = api.getPicture().split(";", 2);
            imageEntity.setType(parts[0].split(":")[1]);
            String base64Content = api.getPicture().split(",", 2)[1];
            imageEntity.setContent(DatatypeConverter.parseBase64Binary((String)base64Content));
        } else {
            this.getDefaultPicture().ifPresent(content -> {
                imageEntity.setType("image/png");
                imageEntity.setContent(content);
            });
        }
        return imageEntity;
    }

    private Optional<byte[]> getDefaultPicture() {
        Optional<byte[]> content = Optional.empty();
        if (!Strings.isNullOrEmpty((String)this.defaultApiIcon)) {
            try {
                content = Optional.of(IOUtils.toByteArray((InputStream)new FileInputStream(this.defaultApiIcon)));
            }
            catch (IOException ioe) {
                LOGGER.error("Default icon for API does not exist", (Throwable)ioe);
            }
        }
        return content;
    }

    @Override
    public InlinePictureEntity getBackground(ExecutionContext executionContext, String apiId) {
        io.gravitee.repository.management.model.Api api = this.findApiById(executionContext, apiId);
        InlinePictureEntity imageEntity = new InlinePictureEntity();
        if (api.getBackground() != null) {
            String[] parts = api.getBackground().split(";", 2);
            imageEntity.setType(parts[0].split(":")[1]);
            String base64Content = api.getBackground().split(",", 2)[1];
            imageEntity.setContent(DatatypeConverter.parseBase64Binary((String)base64Content));
        }
        return imageEntity;
    }

    @Override
    public ApiEntity migrate(ExecutionContext executionContext, String apiId) {
        ApiEntity apiEntity = this.findById(executionContext, apiId);
        Set<PolicyEntity> policies = this.policyService.findAll();
        Set<PlanEntity> plans = this.planService.findByApi(executionContext, apiId);
        ApiEntity migratedApi = this.apiv1toAPIV2Converter.migrateToV2(apiEntity, policies, plans);
        return this.update(executionContext, apiId, this.apiConverter.toUpdateApiEntity(migratedApi));
    }

    @Override
    public void deleteCategoryFromAPIs(ExecutionContext executionContext, String categoryId) {
        this.apiRepository.search(new ApiCriteria.Builder().category(categoryId).build(), null, ApiFieldFilter.allFields()).forEach(api -> this.removeCategory(executionContext, (io.gravitee.repository.management.model.Api)api, categoryId));
    }

    private void removeCategory(ExecutionContext executionContext, io.gravitee.repository.management.model.Api api, String categoryId) {
        try {
            io.gravitee.repository.management.model.Api apiSnapshot = new io.gravitee.repository.management.model.Api(api);
            api.getCategories().remove(categoryId);
            api.setUpdatedAt(new Date());
            this.apiRepository.update((Object)api);
            this.triggerUpdateNotification(executionContext, api);
            this.auditService.createApiAuditLog(executionContext, api.getId(), Collections.emptyMap(), (Audit.AuditEvent)Api.AuditEvent.API_UPDATED, api.getUpdatedAt(), apiSnapshot, api);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("An error has occurred while removing category " + categoryId + " from API " + api.getId(), e);
        }
    }

    @Override
    public void deleteTagFromAPIs(ExecutionContext executionContext, String tagId) {
        this.environmentService.findByOrganization(executionContext.getOrganizationId()).stream().map(ExecutionContext::new).flatMap(env -> this.apiRepository.search(new ApiCriteria.Builder().environmentId(env.getEnvironmentId()).build(), null, new ApiFieldFilter.Builder().excludePicture().build()).map(api -> this.convert((ExecutionContext)env, (io.gravitee.repository.management.model.Api)api))).filter(api -> api.getTags() != null && api.getTags().contains(tagId)).forEach(api -> this.removeTag(executionContext, api.getId(), tagId));
    }

    @Override
    public ApiModelEntity findByIdForTemplates(ExecutionContext executionContext, String apiId, boolean decodeTemplate) {
        ApiEntity apiEntity = this.findById(executionContext, apiId);
        ApiModelEntity apiModelEntity = new ApiModelEntity();
        apiModelEntity.setId(apiEntity.getId());
        apiModelEntity.setName(apiEntity.getName());
        apiModelEntity.setDescription(apiEntity.getDescription());
        apiModelEntity.setCreatedAt(apiEntity.getCreatedAt());
        apiModelEntity.setDeployedAt(apiEntity.getDeployedAt());
        apiModelEntity.setUpdatedAt(apiEntity.getUpdatedAt());
        apiModelEntity.setGroups(apiEntity.getGroups());
        apiModelEntity.setVisibility(apiEntity.getVisibility());
        apiModelEntity.setCategories(apiEntity.getCategories());
        apiModelEntity.setVersion(apiEntity.getVersion());
        apiModelEntity.setExecutionMode(apiEntity.getExecutionMode());
        apiModelEntity.setState(apiEntity.getState());
        apiModelEntity.setTags(apiEntity.getTags());
        apiModelEntity.setServices(apiEntity.getServices());
        apiModelEntity.setPaths(apiEntity.getPaths());
        apiModelEntity.setPicture(apiEntity.getPicture());
        apiModelEntity.setPrimaryOwner(apiEntity.getPrimaryOwner());
        apiModelEntity.setProperties(apiEntity.getProperties());
        apiModelEntity.setProxy(this.convert(apiEntity.getProxy()));
        apiModelEntity.setLifecycleState(apiEntity.getLifecycleState());
        apiModelEntity.setDisableMembershipNotifications(apiEntity.isDisableMembershipNotifications());
        List<ApiMetadataEntity> metadataList = this.apiMetadataService.findAllByApi(apiId);
        if (metadataList != null) {
            HashMap mapMetadata = new HashMap(metadataList.size());
            metadataList.forEach(metadata -> mapMetadata.put(metadata.getKey(), metadata.getValue() == null ? metadata.getDefaultValue() : metadata.getValue()));
            apiModelEntity.setMetadata(mapMetadata);
            if (decodeTemplate) {
                try {
                    String decodedValue = this.notificationTemplateService.resolveInlineTemplateWithParam(executionContext.getOrganizationId(), apiModelEntity.getId(), new StringReader(((Object)mapMetadata).toString()), Collections.singletonMap("api", apiModelEntity));
                    Map<String, String> metadataDecoded = Arrays.stream(decodedValue.substring(1, decodedValue.length() - 1).split(", ")).map(entry -> entry.split("=", 2)).collect(Collectors.toMap(entry -> entry[0], entry -> ((String[])entry).length > 1 ? entry[1] : ""));
                    apiModelEntity.setMetadata(metadataDecoded);
                }
                catch (Exception ex) {
                    throw new TechnicalManagementException("An error occurs while evaluating API metadata", ex);
                }
            }
        }
        return apiModelEntity;
    }

    @Override
    public boolean exists(String apiId) {
        try {
            return this.apiRepository.findById((Object)apiId).isPresent();
        }
        catch (TechnicalException te) {
            String msg = "An error occurs while checking if the API exists: " + apiId;
            LOGGER.error(msg, (Throwable)te);
            throw new TechnicalManagementException(msg, te);
        }
    }

    @Override
    public ApiEntity importPathMappingsFromPage(ExecutionContext executionContext, ApiEntity apiEntity, String page, DefinitionVersion definitionVersion) {
        PageEntity pageEntity = this.pageService.findById(page);
        if (PageType.SWAGGER.name().equals(pageEntity.getType())) {
            ImportSwaggerDescriptorEntity importSwaggerDescriptorEntity = new ImportSwaggerDescriptorEntity();
            importSwaggerDescriptorEntity.setPayload(pageEntity.getContent());
            importSwaggerDescriptorEntity.setWithPathMapping(true);
            SwaggerApiEntity swaggerApiEntity = this.swaggerService.createAPI(executionContext, importSwaggerDescriptorEntity, definitionVersion);
            apiEntity.getPathMappings().addAll(swaggerApiEntity.getPathMappings());
        }
        return this.update(executionContext, apiEntity.getId(), this.apiConverter.toUpdateApiEntity(apiEntity));
    }

    @Override
    public Page<ApiEntity> search(ExecutionContext executionContext, ApiQuery query, Sortable sortable, Pageable pageable) {
        try {
            LOGGER.debug("Search paginated APIs by {}", (Object)query);
            Optional<Collection<String>> optionalTargetIds = this.searchInDefinition(executionContext, query);
            if (optionalTargetIds.isPresent()) {
                Collection<String> targetIds = optionalTargetIds.get();
                if (targetIds.isEmpty()) {
                    return new Page(Collections.emptyList(), 0, 0, 0L);
                }
                query.setIds(targetIds);
            }
            return this.convert(executionContext, (Page<io.gravitee.repository.management.model.Api>)this.apiRepository.search(this.queryToCriteria(executionContext, query).build(), ApiServiceImpl.convert(sortable), ApiServiceImpl.convert(pageable), new ApiFieldFilter.Builder().excludePicture().build()));
        }
        catch (TechnicalException ex) {
            String errorMessage = "An error occurs while trying to search for paginated APIs: " + query;
            LOGGER.error(errorMessage, (Throwable)ex);
            throw new TechnicalManagementException(errorMessage, ex);
        }
    }

    private Page<ApiEntity> convert(ExecutionContext executionContext, Page<io.gravitee.repository.management.model.Api> page) throws TechnicalException {
        return new Page(this.convert(executionContext, page.getContent()), page.getPageNumber(), (int)page.getPageElements(), page.getTotalElements());
    }

    @Override
    public Collection<ApiEntity> search(ExecutionContext executionContext, ApiQuery query) {
        try {
            LOGGER.debug("Search APIs by {}", (Object)query);
            Optional<Collection<String>> optionalTargetIds = this.searchInDefinition(executionContext, query);
            if (optionalTargetIds.isPresent()) {
                Collection<String> targetIds = optionalTargetIds.get();
                if (targetIds.isEmpty()) {
                    return Collections.emptySet();
                }
                query.setIds(targetIds);
            }
            List<io.gravitee.repository.management.model.Api> apis = this.apiRepository.search(this.queryToCriteria(executionContext, query).build(), null, ApiFieldFilter.allFields()).collect(Collectors.toList());
            return this.convert(executionContext, apis);
        }
        catch (TechnicalException ex) {
            String errorMessage = "An error occurs while trying to search for APIs: " + query;
            LOGGER.error(errorMessage, (Throwable)ex);
            throw new TechnicalManagementException(errorMessage, ex);
        }
    }

    @Override
    public Page<String> searchIds(ExecutionContext executionContext, ApiQuery query, Pageable pageable, Sortable sortable) {
        try {
            LOGGER.debug("Search API ids by {}", (Object)query);
            ApiCriteria apiCriteria = this.queryToCriteria(executionContext, query).build();
            return this.apiRepository.searchIds(List.of(apiCriteria), ApiServiceImpl.convert(pageable), ApiServiceImpl.convert(sortable));
        }
        catch (Exception ex) {
            String errorMessage = "An error occurs while trying to search for API ids: " + query;
            throw new TechnicalManagementException(errorMessage, ex);
        }
    }

    @Override
    public Page<ApiEntity> search(ExecutionContext executionContext, String query, Map<String, Object> filters, Sortable sortable, Pageable pageable) {
        try {
            LOGGER.debug("Search paged APIs by {}", (Object)query);
            Collection<String> apiIds = this.searchIds(executionContext, query, filters, sortable);
            if (apiIds.isEmpty()) {
                return new Page(Collections.emptyList(), 0, 0, 0L);
            }
            return this.loadPage(executionContext, apiIds, pageable);
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to search paged apis", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to search paged apis", ex);
        }
    }

    @Override
    public Collection<ApiEntity> search(ExecutionContext executionContext, String query, Map<String, Object> filters) {
        return this.searchInDefinition(executionContext, query, filters).getDocuments().stream().map(apiId -> this.findById(executionContext, (String)apiId)).collect(Collectors.toList());
    }

    private Optional<Collection<String>> searchInDefinition(ExecutionContext executionContext, ApiQuery apiQuery) {
        if (apiQuery == null) {
            return Optional.empty();
        }
        Query<ApiEntity> searchEngineQuery = this.convert(apiQuery).build();
        if (StringUtils.isBlank((CharSequence)searchEngineQuery.getQuery())) {
            return Optional.empty();
        }
        SearchResult matchApis = this.searchEngineService.search(executionContext, searchEngineQuery);
        return Optional.of(matchApis.getDocuments());
    }

    private SearchResult searchInDefinition(ExecutionContext executionContext, String query, Map<String, Object> filters) {
        return this.searchInDefinition(executionContext, query, filters, null);
    }

    private SearchResult searchInDefinition(ExecutionContext executionContext, String query, Map<String, Object> filters, Sortable sortable) {
        Query<ApiEntity> searchEngineQuery = QueryBuilder.create(ApiEntity.class).setQuery(query).setSort(sortable).setFilters(filters).build();
        return this.searchEngineService.search(executionContext, searchEngineQuery);
    }

    private QueryBuilder<ApiEntity> convert(ApiQuery query) {
        QueryBuilder<ApiEntity> searchEngineQuery = QueryBuilder.create(ApiEntity.class);
        if (query.getIds() != null && !query.getIds().isEmpty()) {
            HashMap<String, Object> filters = new HashMap<String, Object>();
            filters.put("api", query.getIds());
            searchEngineQuery.setFilters(filters);
        }
        if (!StringUtils.isBlank((CharSequence)query.getContextPath())) {
            searchEngineQuery.addExplicitFilter("paths", query.getContextPath());
        }
        if (!StringUtils.isBlank((CharSequence)query.getTag())) {
            searchEngineQuery.addExplicitFilter("tag", query.getTag());
        }
        return searchEngineQuery;
    }

    @Override
    public Collection<String> searchIds(ExecutionContext executionContext, String query, Map<String, Object> filters, Sortable sortable) {
        return this.searchInDefinition(executionContext, query, filters, sortable).getDocuments();
    }

    @Override
    public List<ApiHeaderEntity> getPortalHeaders(ExecutionContext executionContext, String apiId) {
        List<ApiHeaderEntity> entities = this.apiHeaderService.findAll(executionContext.getEnvironmentId());
        ApiModelEntity apiEntity = this.findByIdForTemplates(executionContext, apiId);
        HashMap<String, ApiModelEntity> model = new HashMap<String, ApiModelEntity>();
        model.put("api", apiEntity);
        entities.forEach(entity -> {
            if (entity.getValue().contains("${")) {
                String entityValue = this.notificationTemplateService.resolveInlineTemplateWithParam(executionContext.getOrganizationId(), entity.getId() + entity.getUpdatedAt().toString(), entity.getValue(), (Object)model);
                entity.setValue(entityValue);
            }
        });
        return entities.stream().filter(apiHeaderEntity -> apiHeaderEntity.getValue() != null && !apiHeaderEntity.getValue().isEmpty()).collect(Collectors.toList());
    }

    @Override
    public ApiEntity askForReview(ExecutionContext executionContext, String apiId, String userId, ReviewEntity reviewEntity) {
        LOGGER.debug("Ask for review API {}", (Object)apiId);
        return this.updateWorkflowReview(executionContext, apiId, userId, ApiHook.ASK_FOR_REVIEW, WorkflowState.IN_REVIEW, reviewEntity.getMessage());
    }

    @Override
    public ApiEntity acceptReview(ExecutionContext executionContext, String apiId, String userId, ReviewEntity reviewEntity) {
        LOGGER.debug("Accept review API {}", (Object)apiId);
        return this.updateWorkflowReview(executionContext, apiId, userId, ApiHook.REVIEW_OK, WorkflowState.REVIEW_OK, reviewEntity.getMessage());
    }

    @Override
    public ApiEntity rejectReview(ExecutionContext executionContext, String apiId, String userId, ReviewEntity reviewEntity) {
        LOGGER.debug("Reject review API {}", (Object)apiId);
        return this.updateWorkflowReview(executionContext, apiId, userId, ApiHook.REQUEST_FOR_CHANGES, WorkflowState.REQUEST_FOR_CHANGES, reviewEntity.getMessage());
    }

    @Override
    public boolean hasHealthCheckEnabled(ApiEntity api, boolean mustBeEnabledOnAllEndpoints) {
        boolean globalHC;
        boolean bl = globalHC = api.getServices() != null && api.getServices().getAll() != null && api.getServices().getAll().stream().anyMatch(service -> service.isEnabled() && service instanceof HealthCheckService);
        if (globalHC) {
            return true;
        }
        Predicate<Endpoint> endpointHealthCheckEnabledPredicate = endpoint -> {
            if (this.isHttpEndpoint((Endpoint)endpoint)) {
                return endpoint.getHealthCheck() != null && endpoint.getHealthCheck().isEnabled();
            }
            return false;
        };
        if (mustBeEnabledOnAllEndpoints) {
            return api.getProxy().getGroups().stream().allMatch(group -> group.getEndpoints().stream().allMatch(endpointHealthCheckEnabledPredicate));
        }
        return api.getProxy() != null && api.getProxy().getGroups() != null && api.getProxy().getGroups().stream().anyMatch(group -> group.getEndpoints() != null && group.getEndpoints().stream().anyMatch(endpointHealthCheckEnabledPredicate));
    }

    @Override
    public ApiEntity fetchMetadataForApi(ExecutionContext executionContext, ApiEntity apiEntity) {
        List<ApiMetadataEntity> metadataList = this.apiMetadataService.findAllByApi(apiEntity.getId());
        HashMap mapMetadata = new HashMap(metadataList.size());
        metadataList.forEach(metadata -> mapMetadata.put(metadata.getKey(), metadata.getValue() == null ? metadata.getDefaultValue() : metadata.getValue()));
        String decodedValue = this.notificationTemplateService.resolveInlineTemplateWithParam(executionContext.getOrganizationId(), apiEntity.getId(), new StringReader(((Object)mapMetadata).toString()), Collections.singletonMap("api", apiEntity));
        Map<String, Object> metadataDecoded = Arrays.stream(decodedValue.substring(1, decodedValue.length() - 1).split(", ")).map(entry -> entry.split("=")).collect(Collectors.toMap(entry -> entry[0], entry -> ((String[])entry).length > 1 ? entry[1] : ""));
        apiEntity.setMetadata(metadataDecoded);
        return apiEntity;
    }

    @Override
    public void addGroup(ExecutionContext executionContext, String apiId, String group) {
        try {
            io.gravitee.repository.management.model.Api api;
            HashSet<String> groups;
            LOGGER.debug("Add group {} to API {}", (Object)group, (Object)apiId);
            Optional<io.gravitee.repository.management.model.Api> optApi = this.apiRepository.findById((Object)apiId);
            if (executionContext.hasEnvironmentId()) {
                optApi = optApi.filter(result -> result.getEnvironmentId().equals(executionContext.getEnvironmentId()));
            }
            if ((groups = (api = (io.gravitee.repository.management.model.Api)optApi.orElseThrow(() -> new ApiNotFoundException(apiId))).getGroups()) == null) {
                groups = new HashSet<String>();
                api.setGroups(groups);
            }
            groups.add(group);
            this.apiRepository.update((Object)api);
            this.triggerUpdateNotification(executionContext, api);
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to add group {} to API {}: {}", new Object[]{group, apiId, ex});
            throw new TechnicalManagementException("An error occurs while trying to add group " + group + " to API " + apiId, ex);
        }
    }

    @Override
    public void removeGroup(ExecutionContext executionContext, String apiId, String group) {
        try {
            io.gravitee.repository.management.model.Api api;
            LOGGER.debug("Remove group {} to API {}", (Object)group, (Object)apiId);
            Optional<io.gravitee.repository.management.model.Api> optApi = this.apiRepository.findById((Object)apiId);
            if (executionContext.hasEnvironmentId()) {
                optApi = optApi.filter(result -> result.getEnvironmentId().equals(executionContext.getEnvironmentId()));
            }
            if ((api = (io.gravitee.repository.management.model.Api)optApi.orElseThrow(() -> new ApiNotFoundException(apiId))).getGroups() != null && api.getGroups().remove(group)) {
                this.apiRepository.update((Object)api);
                this.triggerUpdateNotification(executionContext, api);
            }
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to remove group {} from API {}: {}", new Object[]{group, apiId, ex});
            throw new TechnicalManagementException("An error occurs while trying to remove group " + group + " from API " + apiId, ex);
        }
    }

    private ApiEntity updateWorkflowReview(ExecutionContext executionContext, String apiId, String userId, ApiHook hook, WorkflowState workflowState, String workflowMessage) {
        Workflow workflow = this.workflowService.create(WorkflowReferenceType.API, apiId, WorkflowType.REVIEW, userId, workflowState, workflowMessage);
        ApiEntity apiEntity = this.findById(executionContext, apiId);
        apiEntity.setWorkflowState(workflowState);
        UserEntity user = this.userService.findById(executionContext, userId);
        this.notifierService.trigger(executionContext, hook, apiId, new NotificationParamsBuilder().api(apiEntity).user(user).build());
        if (hook.equals(ApiHook.ASK_FOR_REVIEW)) {
            List<String> reviewersEmail = this.findAllReviewersEmail(executionContext, apiId);
            this.emailService.sendAsyncEmailNotification(executionContext, new EmailNotificationBuilder().params(new NotificationParamsBuilder().api(apiEntity).user(user).build()).to(reviewersEmail.toArray(new String[reviewersEmail.size()])).template(EmailNotificationBuilder.EmailTemplate.API_ASK_FOR_REVIEW).build());
        }
        HashMap<Audit.AuditProperties, String> properties = new HashMap<Audit.AuditProperties, String>();
        properties.put(Audit.AuditProperties.USER, userId);
        properties.put(Audit.AuditProperties.API, apiId);
        Workflow.AuditEvent evtType = null;
        switch (workflowState) {
            case REQUEST_FOR_CHANGES: {
                evtType = Workflow.AuditEvent.API_REVIEW_REJECTED;
                break;
            }
            case REVIEW_OK: {
                evtType = Workflow.AuditEvent.API_REVIEW_ACCEPTED;
                break;
            }
            default: {
                evtType = Workflow.AuditEvent.API_REVIEW_ASKED;
            }
        }
        this.auditService.createApiAuditLog(executionContext, apiId, properties, (Audit.AuditEvent)evtType, new Date(), null, workflow);
        return apiEntity;
    }

    private List<String> findAllReviewersEmail(ExecutionContext executionContext, String apiId) {
        RolePermissionAction[] acls = new RolePermissionAction[]{RolePermissionAction.UPDATE};
        Set reviewerEmails = this.roleService.findByScope(RoleScope.API, executionContext.getOrganizationId()).stream().filter(role -> this.roleService.hasPermission(role.getPermissions(), (Permission)ApiPermission.REVIEWS, acls)).flatMap(role -> this.membershipService.getMembershipsByReferenceAndRole(MembershipReferenceType.API, apiId, role.getId()).stream()).filter(m -> m.getMemberType().equals((Object)MembershipMemberType.USER)).map(MembershipEntity::getMemberId).distinct().map(id -> this.userService.findById(executionContext, (String)id)).map(UserEntity::getEmail).filter(Objects::nonNull).collect(Collectors.toSet());
        Set groups = this.findById(executionContext, apiId).getGroups();
        if (groups != null && !groups.isEmpty()) {
            groups.forEach(group -> reviewerEmails.addAll(this.roleService.findByScope(RoleScope.API, executionContext.getOrganizationId()).stream().filter(role -> this.roleService.hasPermission(role.getPermissions(), (Permission)ApiPermission.REVIEWS, acls)).flatMap(role -> this.membershipService.getMembershipsByReferenceAndRole(MembershipReferenceType.GROUP, (String)group, role.getId()).stream()).filter(m -> m.getMemberType().equals((Object)MembershipMemberType.USER)).map(MembershipEntity::getMemberId).distinct().map(id -> this.userService.findById(executionContext, (String)id)).map(UserEntity::getEmail).filter(Objects::nonNull).collect(Collectors.toSet())));
        }
        return new ArrayList<String>(reviewerEmails);
    }

    private ApiCriteria.Builder queryToCriteria(ExecutionContext executionContext, ApiQuery query) {
        ApiCriteria.Builder builder = new ApiCriteria.Builder().environmentId(executionContext.getEnvironmentId());
        if (query == null) {
            return builder;
        }
        builder.label(query.getLabel()).name(query.getName()).version(query.getVersion());
        if (!StringUtils.isBlank((CharSequence)query.getCategory())) {
            builder.category(this.categoryService.findById(query.getCategory(), executionContext.getEnvironmentId()).getId());
        }
        if (query.getGroups() != null && !query.getGroups().isEmpty()) {
            builder.groups((Collection)query.getGroups());
        }
        if (!StringUtils.isBlank((CharSequence)query.getState())) {
            builder.state(LifecycleState.valueOf((String)query.getState()));
        }
        if (query.getVisibility() != null) {
            builder.visibility(Visibility.valueOf((String)query.getVisibility().name()));
        }
        if (query.getLifecycleStates() != null) {
            builder.lifecycleStates(query.getLifecycleStates().stream().map(apiLifecycleState -> ApiLifecycleState.valueOf((String)apiLifecycleState.name())).collect(Collectors.toList()));
        }
        if (query.getIds() != null && !query.getIds().isEmpty()) {
            builder.ids(query.getIds());
        }
        if (query.getCrossId() != null && !query.getCrossId().isEmpty()) {
            builder.crossId(query.getCrossId());
        }
        return builder;
    }

    private void removeTag(ExecutionContext executionContext, String apiId, String tagId) throws TechnicalManagementException {
        try {
            io.gravitee.repository.management.model.Api api = this.findApiById(executionContext, apiId);
            io.gravitee.repository.management.model.Api previousApi = new io.gravitee.repository.management.model.Api(api);
            Api apiDefinition = (Api)this.objectMapper.readValue(api.getDefinition(), Api.class);
            if (apiDefinition.getTags().remove(tagId)) {
                api.setDefinition(this.objectMapper.writeValueAsString((Object)apiDefinition));
                io.gravitee.repository.management.model.Api updated = (io.gravitee.repository.management.model.Api)this.apiRepository.update((Object)api);
                this.triggerUpdateNotification(executionContext, api);
                this.auditService.createApiAuditLog(executionContext, api.getId(), Collections.emptyMap(), (Audit.AuditEvent)Api.AuditEvent.API_UPDATED, api.getUpdatedAt(), previousApi, updated);
            }
        }
        catch (Exception ex) {
            LOGGER.error("An error occurs while removing tag from API: {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while removing tag from API: " + apiId, ex);
        }
    }

    private ApiEntity updateLifecycle(ExecutionContext executionContext, String apiId, LifecycleState lifecycleState, String username) throws TechnicalException {
        Optional optApi = this.apiRepository.findById((Object)apiId);
        if (optApi.isPresent()) {
            io.gravitee.repository.management.model.Api api = (io.gravitee.repository.management.model.Api)optApi.get();
            io.gravitee.repository.management.model.Api previousApi = new io.gravitee.repository.management.model.Api(api);
            api.setUpdatedAt(new Date());
            api.setLifecycleState(lifecycleState);
            ApiEntity apiEntity = this.convert(executionContext, (io.gravitee.repository.management.model.Api)this.apiRepository.update((Object)api), this.getPrimaryOwner(executionContext, api), null);
            this.auditService.createApiAuditLog(executionContext, apiId, Collections.emptyMap(), (Audit.AuditEvent)Api.AuditEvent.API_UPDATED, api.getUpdatedAt(), previousApi, api);
            EventType eventType = null;
            switch (lifecycleState) {
                case STARTED: {
                    eventType = EventType.START_API;
                    break;
                }
                case STOPPED: {
                    eventType = EventType.STOP_API;
                    break;
                }
            }
            ApiEntity deployedApi = this.deployLastPublishedAPI(executionContext, apiId, username, eventType);
            if (deployedApi != null) {
                return deployedApi;
            }
            return apiEntity;
        }
        throw new ApiNotFoundException(apiId);
    }

    private void auditApiLogging(ExecutionContext executionContext, io.gravitee.repository.management.model.Api apiToUpdate, io.gravitee.repository.management.model.Api apiUpdated) {
        try {
            Api apiToUpdateDefinition = (Api)this.objectMapper.readValue(apiToUpdate.getDefinition(), Api.class);
            Logging loggingToUpdate = apiToUpdateDefinition.getProxy().getLogging();
            Api apiUpdatedDefinition = (Api)this.objectMapper.readValue(apiUpdated.getDefinition(), Api.class);
            Logging loggingUpdated = apiUpdatedDefinition.getProxy().getLogging();
            if (loggingToUpdate == loggingUpdated || loggingToUpdate != null && loggingUpdated != null && Objects.equals(loggingToUpdate.getMode(), loggingUpdated.getMode()) && Objects.equals(loggingToUpdate.getCondition(), loggingUpdated.getCondition())) {
                return;
            }
            Api.AuditEvent auditEvent = (loggingToUpdate == null || loggingToUpdate.getMode().equals((Object)LoggingMode.NONE)) && loggingUpdated != null && !loggingUpdated.getMode().equals((Object)LoggingMode.NONE) ? Api.AuditEvent.API_LOGGING_ENABLED : (loggingToUpdate != null && !loggingToUpdate.getMode().equals((Object)LoggingMode.NONE) && (loggingUpdated == null || loggingUpdated.getMode().equals((Object)LoggingMode.NONE)) ? Api.AuditEvent.API_LOGGING_DISABLED : Api.AuditEvent.API_LOGGING_UPDATED);
            this.auditService.createApiAuditLog(executionContext, apiUpdated.getId(), Collections.emptyMap(), (Audit.AuditEvent)auditEvent, new Date(), loggingToUpdate, loggingUpdated);
        }
        catch (Exception ex) {
            LOGGER.error("An error occurs while auditing API logging configuration for API: {}", (Object)apiUpdated.getId(), (Object)ex);
            throw new TechnicalManagementException("An error occurs while auditing API logging configuration for API: " + apiUpdated.getId(), ex);
        }
    }

    private List<ApiEntity> convert(ExecutionContext executionContext, List<io.gravitee.repository.management.model.Api> apis) throws TechnicalException {
        Set<String> groupIds;
        if (apis == null || apis.isEmpty()) {
            return Collections.emptyList();
        }
        RoleEntity primaryOwnerRole = this.roleService.findPrimaryOwnerRoleByOrganization(executionContext.getOrganizationId(), RoleScope.API);
        if (primaryOwnerRole == null) {
            throw new RoleNotFoundException("API_PRIMARY_OWNER");
        }
        List<String> apiIds = apis.stream().map(io.gravitee.repository.management.model.Api::getId).collect(Collectors.toList());
        Set<MemberEntity> memberships = this.membershipService.getMembersByReferencesAndRole(executionContext, MembershipReferenceType.API, apiIds, primaryOwnerRole.getId());
        int poMissing = apis.size() - memberships.size();
        Stream<Object> streamApis = apis.stream();
        if (poMissing > 0) {
            Set apiMembershipsIds = memberships.stream().map(MemberEntity::getReferenceId).collect(Collectors.toSet());
            apiIds.removeAll(apiMembershipsIds);
            Optional optionalApisAsString = apiIds.stream().reduce((a, b) -> a + " / " + b);
            String apisAsString = "?";
            if (optionalApisAsString.isPresent()) {
                apisAsString = (String)optionalApisAsString.get();
            }
            LOGGER.error("{} apis has no identified primary owners in this list {}.", (Object)poMissing, (Object)apisAsString);
            streamApis = streamApis.filter(api -> !apiIds.contains(api.getId()));
        }
        HashMap apiToMember = new HashMap(memberships.size());
        memberships.forEach(membership -> apiToMember.put(membership.getReferenceId(), membership.getId()));
        HashMap primaryOwnerIdToPrimaryOwnerEntity = new HashMap(memberships.size());
        List<String> userIds = memberships.stream().filter(membership -> membership.getType() == MembershipMemberType.USER).map(MemberEntity::getId).collect(Collectors.toList());
        if (userIds != null && !userIds.isEmpty()) {
            this.userService.findByIds(executionContext, userIds).forEach(userEntity -> primaryOwnerIdToPrimaryOwnerEntity.put(userEntity.getId(), new PrimaryOwnerEntity(userEntity)));
        }
        if ((groupIds = memberships.stream().filter(membership -> membership.getType() == MembershipMemberType.GROUP).map(MemberEntity::getId).collect(Collectors.toSet())) != null && !groupIds.isEmpty()) {
            this.groupService.findByIds(groupIds).forEach(groupEntity -> primaryOwnerIdToPrimaryOwnerEntity.put(groupEntity.getId(), new PrimaryOwnerEntity(groupEntity)));
        }
        List<CategoryEntity> categories = this.categoryService.findAll(executionContext.getEnvironmentId());
        return streamApis.map(publicApi -> this.convert(executionContext, (io.gravitee.repository.management.model.Api)publicApi, (PrimaryOwnerEntity)primaryOwnerIdToPrimaryOwnerEntity.get(apiToMember.get(publicApi.getId())), categories)).collect(Collectors.toList());
    }

    private ApiEntity convert(ExecutionContext executionContext, io.gravitee.repository.management.model.Api api) {
        return this.convert(executionContext, api, null, null, true);
    }

    private ApiEntity convert(ExecutionContext executionContext, io.gravitee.repository.management.model.Api api, boolean readDatabaseFlows) {
        return this.convert(executionContext, api, null, null, readDatabaseFlows);
    }

    private ApiEntity convert(ExecutionContext executionContext, io.gravitee.repository.management.model.Api api, PrimaryOwnerEntity primaryOwner, List<CategoryEntity> categories) {
        return this.convert(executionContext, api, primaryOwner, categories, true);
    }

    private ApiEntity convert(ExecutionContext executionContext, io.gravitee.repository.management.model.Api api, PrimaryOwnerEntity primaryOwner, List<CategoryEntity> categories, boolean readDatabaseFlows) {
        List<Workflow> workflows;
        Set apiCategories;
        ApiEntity apiEntity = this.apiConverter.toApiEntity(api, primaryOwner);
        Set<PlanEntity> plans = this.planService.findByApi(executionContext, api.getId());
        apiEntity.setPlans(plans);
        if (readDatabaseFlows) {
            List<Flow> flows = this.flowService.findByReference(FlowReferenceType.API, api.getId());
            apiEntity.setFlows(flows);
        }
        if ((apiCategories = api.getCategories()) != null) {
            if (categories == null) {
                categories = this.categoryService.findAll(executionContext.getEnvironmentId());
            }
            HashSet newApiCategories = new HashSet(apiCategories.size());
            for (String apiView : apiCategories) {
                Optional<CategoryEntity> optionalView = categories.stream().filter(c -> apiView.equals(c.getId())).findAny();
                optionalView.ifPresent(category -> newApiCategories.add(category.getKey()));
            }
            apiEntity.setCategories(newApiCategories);
        }
        if (this.parameterService.findAsBoolean(executionContext, Key.API_REVIEW_ENABLED, api.getEnvironmentId(), ParameterReferenceType.ENVIRONMENT) && (workflows = this.workflowService.findByReferenceAndType(WorkflowReferenceType.API, api.getId(), WorkflowType.REVIEW)) != null && !workflows.isEmpty()) {
            apiEntity.setWorkflowState(WorkflowState.valueOf((String)workflows.get(0).getState()));
        }
        return apiEntity;
    }

    private io.gravitee.repository.management.model.Api convert(ExecutionContext executionContext, String apiId, UpdateApiEntity updateApiEntity, String apiDefinition) {
        io.gravitee.repository.management.model.Api api = new io.gravitee.repository.management.model.Api();
        api.setId(apiId.trim());
        api.setCrossId(updateApiEntity.getCrossId());
        if (updateApiEntity.getVisibility() != null) {
            api.setVisibility(Visibility.valueOf((String)updateApiEntity.getVisibility().toString()));
        }
        api.setVersion(updateApiEntity.getVersion().trim());
        api.setName(updateApiEntity.getName().trim());
        api.setDescription(updateApiEntity.getDescription().trim());
        api.setPicture(updateApiEntity.getPicture());
        api.setBackground(updateApiEntity.getBackground());
        api.setDefinition(this.buildApiDefinition(apiId, apiDefinition, updateApiEntity));
        Set apiCategories = updateApiEntity.getCategories();
        if (apiCategories != null) {
            List<CategoryEntity> categories = this.categoryService.findAll(executionContext.getEnvironmentId());
            HashSet newApiCategories = new HashSet(apiCategories.size());
            for (String apiCategory : apiCategories) {
                Optional<CategoryEntity> optionalCategory = categories.stream().filter(c -> apiCategory.equals(c.getKey()) || apiCategory.equals(c.getId())).findAny();
                optionalCategory.ifPresent(category -> newApiCategories.add(category.getId()));
            }
            api.setCategories(newApiCategories);
        }
        if (updateApiEntity.getLabels() != null) {
            api.setLabels(new ArrayList(new HashSet(updateApiEntity.getLabels())));
        }
        api.setGroups(updateApiEntity.getGroups());
        api.setDisableMembershipNotifications(updateApiEntity.isDisableMembershipNotifications());
        if (updateApiEntity.getLifecycleState() != null) {
            api.setApiLifecycleState(ApiLifecycleState.valueOf((String)updateApiEntity.getLifecycleState().name()));
        }
        return api;
    }

    private LifecycleState convert(EventType eventType) {
        LifecycleState lifecycleState;
        switch (eventType) {
            case START_API: {
                lifecycleState = LifecycleState.STARTED;
                break;
            }
            case STOP_API: {
                lifecycleState = LifecycleState.STOPPED;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown EventType " + eventType + " to convert EventType into Lifecycle");
            }
        }
        return lifecycleState;
    }

    private ProxyModelEntity convert(Proxy proxy) {
        ProxyModelEntity proxyModelEntity = new ProxyModelEntity();
        proxyModelEntity.setCors(proxy.getCors());
        proxyModelEntity.setFailover(proxy.getFailover());
        proxyModelEntity.setGroups(proxy.getGroups());
        proxyModelEntity.setLogging(proxy.getLogging());
        proxyModelEntity.setPreserveHost(proxy.isPreserveHost());
        proxyModelEntity.setStripContextPath(proxy.isStripContextPath());
        proxyModelEntity.setVirtualHosts(proxy.getVirtualHosts());
        if (proxy.getVirtualHosts() != null && !proxy.getVirtualHosts().isEmpty()) {
            proxyModelEntity.setContextPath(((VirtualHost)proxy.getVirtualHosts().get(0)).getPath());
        }
        return proxyModelEntity;
    }

    private Page<ApiEntity> loadPage(ExecutionContext executionContext, Collection<String> apiIds, Pageable pageable) throws TechnicalException {
        pageable = this.buildPageable(pageable);
        int totalCount = apiIds.size();
        int startIndex = (pageable.getPageNumber() - 1) * pageable.getPageSize();
        if (pageable.getPageNumber() < 1 || totalCount > 0 && startIndex >= totalCount) {
            throw new PaginationInvalidException();
        }
        List subsetApiIds = apiIds.stream().skip(startIndex).limit(pageable.getPageSize()).collect(Collectors.toList());
        Comparator<String> orderingComparator = Comparator.comparingInt(subsetApiIds::indexOf);
        List subsetApis = subsetApiIds.isEmpty() ? Collections.emptyList() : this.convert(executionContext, this.apiRepository.search(new ApiCriteria.Builder().environmentId(executionContext.getEnvironmentId()).ids(subsetApiIds).build(), null, new PageableBuilder().pageNumber(0).pageSize(subsetApiIds.size()).build(), ApiFieldFilter.allFields()).getContent());
        subsetApis.sort((o1, o2) -> orderingComparator.compare(o1.getId(), o2.getId()));
        return new Page(subsetApis, pageable.getPageNumber(), pageable.getPageSize(), (long)apiIds.size());
    }

    private Pageable buildPageable(Pageable pageable) {
        if (pageable == null) {
            return new PageableImpl(1, Integer.MAX_VALUE);
        }
        return pageable;
    }

    @Override
    public Map<String, List<GroupMemberEntity>> getGroupsWithMembers(ExecutionContext executionContext, String apiId) throws TechnicalManagementException {
        try {
            io.gravitee.repository.management.model.Api api = (io.gravitee.repository.management.model.Api)this.apiRepository.findById((Object)apiId).orElseThrow(() -> new ApiNotFoundException(apiId));
            ArrayList<String> apiGroups = api.getGroups() == null ? new ArrayList<String>() : new ArrayList(api.getGroups());
            Set<MemberEntity> members = this.membershipService.getMembersByReferencesAndRole(executionContext, MembershipReferenceType.GROUP, apiGroups, null);
            return members.stream().peek(member -> member.setRoles(this.computeMemberRoles(executionContext, api, (MemberEntity)member))).collect(Collectors.groupingBy(MemberEntity::getReferenceId, Collectors.mapping(GroupMemberEntity::new, Collectors.toList())));
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("An error has occurred while trying to retrieve groups for API " + apiId);
        }
    }

    private List<RoleEntity> computeMemberRoles(ExecutionContext executionContext, io.gravitee.repository.management.model.Api api, MemberEntity member) {
        return member.getRoles().stream().map(role -> role.isApiPrimaryOwner() ? this.mapApiPrimaryOwnerRole(executionContext, api, member.getReferenceId()) : role).collect(Collectors.toList());
    }

    private RoleEntity mapApiPrimaryOwnerRole(ExecutionContext executionContext, io.gravitee.repository.management.model.Api api, String groupId) {
        GroupEntity memberGroup = this.groupService.findById(executionContext, groupId);
        String groupDefaultApiRoleName = memberGroup.getRoles() == null ? null : (String)memberGroup.getRoles().get(RoleScope.API);
        PrimaryOwnerEntity primaryOwner = this.getPrimaryOwner(executionContext, api);
        RoleEntity role = new RoleEntity();
        role.setScope(RoleScope.API);
        if (memberGroup.getId().equals(primaryOwner.getId())) {
            role.setName(SystemRole.PRIMARY_OWNER.name());
        } else if (groupDefaultApiRoleName != null) {
            this.roleService.findByScopeAndName(RoleScope.API, groupDefaultApiRoleName, executionContext.getOrganizationId()).ifPresent(groupRole -> role.setName(groupRole.getName()));
        }
        return role;
    }

    protected void encryptProperties(List<PropertyEntity> properties) {
        for (PropertyEntity property : properties) {
            if (!property.isEncryptable() || property.isEncrypted()) continue;
            try {
                property.setValue(this.dataEncryptor.encrypt(property.getValue()));
                property.setEncrypted(true);
            }
            catch (GeneralSecurityException e) {
                LOGGER.error("Error encrypting property value", (Throwable)e);
            }
        }
    }

    private void triggerUpdateNotification(ExecutionContext executionContext, io.gravitee.repository.management.model.Api api) {
        ApiEntity apiEntity = this.apiConverter.toApiEntity(api, null);
        this.triggerNotification(executionContext, apiEntity.getId(), ApiHook.API_UPDATED, apiEntity);
    }

    private void triggerApiDeprecatedNotification(ExecutionContext executionContext, String apiId, ApiEntity apiEntity) {
        this.triggerNotification(executionContext, apiId, ApiHook.API_DEPRECATED, apiEntity);
    }

    private void triggerNotification(ExecutionContext executionContext, String apiId, ApiHook hook, ApiEntity apiEntity) {
        String userId = this.getAuthenticatedUsername();
        if (userId != null && !this.getAuthenticatedUser().isSystem()) {
            this.notifierService.trigger(executionContext, hook, apiId, new NotificationParamsBuilder().api(apiEntity).user(this.userService.findById(executionContext, userId)).build());
        }
    }

    @Override
    public Map<String, Long> countPublishedByUserGroupedByCategories(String userId) {
        Page foundApiIds;
        ArrayList<ApiCriteria> criteriaList = new ArrayList<ApiCriteria>();
        criteriaList.add(new ApiCriteria.Builder().visibility(Visibility.PUBLIC).lifecycleStates(List.of(ApiLifecycleState.PUBLISHED)).build());
        if (userId != null) {
            List<String> userGroupIdsWithApiRole;
            List<String> userMembershipApiIds = this.getUserMembershipApiIds(userId);
            if (!userMembershipApiIds.isEmpty()) {
                criteriaList.add(new ApiCriteria.Builder().lifecycleStates(List.of(ApiLifecycleState.PUBLISHED)).ids(userMembershipApiIds).build());
            }
            if (!(userGroupIdsWithApiRole = this.getUserGroupIdsWithApiRole(userId)).isEmpty()) {
                criteriaList.add(new ApiCriteria.Builder().lifecycleStates(List.of(ApiLifecycleState.PUBLISHED)).groups(userGroupIdsWithApiRole).build());
            }
        }
        if ((foundApiIds = this.apiRepository.searchIds(criteriaList, new PageableBuilder().pageSize(Integer.MAX_VALUE).build(), null)).getContent() == null || foundApiIds.getContent().isEmpty()) {
            return Collections.emptyMap();
        }
        return this.apiRepository.search(new ApiCriteria.Builder().ids((Collection)foundApiIds.getContent()).build(), null, ApiFieldFilter.defaultFields()).filter(api -> api.getCategories() != null && !api.getCategories().isEmpty()).flatMap(api -> api.getCategories().stream().map(cat -> Pair.of((Object)cat, (Object)api))).collect(Collectors.groupingBy(Pair::getKey, HashMap::new, Collectors.counting()));
    }

    @Override
    public long countByCategoryForUser(ExecutionContext executionContext, String categoryId, String userId) {
        List<ApiCriteria> apiCriteriaList;
        if (this.isEnvironmentAdmin()) {
            apiCriteriaList = List.of(new ApiCriteria.Builder().category(categoryId).build());
        } else {
            ApiQuery apiQuery = new ApiQuery();
            apiQuery.setCategory(categoryId);
            apiCriteriaList = this.computeApiCriteriaForUser(executionContext, userId, apiQuery, false);
        }
        PageableImpl pageable = new PageableImpl(1, Integer.MAX_VALUE);
        List apiIds = this.apiRepository.searchIds(apiCriteriaList, ApiServiceImpl.convert((Pageable)pageable), null).getContent();
        return apiIds == null ? 0L : (long)apiIds.size();
    }

    private List<String> getUserGroupIdsWithApiRole(String userId) {
        return this.membershipService.getMembershipsByMemberAndReference(MembershipMemberType.USER, userId, MembershipReferenceType.GROUP).stream().filter(m -> {
            RoleEntity roleInGroup = this.roleService.findById(m.getRoleId());
            return m.getRoleId() != null && roleInGroup.getScope().equals((Object)RoleScope.API);
        }).map(MembershipEntity::getReferenceId).collect(Collectors.toList());
    }

    private List<String> getUserMembershipApiIds(String userId) {
        return this.membershipService.getMembershipsByMemberAndReference(MembershipMemberType.USER, userId, MembershipReferenceType.API).stream().map(MembershipEntity::getReferenceId).collect(Collectors.toList());
    }

    private static class MemberToImport {
        private String source;
        private String sourceId;
        private List<String> roles;
        private String role;

        public MemberToImport() {
        }

        public MemberToImport(String source, String sourceId, List<String> roles, String role) {
            this.source = source;
            this.sourceId = sourceId;
            this.roles = roles;
            this.role = role;
        }

        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public String getSourceId() {
            return this.sourceId;
        }

        public void setSourceId(String sourceId) {
            this.sourceId = sourceId;
        }

        public List<String> getRoles() {
            return this.roles;
        }

        public void setRoles(List<String> roles) {
            this.roles = roles;
        }

        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MemberToImport that = (MemberToImport)o;
            return this.source.equals(that.source) && this.sourceId.equals(that.sourceId);
        }

        public int hashCode() {
            int result = this.source.hashCode();
            result = 31 * result + this.sourceId.hashCode();
            return result;
        }
    }
}

