/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.search.lucene.searcher;

import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.search.Indexable;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.impl.search.SearchResult;
import io.gravitee.rest.api.service.impl.search.lucene.searcher.AbstractDocumentSearcher;
import io.gravitee.rest.api.service.search.query.Query;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.springframework.stereotype.Component;

@Component
public class ApiDocumentSearcher
extends AbstractDocumentSearcher {
    public static final String FIELD_API_TYPE_VALUE = "api";
    private static final Map<String, Float> API_FIELD_BOOST = Map.of("name", Float.valueOf(20.0f), "name_lowercase", Float.valueOf(20.0f), "name_split", Float.valueOf(18.0f), "paths", Float.valueOf(10.0f), "hosts", Float.valueOf(10.0f), "labels", Float.valueOf(8.0f), "description", Float.valueOf(5.0f), "metadata", Float.valueOf(4.0f), "tags", Float.valueOf(1.0f));
    private static final String[] API_FIELD_SEARCH = new String[]{"id", "name", "name_sorted", "name_lowercase", "name_split", "description", "description_lowercase", "description_split", "ownerName", "labels", "labels_split", "tags", "tags_split", "categories", "categories_split", "paths", "paths_split", "hosts", "hosts_split", "metadata", "metadata_split"};
    private static final String[] AUTHORIZED_EXPLICIT_FILTER = new String[]{"name", "ownerName", "labels", "categories", "description", "paths", "tags"};

    private BooleanQuery.Builder buildApiQuery(ExecutionContext executionContext, Optional<org.apache.lucene.search.Query> filterQuery) {
        BooleanQuery.Builder apiQuery = new BooleanQuery.Builder().add((org.apache.lucene.search.Query)new TermQuery(new Term("type", FIELD_API_TYPE_VALUE)), BooleanClause.Occur.FILTER);
        if (executionContext.hasEnvironmentId()) {
            apiQuery.add((org.apache.lucene.search.Query)this.buildEnvCriteria(executionContext), BooleanClause.Occur.FILTER);
        }
        filterQuery.ifPresent(q -> apiQuery.add(q, BooleanClause.Occur.FILTER));
        return apiQuery;
    }

    private Optional<BooleanQuery> buildIdsQuery(Query query) {
        if (!StringUtils.isBlank((CharSequence)query.getQuery()) && query.getIds() != null && !query.getIds().isEmpty()) {
            BooleanQuery.Builder mainQuery = new BooleanQuery.Builder();
            query.getIds().forEach(id -> mainQuery.add((org.apache.lucene.search.Query)new TermQuery(new Term("id", (String)id)), BooleanClause.Occur.SHOULD));
            return Optional.of(mainQuery.build());
        }
        return Optional.empty();
    }

    private Optional<BooleanQuery> buildExactMatchQuery(ExecutionContext executionContext, Query query, Optional<org.apache.lucene.search.Query> filterQuery) throws ParseException {
        if (!StringUtils.isBlank((CharSequence)query.getQuery())) {
            BooleanQuery.Builder apiQuery = this.buildApiQuery(executionContext, filterQuery);
            MultiFieldQueryParser apiParser = new MultiFieldQueryParser(API_FIELD_SEARCH, (Analyzer)new KeywordAnalyzer(), API_FIELD_BOOST);
            String queryEscaped = QueryParserBase.escape((String)query.getQuery());
            org.apache.lucene.search.Query queryParsed = apiParser.parse(queryEscaped);
            apiQuery.add(queryParsed, BooleanClause.Occur.MUST);
            return Optional.of(apiQuery.build());
        }
        return Optional.empty();
    }

    private Optional<BooleanQuery> buildWildcardQuery(ExecutionContext executionContext, Query query, Optional<org.apache.lucene.search.Query> baseFilterQuery) throws ParseException {
        if (!StringUtils.isBlank((CharSequence)query.getQuery())) {
            BooleanQuery.Builder mainQuery = this.buildApiQuery(executionContext, baseFilterQuery);
            MultiFieldQueryParser apiParser = new MultiFieldQueryParser(API_FIELD_SEARCH, (Analyzer)new KeywordAnalyzer(), API_FIELD_BOOST);
            apiParser.setAllowLeadingWildcard(true);
            apiParser.setFuzzyMinSim(0.6f);
            String queryEscaped = QueryParserBase.escape((String)query.getQuery());
            org.apache.lucene.search.Query queryParsed = apiParser.parse(queryEscaped);
            mainQuery.add(queryParsed, BooleanClause.Occur.SHOULD);
            mainQuery.add((org.apache.lucene.search.Query)this.buildApiFields(query.getQuery(), BooleanClause.Occur.SHOULD, new org.apache.lucene.search.Query[0]), BooleanClause.Occur.MUST);
            return Optional.of(mainQuery.build());
        }
        return Optional.empty();
    }

    @Override
    public SearchResult search(ExecutionContext executionContext, Query query) throws TechnicalException {
        try {
            Optional<org.apache.lucene.search.Query> baseFilterQuery = this.buildFilterQuery("id", query.getFilters());
            BooleanQuery.Builder apiQuery = new BooleanQuery.Builder();
            this.buildExplicitQuery(executionContext, query, baseFilterQuery).ifPresent(q -> apiQuery.add((org.apache.lucene.search.Query)q, BooleanClause.Occur.MUST));
            this.buildExactMatchQuery(executionContext, query, baseFilterQuery).ifPresent(q -> apiQuery.add((org.apache.lucene.search.Query)new BoostQuery((org.apache.lucene.search.Query)q, 4.0f), BooleanClause.Occur.SHOULD));
            this.buildWildcardQuery(executionContext, query, baseFilterQuery).ifPresent(q -> apiQuery.add((org.apache.lucene.search.Query)q, BooleanClause.Occur.SHOULD));
            this.buildIdsQuery(query).ifPresent(q -> apiQuery.add((org.apache.lucene.search.Query)q, BooleanClause.Occur.SHOULD));
            return this.search((org.apache.lucene.search.Query)apiQuery.build(), query.getSort());
        }
        catch (ParseException pe) {
            this.logger.error("Invalid query to search for API documents", (Throwable)pe);
            throw new TechnicalException("Invalid query to search for API documents", (Throwable)pe);
        }
    }

    private Optional<BooleanQuery> buildExplicitQuery(ExecutionContext executionContext, Query query, Optional<org.apache.lucene.search.Query> baseFilterQuery) {
        BooleanQuery.Builder filtersQuery = this.buildApiQuery(executionContext, baseFilterQuery);
        String rest = this.completeQueryWithFilters(query, filtersQuery);
        if (!rest.equals(query.getQuery())) {
            query.setQuery(rest);
            return Optional.of(filtersQuery.build());
        }
        return Optional.empty();
    }

    protected String completeQueryWithFilters(Query query, BooleanQuery.Builder mainQuery) {
        if (StringUtils.isBlank((CharSequence)query.getQuery())) {
            return "";
        }
        try {
            BooleanQuery.Builder restQuery = new BooleanQuery.Builder();
            Set<String> rest = this.appendExplicitFilters(query.getQuery(), mainQuery, restQuery);
            BooleanQuery build = restQuery.build();
            if (build.clauses().size() > 0) {
                mainQuery.add((org.apache.lucene.search.Query)build, ((BooleanClause)build.clauses().get(0)).getOccur());
            }
            if (rest != null) {
                return rest.stream().collect(Collectors.joining(" "));
            }
            return "";
        }
        catch (ParseException e) {
            e.printStackTrace();
            return query.getQuery();
        }
    }

    protected Set<String> appendExplicitFilters(String query, BooleanQuery.Builder mainQuery, BooleanQuery.Builder restQuery) throws ParseException {
        QueryParser parser = new QueryParser("", (Analyzer)new KeywordAnalyzer());
        parser.setAllowLeadingWildcard(true);
        org.apache.lucene.search.Query parse = parser.parse(query);
        if (this.hasExplicitFilter(query)) {
            return this.appendExplicitFilters(parse, mainQuery, restQuery, null);
        }
        return Collections.singleton(query);
    }

    private Set<String> appendExplicitFilters(org.apache.lucene.search.Query query, BooleanQuery.Builder mainQuery, BooleanQuery.Builder restQuery, BooleanClause clause) {
        BooleanClause.Occur currentOccur;
        HashSet<String> rest = new HashSet<String>();
        BooleanClause.Occur occur = currentOccur = clause != null ? clause.getOccur() : BooleanClause.Occur.FILTER;
        if (query instanceof TermQuery) {
            TermQuery tQuery = (TermQuery)query;
            Term term = tQuery.getTerm();
            if (Arrays.stream(AUTHORIZED_EXPLICIT_FILTER).anyMatch(field -> field.equals(term.field()))) {
                mainQuery.add(this.buildQueryFilter(term), currentOccur);
            } else if (clause != null) {
                restQuery.add((org.apache.lucene.search.Query)this.buildApiFields(term.text(), BooleanClause.Occur.SHOULD, new org.apache.lucene.search.Query[0]), clause.getOccur());
            } else {
                rest.add(term.text());
            }
        } else if (query instanceof BooleanQuery) {
            BooleanQuery bQuery = (BooleanQuery)query;
            List clauses = bQuery.clauses();
            if (!clauses.isEmpty()) {
                BooleanQuery.Builder subQuery = new BooleanQuery.Builder();
                for (BooleanClause _clause : clauses) {
                    org.apache.lucene.search.Query innerQuery = _clause.getQuery();
                    Set<String> innerRest = this.appendExplicitFilters(innerQuery, subQuery, restQuery, _clause);
                    if (innerRest == null) {
                        return null;
                    }
                    rest.addAll(innerRest);
                }
                mainQuery.add((org.apache.lucene.search.Query)subQuery.build(), BooleanClause.Occur.FILTER);
            }
        } else if (query instanceof WildcardQuery) {
            WildcardQuery wQuery = (WildcardQuery)query;
            Term term = wQuery.getTerm();
            if (Arrays.stream(AUTHORIZED_EXPLICIT_FILTER).anyMatch(field -> field.equals(term.field()))) {
                mainQuery.add((org.apache.lucene.search.Query)wQuery, currentOccur);
            } else {
                rest.add(term.text());
            }
        } else {
            return null;
        }
        return rest;
    }

    private org.apache.lucene.search.Query buildQueryFilter(Term term) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        String field = term.field();
        String text = term.text();
        if ("categories".equals(term.field())) {
            text = ApiDocumentSearcher.formatCategoryField(term.text());
        } else if (!"paths".equals(term.field()) && !"tags".equals(term.field())) {
            text = text.toLowerCase();
            field = field.concat("_lowercase");
        }
        return builder.add((org.apache.lucene.search.Query)new PhraseQuery(field, new String[]{text}), BooleanClause.Occur.SHOULD).add((org.apache.lucene.search.Query)new WildcardQuery(new Term(field, text)), BooleanClause.Occur.SHOULD).build();
    }

    public static String formatCategoryField(String category) {
        return category.toLowerCase().replaceAll(" ", "-");
    }

    private org.apache.lucene.search.Query toWildcard(String field, String query) {
        return new WildcardQuery(new Term(field, "*" + query + "*"));
    }

    private BooleanQuery buildApiFields(String query, BooleanClause.Occur occur, org.apache.lucene.search.Query ... queries) {
        String[] tokens;
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        if (queries != null) {
            for (org.apache.lucene.search.Query q : queries) {
                builder.add(q, occur);
            }
        }
        for (String token : tokens = query.split(" ")) {
            builder.add((org.apache.lucene.search.Query)new BoostQuery(this.toWildcard("name", token), 12.0f), occur).add((org.apache.lucene.search.Query)new BoostQuery(this.toWildcard("name_lowercase", token.toLowerCase()), 10.0f), occur).add((org.apache.lucene.search.Query)new BoostQuery(this.toWildcard("paths", token), 8.0f), occur).add(this.toWildcard("description", token), occur).add(this.toWildcard("description_lowercase", token.toLowerCase()), occur).add(this.toWildcard("hosts", token), occur).add(this.toWildcard("labels", token), occur).add(this.toWildcard("categories", token), occur).add(this.toWildcard("tags", token), occur).add(this.toWildcard("metadata", token), occur);
        }
        return builder.build();
    }

    private BooleanQuery buildEnvCriteria(ExecutionContext executionContext) {
        return new BooleanQuery.Builder().add((org.apache.lucene.search.Query)new TermQuery(new Term("reference_type", GraviteeContext.ReferenceContextType.ENVIRONMENT.name())), BooleanClause.Occur.FILTER).add((org.apache.lucene.search.Query)new TermQuery(new Term("reference_id", executionContext.getEnvironmentId())), BooleanClause.Occur.FILTER).build();
    }

    private boolean hasExplicitFilter(String query) {
        if (query != null) {
            return Arrays.asList(AUTHORIZED_EXPLICIT_FILTER).stream().anyMatch(field -> query.contains(field + ":"));
        }
        return false;
    }

    @Override
    public boolean handle(Class<? extends Indexable> source) {
        return source.isAssignableFrom(ApiEntity.class);
    }
}

