/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.plugin.connector.ConnectorPlugin;
import io.gravitee.plugin.connector.ConnectorPluginManager;
import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.rest.api.model.ConnectorPluginEntity;
import io.gravitee.rest.api.service.ConnectorService;
import io.gravitee.rest.api.service.JsonSchemaService;
import io.gravitee.rest.api.service.impl.AbstractPluginService;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConnectorServiceImpl
extends AbstractPluginService<ConnectorPlugin, ConnectorPluginEntity>
implements ConnectorService {
    @Autowired
    private JsonSchemaService jsonSchemaService;

    @Override
    public Set<ConnectorPluginEntity> findAll() {
        return super.list().stream().map(this::convert).collect(Collectors.toSet());
    }

    @Override
    public ConnectorPluginEntity findById(String connector) {
        ConnectorPlugin resourceDefinition = (ConnectorPlugin)super.get(connector);
        return this.convert((Plugin)resourceDefinition);
    }

    protected ConnectorPluginEntity convert(Plugin plugin) {
        ConnectorPluginEntity entity = new ConnectorPluginEntity();
        entity.setId(plugin.id());
        entity.setDescription(plugin.manifest().description());
        entity.setName(plugin.manifest().name());
        entity.setVersion(plugin.manifest().version());
        entity.setSupportedTypes(((ConnectorPluginManager)this.pluginManager).getConnector(plugin.id()).supportedTypes());
        return entity;
    }

    @Override
    public Optional<ConnectorPluginEntity> findBySupportedType(String type) {
        return super.list().stream().filter(plugin -> ((ConnectorPluginManager)this.pluginManager).getConnector(plugin.id()).supportedTypes().contains(type)).map(this::convert).findAny();
    }

    @Override
    public String validateConnectorConfiguration(String type, String configuration) {
        Optional<ConnectorPluginEntity> candidate = this.findBySupportedType(type);
        if (candidate.isPresent()) {
            return this.validateConfiguration(candidate.get(), configuration);
        }
        return configuration;
    }

    private String validateConfiguration(ConnectorPluginEntity plugin, String configuration) {
        if (plugin != null && configuration != null) {
            String schema = this.getSchema(plugin.getId());
            return this.jsonSchemaService.validate(schema, configuration);
        }
        return configuration;
    }
}

