/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.imports;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ImportJsonNode {
    private JsonNode jsonNode;

    public ImportJsonNode(JsonNode jsonNode) {
        this.jsonNode = jsonNode;
    }

    protected boolean hasField(String fieldName) {
        return this.jsonNode.hasNonNull(fieldName) && StringUtils.isNotEmpty((CharSequence)this.jsonNode.get(fieldName).asText());
    }

    protected boolean hasArray(String fieldName) {
        return this.jsonNode.has(fieldName) && this.jsonNode.get(fieldName).isArray();
    }

    protected String getField(String fieldName) {
        return this.jsonNode.hasNonNull(fieldName) ? this.jsonNode.get(fieldName).asText() : null;
    }

    protected void setField(String fieldName, String value) {
        ((ObjectNode)this.jsonNode).put(fieldName, value);
    }

    protected ArrayNode getArray(String fieldName) {
        return (ArrayNode)this.jsonNode.get(fieldName);
    }

    protected List<JsonNode> getChildNodesByName(String name) {
        ArrayList<JsonNode> nodes = new ArrayList<JsonNode>();
        if (this.jsonNode.has(name) && this.jsonNode.get(name).isArray()) {
            this.jsonNode.get(name).forEach(nodes::add);
        }
        return nodes;
    }

    public String asText() {
        return this.jsonNode.asText();
    }

    public JsonNode getJsonNode() {
        return this.jsonNode;
    }

    public String toString() {
        return this.jsonNode.toString();
    }
}

